/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.dispatch;

import com.dtolabs.rundeck.core.cli.CallableWrapperTask;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.data.SharedDataContextUtils;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.dispatch.Dispatchable;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResultImpl;
import com.dtolabs.rundeck.core.execution.dispatch.INodeEntryComparator;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import com.dtolabs.rundeck.core.execution.workflow.ReadableSharedContext;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WFSharedContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepDataResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Parallel;
import org.apache.tools.ant.taskdefs.Sequential;

public class ParallelNodeDispatcher
implements NodeDispatcher {
    public static final String STATUS_LISTENER_REF_ID = ParallelNodeDispatcher.class.getName() + ":status.listener";
    public static final String NODE_NAME_LOCAL_REF_ID = ParallelNodeDispatcher.class.getName() + ":node.name";
    public static final String NODE_USER_LOCAL_REF_ID = ParallelNodeDispatcher.class.getName() + ":node.user";
    private Framework framework;

    public ParallelNodeDispatcher(Framework framework) {
        this.framework = framework;
    }

    @Override
    public DispatcherResult dispatch(StepExecutionContext context, NodeStepExecutionItem item) throws DispatcherException {
        return this.dispatch(context, item, null);
    }

    @Override
    public DispatcherResult dispatch(StepExecutionContext context, Dispatchable item) throws DispatcherException {
        return this.dispatch(context, null, item);
    }

    public DispatcherResult dispatch(StepExecutionContext context, NodeStepExecutionItem item, Dispatchable toDispatch) throws DispatcherException {
        HashMap<String, NodeStepResult> failureMap;
        HashMap<String, NodeStepResult> resultMap;
        boolean success;
        FailedNodesListener failedListener;
        HashSet<String> nodeNames;
        block8: {
            INodeSet nodes = context.filteredNodes();
            boolean keepgoing = context.isKeepgoing();
            nodeNames = new HashSet<String>();
            failedListener = context.getExecutionListener().getFailedNodesListener();
            Project project = new Project();
            context.getExecutionListener().log(3, "preparing for parallel execution...(keepgoing? " + keepgoing + ", threads: " + context.getThreadCount() + ")");
            ParallelNodeDispatcher.configureNodeContextThreadLocalsForProject(project);
            Parallel parallelTask = new Parallel();
            parallelTask.setProject(project);
            parallelTask.setThreadCount(context.getThreadCount());
            parallelTask.setFailOnAny(!keepgoing);
            success = false;
            resultMap = new HashMap<String, NodeStepResult>();
            failureMap = new HashMap<String, NodeStepResult>();
            Collection<INodeEntry> nodes1 = nodes.getNodes();
            String rankProperty = null != context.getNodeRankAttribute() ? context.getNodeRankAttribute() : "nodename";
            boolean rankAscending = context.isNodeRankOrderAscending();
            INodeEntryComparator comparator = new INodeEntryComparator(rankProperty);
            TreeSet<INodeEntry> orderedNodes = new TreeSet<INodeEntry>(rankAscending ? comparator : Collections.reverseOrder(comparator));
            orderedNodes.addAll(nodes1);
            for (INodeEntry node : orderedNodes) {
                Callable<NodeStepResult> tocall = null != item ? this.execItemCallable(context, item, resultMap, node, failureMap) : this.dispatchableCallable(context, toDispatch, resultMap, node, failureMap);
                nodeNames.add(node.getNodename());
                context.getExecutionListener().log(3, "Create task for node: " + node.getNodename());
                CallableWrapperTask callableWrapperTask1 = new CallableWrapperTask(tocall);
                callableWrapperTask1.setProject(project);
                parallelTask.addTask((Task)callableWrapperTask1);
            }
            if (null != failedListener) {
                failedListener.matchedNodes(nodeNames);
            }
            context.getExecutionListener().log(3, "parallel dispatch to nodes: " + nodeNames);
            try {
                parallelTask.execute();
                success = true;
            }
            catch (BuildException e) {
                BuildException buildException = e;
                if (e.getCause() != null && e.getCause() instanceof DispatchFailure) {
                    DispatchFailure df = (DispatchFailure)e.getCause();
                    context.getExecutionListener().log(3, "Dispatch failed on node: " + df.getNode());
                }
                context.getExecutionListener().log(0, "Parallel node dispatch failed: " + e.getMessage());
                if (keepgoing) break block8;
                throw new DispatcherException(e);
            }
        }
        if (failureMap.size() > 0) {
            if (null != failedListener) {
                failedListener.nodesFailed(failureMap);
            }
            return new DispatcherResultImpl(failureMap, false);
        }
        if (null != failedListener && nodeNames.isEmpty()) {
            failedListener.nodesSucceeded();
        }
        boolean status = success;
        return new DispatcherResultImpl(resultMap, status, "Parallel dispatch: (" + status + ") " + resultMap);
    }

    private Callable dispatchableCallable(final ExecutionContext context, final Dispatchable toDispatch, final HashMap<String, NodeStepResult> resultMap, final INodeEntry node, final Map<String, NodeStepResult> failureMap) {
        return new Callable(){

            public Object call() throws Exception {
                NodeStepResult dispatch = toDispatch.dispatch(context, node);
                resultMap.put(node.getNodename(), dispatch);
                if (!dispatch.isSuccess()) {
                    failureMap.put(node.getNodename(), dispatch);
                    throw new DispatchFailure(node.getNodename());
                }
                return dispatch;
            }
        };
    }

    private ExecNodeStepCallable execItemCallable(StepExecutionContext context, NodeStepExecutionItem item, HashMap<String, NodeStepResult> resultMap, INodeEntry node, Map<String, NodeStepResult> failureMap) {
        return new ExecNodeStepCallable(context, item, resultMap, node, failureMap, this.framework);
    }

    public static void configureNodeContextThreadLocalsForProject(Project project) {
        InheritableThreadLocal localNodeName = new InheritableThreadLocal();
        InheritableThreadLocal localUserName = new InheritableThreadLocal();
        if (null == project.getReference(NODE_NAME_LOCAL_REF_ID)) {
            project.addReference(NODE_NAME_LOCAL_REF_ID, localNodeName);
        }
        if (null == project.getReference(NODE_USER_LOCAL_REF_ID)) {
            project.addReference(NODE_USER_LOCAL_REF_ID, localUserName);
        }
    }

    public static String getThreadLocalForProject(String nodeNameLocalRefId, Project project) {
        Object o = project.getReference(nodeNameLocalRefId);
        String thrNode = null;
        if (null != o && o instanceof InheritableThreadLocal) {
            InheritableThreadLocal local = (InheritableThreadLocal)o;
            thrNode = (String)local.get();
        }
        return thrNode;
    }

    public static void addNodeContextTasks(INodeEntry nodeentry, Project project, Sequential seq) {
        Task nodenamelocal = ParallelNodeDispatcher.genSetThreadLocalRefValue(NODE_NAME_LOCAL_REF_ID, nodeentry.getNodename());
        nodenamelocal.setProject(project);
        seq.addTask(nodenamelocal);
        if (null != nodeentry.extractUserName()) {
            Task userlocal = ParallelNodeDispatcher.genSetThreadLocalRefValue(NODE_USER_LOCAL_REF_ID, nodeentry.extractUserName());
            userlocal.setProject(project);
            seq.addTask(userlocal);
        }
    }

    private static Task genSetThreadLocalRefValue(String refid, String value) {
        SetThreadLocalTask task = new SetThreadLocalTask();
        task.setRefid(refid);
        task.setValue(value);
        return task;
    }

    public static class SetThreadLocalTask
    extends Task {
        private String value;
        private String refid;

        public void execute() throws BuildException {
            Object o = this.getProject().getReference(this.getRefid());
            if (o instanceof InheritableThreadLocal) {
                InheritableThreadLocal local = (InheritableThreadLocal)o;
                local.set(this.getValue());
            }
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getRefid() {
            return this.refid;
        }

        public void setRefid(String refid) {
            this.refid = refid;
        }
    }

    static class ExecNodeStepCallable
    implements Callable<NodeStepResult> {
        final StepExecutionContext context;
        final NodeStepExecutionItem item;
        final HashMap<String, NodeStepResult> resultMap;
        final INodeEntry node;
        final Map<String, NodeStepResult> failureMap;
        final Framework framework;

        ExecNodeStepCallable(StepExecutionContext context, NodeStepExecutionItem item, HashMap<String, NodeStepResult> resultMap, INodeEntry node, Map<String, NodeStepResult> failureMap, Framework framework) {
            this.context = context;
            this.item = item;
            this.resultMap = resultMap;
            this.node = node;
            this.failureMap = failureMap;
            this.framework = framework;
        }

        @Override
        public NodeStepResult call() {
            try {
                Object data;
                ContextView stepContextView = ContextView.nodeStep(this.context.getStepNumber(), this.node.getNodename());
                ReadableSharedContext outputContext = SharedDataContextUtils.outputContext(stepContextView);
                ExecutionContextImpl nodeDataContext = new ExecutionContextImpl.Builder(this.context).outputContext(outputContext).build();
                NodeStepResult result = this.framework.getExecutionService().executeNodeStep(nodeDataContext, this.item, this.node);
                WFSharedContext sharedContext = outputContext.getSharedContext();
                if (null != result.getSharedContext()) {
                    sharedContext.merge(result.getSharedContext());
                }
                if ((data = sharedContext.getData(stepContextView)) != null) {
                    sharedContext.merge(ContextView.node(this.node.getNodename()), data);
                }
                if (!(result = NodeStepDataResultImpl.with(result, sharedContext)).isSuccess()) {
                    this.failureMap.put(this.node.getNodename(), result);
                }
                this.resultMap.put(this.node.getNodename(), result);
                return result;
            }
            catch (NodeStepException e) {
                NodeStepResultImpl result = new NodeStepResultImpl(e, e.getFailureReason(), e.getMessage(), this.node);
                this.failureMap.put(this.node.getNodename(), result);
                return result;
            }
        }
    }

    private static class DispatchFailure
    extends Exception {
        private String node;

        private DispatchFailure(String node) {
            super("Dispatch failed on node: " + node);
            this.node = node;
        }

        public String getNode() {
            return this.node;
        }
    }
}

