/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.NodesetEmptyException;
import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.common.SelectorUtils;
import com.dtolabs.rundeck.core.data.BaseDataContext;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionListenerOverride;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.HandlerExecutionItem;
import com.dtolabs.rundeck.core.execution.HasFailureHandler;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.workflow.ControlBehavior;
import com.dtolabs.rundeck.core.execution.workflow.DataOutput;
import com.dtolabs.rundeck.core.execution.workflow.FlowController;
import com.dtolabs.rundeck.core.execution.workflow.IWorkflow;
import com.dtolabs.rundeck.core.execution.workflow.NodeRecorder;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WFSharedContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStatusDataResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStatusResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStatusResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.NodeDispatchStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResultWrapper;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class BaseWorkflowExecutor
implements WorkflowExecutor {
    protected static final String OPTION_KEY = "option";
    protected static final String SECURE_OPTION_KEY = "secureOption";
    protected static final String SECURE_OPTION_VALUE = "****";
    private final IFramework framework;
    protected static final WorkflowStatusResult WorkflowResultFailed = new BaseWorkflowStatusResult(false, null, ControlBehavior.Continue, null);

    public BaseWorkflowExecutor(IFramework framework) {
        this.framework = framework;
    }

    protected static WorkflowStatusDataResult workflowResult(boolean status, String statusString, ControlBehavior behavior, WFSharedContext sharedContext) {
        return new BaseWorkflowStatusResult(status, statusString, behavior, sharedContext);
    }

    static boolean isInnerLoop(WorkflowExecutionItem item) {
        return item.getWorkflow() instanceof StepFirstWrapper;
    }

    protected IFramework getFramework() {
        return this.framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final WorkflowExecutionResult executeWorkflow(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        WorkflowExecutionListener wlistener = this.getWorkflowListener(executionContext);
        if (null != wlistener && !BaseWorkflowExecutor.isInnerLoop(item)) {
            wlistener.beginWorkflowExecution(executionContext, item);
        }
        WorkflowExecutionResult result = null;
        try {
            result = this.executeWorkflowImpl(executionContext, item);
        }
        finally {
            if (null != wlistener && !BaseWorkflowExecutor.isInnerLoop(item)) {
                wlistener.finishWorkflowExecution(result, executionContext, item);
            }
        }
        return result;
    }

    protected WorkflowExecutionListener getWorkflowListener(ExecutionContext executionContext) {
        WorkflowExecutionListener wlistener = executionContext.getWorkflowExecutionListener();
        if (null != wlistener) {
            return wlistener;
        }
        ExecutionListener elistener = executionContext.getExecutionListener();
        if (null != elistener && elistener instanceof WorkflowExecutionListener) {
            return (WorkflowExecutionListener)((Object)elistener);
        }
        return null;
    }

    public abstract WorkflowExecutionResult executeWorkflowImpl(StepExecutionContext var1, WorkflowExecutionItem var2);

    protected StepExecutionResult executeWFItem(StepExecutionContext executionContext, Map<Integer, StepExecutionResult> failedMap, int c, StepExecutionItem cmd) {
        StepExecutionResult result;
        HasFailureHandler handles;
        StepExecutionItem handler;
        boolean hasHandler = cmd instanceof HasFailureHandler;
        boolean hideError = false;
        if (hasHandler && null != (handler = (handles = (HasFailureHandler)((Object)cmd)).getFailureHandler()) && handler instanceof HandlerExecutionItem) {
            hideError = ((HandlerExecutionItem)handler).isKeepgoingOnSuccess();
        }
        if (null != executionContext.getExecutionListener()) {
            executionContext.getExecutionListener().ignoreErrors(hideError);
        }
        if (null != executionContext.getExecutionListener()) {
            executionContext.getExecutionListener().log(4, c + ": Workflow step executing: " + cmd);
        }
        try {
            result = this.framework.getExecutionService().executeStep(ExecutionContextImpl.builder(executionContext).stepNumber(c).build(), cmd);
            if (!result.isSuccess()) {
                failedMap.put(c, result);
            }
        }
        catch (StepException e) {
            result = StepExecutionResultImpl.wrapStepException(e);
            failedMap.put(c, result);
        }
        if (null != executionContext.getExecutionListener()) {
            executionContext.getExecutionListener().log(4, c + ": Workflow step finished, result: " + result);
        }
        return result;
    }

    protected WorkflowStatusResult executeWorkflowItemsForNodeSet(StepExecutionContext executionContext, Map<Integer, StepExecutionResult> failedMap, List<StepExecutionResult> resultList, List<StepExecutionItem> iWorkflowCmdItems, boolean keepgoing, int beginStepIndex, WFSharedContext sharedContext) {
        boolean workflowsuccess = true;
        String statusString = null;
        ControlBehavior controlBehavior = null;
        WorkflowExecutionListener wlistener = this.getWorkflowListener(executionContext);
        int c = beginStepIndex;
        WFSharedContext currentData = new WFSharedContext(sharedContext);
        ExecutionContextImpl newContext = ExecutionContextImpl.builder(executionContext).sharedDataContext(currentData).build();
        for (StepExecutionItem cmd : iWorkflowCmdItems) {
            StepResultCapture stepResultCapture = this.executeWorkflowStep(newContext, failedMap, resultList, keepgoing, wlistener, c, cmd);
            statusString = stepResultCapture.getStatusString();
            controlBehavior = stepResultCapture.getControlBehavior();
            currentData.merge(stepResultCapture.getResultData());
            if (!stepResultCapture.isSuccess()) {
                workflowsuccess = false;
            }
            if (stepResultCapture.getControlBehavior() == ControlBehavior.Halt || !stepResultCapture.isSuccess() && !keepgoing) break;
            ++c;
        }
        return BaseWorkflowExecutor.workflowResult(workflowsuccess, statusString, null != controlBehavior ? controlBehavior : ControlBehavior.Continue, currentData);
    }

    protected void addStepFailureContextData(StepExecutionResult stepResult, ExecutionContextImpl.Builder builder) {
        FailureReason reason;
        HashMap<String, String> resultData = new HashMap<String, String>();
        if (null != stepResult.getFailureData()) {
            for (Map.Entry<String, Object> entry : stepResult.getFailureData().entrySet()) {
                resultData.put(entry.getKey(), entry.getValue().toString());
            }
        }
        if (null == (reason = stepResult.getFailureReason())) {
            reason = StepFailureReason.Unknown;
        }
        resultData.put("reason", reason.toString());
        String message = stepResult.getFailureMessage();
        if (null == message) {
            message = "No message";
        }
        resultData.put("message", message);
        builder.setContext("result", resultData);
    }

    protected void addNodeStepFailureContextData(StepExecutionResult dispatcherStepResult, ExecutionContextImpl.Builder builder) {
        Map<String, ? extends NodeStepResult> resultMap;
        if (NodeDispatchStepExecutor.isWrappedDispatcherResult(dispatcherStepResult)) {
            DispatcherResult dispatcherResult = NodeDispatchStepExecutor.extractDispatcherResult(dispatcherStepResult);
            resultMap = dispatcherResult.getResults();
        } else if (NodeDispatchStepExecutor.isWrappedDispatcherException(dispatcherStepResult)) {
            DispatcherException exception = NodeDispatchStepExecutor.extractDispatcherException(dispatcherStepResult);
            HashMap<String, ? extends NodeStepResult> nodeResults = new HashMap<String, NodeStepResult>();
            NodeStepException nodeStepException = exception.getNodeStepException();
            if (null != nodeStepException && null != exception.getNode()) {
                NodeStepResult nodeExecutorResult = BaseWorkflowExecutor.nodeStepResultFromNodeStepException(exception.getNode(), nodeStepException);
                nodeResults.put(nodeStepException.getNodeName(), nodeExecutorResult);
            }
            resultMap = nodeResults;
        } else {
            return;
        }
        if (null != resultMap) {
            for (Map.Entry<String, ? extends NodeStepResult> dentry : resultMap.entrySet()) {
                FailureReason reason;
                String nodename = dentry.getKey();
                NodeStepResult stepResult = dentry.getValue();
                HashMap<String, String> resultData = new HashMap<String, String>();
                if (null != stepResult.getFailureData()) {
                    for (Map.Entry<String, Object> entry : stepResult.getFailureData().entrySet()) {
                        resultData.put(entry.getKey(), entry.getValue().toString());
                    }
                }
                if (null == (reason = stepResult.getFailureReason())) {
                    reason = StepFailureReason.Unknown;
                }
                resultData.put("reason", reason.toString());
                String message = stepResult.getFailureMessage();
                if (null == message) {
                    message = "No message";
                }
                resultData.put("message", message);
                builder.nodeDataContext(nodename, new BaseDataContext("result", resultData));
            }
        }
    }

    protected ExecutionContextImpl.Builder replaceFailedNodesListenerInContext(ExecutionContextImpl.Builder builder, FailedNodesListener captureFailedNodesListener, ExecutionListener executionListener) {
        ExecutionListenerOverride listen = null;
        if (null != executionListener) {
            listen = executionListener.createOverride();
        }
        if (null != listen) {
            listen.setFailedNodesListener(captureFailedNodesListener);
        }
        return builder.executionListener(listen);
    }

    protected Map<String, Collection<StepExecutionResult>> convertFailures(Map<Integer, StepExecutionResult> failedMap) {
        HashMap<String, Collection<StepExecutionResult>> failures = new HashMap<String, Collection<StepExecutionResult>>();
        for (Map.Entry<Integer, StepExecutionResult> entry : failedMap.entrySet()) {
            NodeStepException nodeStepException;
            DispatcherException e;
            INodeEntry node;
            StepExecutionResult o = entry.getValue();
            if (NodeDispatchStepExecutor.isWrappedDispatcherResult(o)) {
                DispatcherResult dispatcherResult = NodeDispatchStepExecutor.extractDispatcherResult(o);
                for (String s : dispatcherResult.getResults().keySet()) {
                    NodeStepResult interpreterResult = dispatcherResult.getResults().get(s);
                    if (!failures.containsKey(s)) {
                        failures.put(s, new ArrayList());
                    }
                    ((Collection)failures.get(s)).add(interpreterResult);
                }
                continue;
            }
            if (!NodeDispatchStepExecutor.isWrappedDispatcherException(o) || null == (node = (e = NodeDispatchStepExecutor.extractDispatcherException(o)).getNode())) continue;
            String key = node.getNodename();
            if (!failures.containsKey(key)) {
                failures.put(key, new ArrayList());
            }
            if (null == (nodeStepException = e.getNodeStepException())) continue;
            ((Collection)failures.get(key)).add(BaseWorkflowExecutor.nodeStepResultFromNodeStepException(node, nodeStepException));
        }
        return failures;
    }

    protected static NodeStepResult nodeStepResultFromNodeStepException(INodeEntry node, NodeStepException nodeStepException) {
        return new NodeStepResultImpl(nodeStepException.getCause(), nodeStepException.getFailureReason(), nodeStepException.getMessage(), node);
    }

    protected Map<String, Map<String, String>> createPrintableDataContext(Map<String, Map<String, String>> dataContext) {
        return this.createPrintableDataContext(OPTION_KEY, SECURE_OPTION_KEY, SECURE_OPTION_VALUE, dataContext);
    }

    protected Map<String, Map<String, String>> createPrintableDataContext(String optionKey, String secureOptionKey, String secureOptionValue, Map<String, Map<String, String>> dataContext) {
        HashMap<String, Map<String, String>> printableContext = new HashMap<String, Map<String, String>>();
        if (dataContext != null) {
            printableContext.putAll(dataContext);
            HashSet secureValues = new HashSet();
            if (dataContext.containsKey(secureOptionKey)) {
                HashMap<String, String> secureOptions = new HashMap<String, String>();
                secureOptions.putAll(dataContext.get(secureOptionKey));
                secureValues.addAll(secureOptions.values());
                for (Map.Entry entry : secureOptions.entrySet()) {
                    entry.setValue(secureOptionValue);
                }
                printableContext.put(secureOptionKey, secureOptions);
            }
            if (dataContext.containsKey(optionKey)) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.putAll(dataContext.get(optionKey));
                for (Map.Entry entry : options.entrySet()) {
                    if (!secureValues.contains(entry.getValue())) continue;
                    entry.setValue(secureOptionValue);
                }
                printableContext.put(optionKey, options);
            }
        }
        return printableContext;
    }

    public StepResultCapture executeWorkflowStep(StepExecutionContext executionContext, Map<Integer, StepExecutionResult> failedMap, List<StepExecutionResult> resultList, boolean keepgoing, WorkflowExecutionListener wlistener, int c, StepExecutionItem cmd) {
        if (null != wlistener) {
            wlistener.beginWorkflowItem(c, cmd);
        }
        WorkflowStatusResultImpl result = WorkflowStatusResultImpl.builder().success(false).build();
        NodeRecorder stepCaptureFailedNodesListener = new NodeRecorder();
        ExecutionContextImpl.Builder wfRunContext = new ExecutionContextImpl.Builder(executionContext);
        this.replaceFailedNodesListenerInContext(wfRunContext, stepCaptureFailedNodesListener, executionContext.getExecutionListener());
        FlowController stepController = new FlowController();
        wfRunContext.flowControl(stepController);
        DataOutput outputContext = new DataOutput(ContextView.step(c));
        wfRunContext.outputContext(outputContext);
        ExecutionContextImpl wfRunContextBuilt = wfRunContext.build();
        HashMap<Integer, StepExecutionResult> stepFailedMap = new HashMap<Integer, StepExecutionResult>();
        StepExecutionResult stepResult = this.executeWFItem(wfRunContextBuilt, stepFailedMap, c, cmd);
        HashMap<String, NodeStepResult> nodeFailures = stepCaptureFailedNodesListener.getFailedNodes();
        this.reportNodesMatched(executionContext, stepCaptureFailedNodesListener);
        WFSharedContext combinedResultData = new WFSharedContext();
        this.combineResultData(c, outputContext, combinedResultData, stepResult);
        if (stepController.isControlled()) {
            result = WorkflowStatusResultImpl.with(stepController);
            stepResult = this.controlledStepResult(stepController, stepResult);
            executionContext.getExecutionListener().log(3, result.toString());
        }
        result.setSuccess(stepResult.isSuccess());
        try {
            HasFailureHandler handles;
            StepExecutionItem handler;
            if (!result.isSuccess() && cmd instanceof HasFailureHandler && null != (handler = (handles = (HasFailureHandler)((Object)cmd)).getFailureHandler())) {
                NodeRecorder handlerCaptureFailedNodesListener = new NodeRecorder();
                ExecutionContextImpl.Builder wfHandlerContext = new ExecutionContextImpl.Builder(executionContext);
                this.replaceFailedNodesListenerInContext(wfHandlerContext, handlerCaptureFailedNodesListener, executionContext.getExecutionListener());
                if (stepCaptureFailedNodesListener.getMatchedNodes().size() > 1) {
                    HashSet<String> failedNodeList = new HashSet<String>(stepCaptureFailedNodesListener.getFailedNodes().keySet());
                    wfHandlerContext.nodeSelector(SelectorUtils.nodeList(failedNodeList));
                }
                this.addStepFailureContextData(stepResult, wfHandlerContext);
                this.addNodeStepFailureContextData(stepResult, wfHandlerContext);
                wfHandlerContext.mergeSharedContext(combinedResultData);
                FlowController handlerController = new FlowController();
                wfHandlerContext.flowControl(handlerController);
                wfHandlerContext.outputContext(outputContext);
                HashMap<Integer, StepExecutionResult> handlerFailedMap = new HashMap<Integer, StepExecutionResult>();
                if (null != wlistener) {
                    wlistener.beginWorkflowItemErrorHandler(c, cmd);
                }
                StepExecutionResult handlerResult = this.executeWFItem(wfHandlerContext.build(), handlerFailedMap, c, handler);
                boolean handlerSuccess = handlerResult.isSuccess();
                if (null != wlistener) {
                    wlistener.finishWorkflowItemErrorHandler(c, cmd, handlerResult);
                }
                this.combineResultData(c, outputContext, combinedResultData, handlerResult);
                if (handlerController.isControlled() && handlerController.getControlBehavior() == ControlBehavior.Halt) {
                    result = WorkflowStatusResultImpl.with(handlerController);
                    executionContext.getExecutionListener().log(3, result.toString());
                } else {
                    boolean useHandlerResults = keepgoing;
                    if (!keepgoing && handlerSuccess && handler instanceof HandlerExecutionItem) {
                        useHandlerResults = ((HandlerExecutionItem)handler).isKeepgoingOnSuccess();
                    }
                    if (useHandlerResults) {
                        result.setSuccess(handlerSuccess);
                        stepResult = handlerResult;
                        stepFailedMap.clear();
                        stepFailedMap.putAll(handlerFailedMap);
                        nodeFailures = handlerCaptureFailedNodesListener.getFailedNodes();
                    }
                }
            }
        }
        catch (RuntimeException t) {
            stepResult = new StepExecutionResultImpl(t, StepFailureReason.Unknown, t.getMessage());
            throw t;
        }
        finally {
            if (null != wlistener) {
                wlistener.finishWorkflowItem(c, cmd, stepResult);
            }
        }
        resultList.add(stepResult);
        failedMap.putAll(stepFailedMap);
        if (null != executionContext.getExecutionListener() && null != executionContext.getExecutionListener().getFailedNodesListener()) {
            if (nodeFailures.size() > 0) {
                executionContext.getExecutionListener().getFailedNodesListener().nodesFailed(nodeFailures);
            } else if (result.isSuccess()) {
                executionContext.getExecutionListener().getFailedNodesListener().nodesSucceeded();
            }
        }
        return new StepResultCapture(stepResult, result, combinedResultData);
    }

    private StepExecutionResult controlledStepResult(final FlowController stepController, final StepExecutionResult stepResult) {
        return new StepExecutionResultWrapper(stepResult){

            @Override
            public boolean isSuccess() {
                return stepController.getControlBehavior() == ControlBehavior.Continue ? stepResult.isSuccess() : stepController.isSuccess();
            }

            @Override
            public FailureReason getFailureReason() {
                return stepController.getFailureReason(super.getFailureReason());
            }

            @Override
            public String toString() {
                return "[" + stepController + "]: " + super.toString();
            }
        };
    }

    public void combineResultData(int c, DataOutput outputContext, WFSharedContext combinedResultData, StepExecutionResult handlerResult) {
        Object data;
        WFSharedContext sharedContext = outputContext.getSharedContext();
        combinedResultData.merge(sharedContext);
        if (NodeDispatchStepExecutor.isWrappedDispatcherResult(handlerResult)) {
            this.combineNodeResultData(c, handlerResult, combinedResultData);
        }
        if ((data = sharedContext.getData(ContextView.step(c))) != null) {
            combinedResultData.merge(ContextView.global(), data);
        }
    }

    public void reportNodesMatched(StepExecutionContext executionContext, NodeRecorder stepCaptureFailedNodesListener) {
        if (null != executionContext.getExecutionListener() && null != executionContext.getExecutionListener().getFailedNodesListener()) {
            executionContext.getExecutionListener().getFailedNodesListener().matchedNodes(stepCaptureFailedNodesListener.getMatchedNodes());
        }
    }

    protected void validateNodeSet(ExecutionContext executionContext, NodesSelector nodeSelector) {
        if (0 == executionContext.getNodes().getNodes().size()) {
            throw new NodesetEmptyException(nodeSelector);
        }
    }

    public void combineNodeResultData(int c, StepExecutionResult stepResult, WFSharedContext combinedResultData) {
        DispatcherResult dispatcherResult = NodeDispatchStepExecutor.extractDispatcherResult(stepResult);
        Map<String, ? extends NodeStepResult> results = dispatcherResult.getResults();
        WFSharedContext noderesults = new WFSharedContext();
        for (String node : results.keySet()) {
            NodeStepResult nodeStepResult = results.get(node);
            WFSharedContext dataContext = nodeStepResult.getSharedContext();
            noderesults.merge(dataContext);
        }
        combinedResultData.merge(noderesults);
    }

    static class StepFirstWrapper
    implements IWorkflow {
        private IWorkflow workflow;

        StepFirstWrapper(IWorkflow workflow) {
            this.workflow = workflow;
        }

        @Override
        public List<StepExecutionItem> getCommands() {
            return this.workflow.getCommands();
        }

        @Override
        public int getThreadcount() {
            return this.workflow.getThreadcount();
        }

        @Override
        public boolean isKeepgoing() {
            return this.workflow.isKeepgoing();
        }

        @Override
        public String getStrategy() {
            return "step-first";
        }

        @Override
        public Map<String, Object> getPluginConfig() {
            return this.workflow.getPluginConfig();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StepFirstWrapper)) {
                return false;
            }
            StepFirstWrapper that = (StepFirstWrapper)o;
            return !(this.workflow != null ? !this.workflow.equals(that.workflow) : that.workflow != null);
        }

        public int hashCode() {
            return this.workflow != null ? this.workflow.hashCode() : 0;
        }
    }

    public static class StepResultCapture
    implements WorkflowStatusResult {
        private StepExecutionResult stepResult;
        private WorkflowStatusResult statusResult;
        private WFSharedContext resultData;

        public StepResultCapture(StepExecutionResult stepResult, WorkflowStatusResult statusResult, WFSharedContext resultData) {
            this.stepResult = stepResult;
            this.statusResult = statusResult;
            this.resultData = resultData;
        }

        @Override
        public String getStatusString() {
            return this.statusResult.getStatusString();
        }

        @Override
        public boolean isSuccess() {
            return this.statusResult.isSuccess();
        }

        @Override
        public ControlBehavior getControlBehavior() {
            return this.statusResult.getControlBehavior();
        }

        public StepExecutionResult getStepResult() {
            return this.stepResult;
        }

        public WFSharedContext getResultData() {
            return this.resultData;
        }

        public String toString() {
            return "StepResultCapture{stepResult=" + this.stepResult + ", stepSuccess=" + this.isSuccess() + ", statusString='" + this.getStatusString() + '\'' + ", controlBehavior=" + (Object)((Object)this.getControlBehavior()) + ", resultData=" + this.resultData + '}';
        }
    }

    protected static class BaseWorkflowExecutionResult
    extends BaseWorkflowStatusResult
    implements WorkflowExecutionResult {
        private final List<StepExecutionResult> results;
        private final Map<String, Collection<StepExecutionResult>> failures;
        private final Map<Integer, StepExecutionResult> stepFailures;
        private final Exception orig;

        public BaseWorkflowExecutionResult(List<StepExecutionResult> results, Map<String, Collection<StepExecutionResult>> failures, Map<Integer, StepExecutionResult> stepFailures, Exception orig, WorkflowStatusResult status, WFSharedContext sharedContext) {
            super(status, sharedContext);
            this.results = results;
            this.failures = failures;
            this.stepFailures = stepFailures;
            this.orig = orig;
        }

        @Override
        public List<StepExecutionResult> getResultSet() {
            return this.results;
        }

        @Override
        public Map<String, Collection<StepExecutionResult>> getNodeFailures() {
            return this.failures;
        }

        @Override
        public Exception getException() {
            return this.orig;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[Workflow result: ");
            builder.append(null != this.getStepFailures() && this.getStepFailures().size() > 0 ? ", step failures: " + this.getStepFailures() : "");
            builder.append(null != this.getNodeFailures() && this.getNodeFailures().size() > 0 ? ", Node failures: " + this.getNodeFailures() : "");
            builder.append(null != this.getException() ? ", exception: " + this.getException() : "");
            builder.append(null != this.getControlBehavior() ? ", flow control: " + (Object)((Object)this.getControlBehavior()) : "");
            builder.append(", status: ");
            String success = this.isSuccess() ? "succeeded" : "failed";
            String status = null != this.getStatusString() ? this.getStatusString() : success;
            builder.append(status);
            builder.append("]");
            return builder.toString();
        }

        @Override
        public Map<Integer, StepExecutionResult> getStepFailures() {
            return this.stepFailures;
        }
    }

    static class BaseWorkflowStatusResult
    implements WorkflowStatusDataResult {
        private boolean status;
        private String statusString;
        private ControlBehavior controlBehavior;
        private WFSharedContext sharedContext;

        public BaseWorkflowStatusResult(boolean status, String statusString, ControlBehavior controlBehavior, WFSharedContext sharedContext) {
            this.status = status;
            this.statusString = statusString;
            this.controlBehavior = controlBehavior;
            this.sharedContext = sharedContext;
        }

        public BaseWorkflowStatusResult(WorkflowStatusResult result, WFSharedContext sharedContext) {
            this.status = result.isSuccess();
            this.statusString = result.getStatusString();
            this.controlBehavior = result.getControlBehavior();
            this.sharedContext = sharedContext;
        }

        @Override
        public boolean isSuccess() {
            return this.status;
        }

        @Override
        public String getStatusString() {
            return this.statusString;
        }

        @Override
        public ControlBehavior getControlBehavior() {
            return this.controlBehavior;
        }

        @Override
        public WFSharedContext getSharedContext() {
            return this.sharedContext;
        }
    }
}

