/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.KeyValueEqualsCondition;
import com.dtolabs.rundeck.core.rules.StateObj;
import java.util.Map;
import java.util.regex.Pattern;

public class MatchesCondition
extends KeyValueEqualsCondition {
    final Pattern keyPattern;
    final Pattern valuePattern;

    public MatchesCondition(String key, boolean keyRegex, String value, boolean valueRegex) {
        super(key, value);
        this.keyPattern = keyRegex ? Pattern.compile(key) : null;
        this.valuePattern = valueRegex ? Pattern.compile(value) : null;
    }

    @Override
    public boolean test(StateObj input) {
        if (null == this.keyPattern && null == this.valuePattern) {
            return super.test(input);
        }
        Map<String, String> state = input.getState();
        for (String key : state.keySet()) {
            if (!this.match(key, this.keyPattern, this.getKey()) || !this.match(state.get(key), this.valuePattern, this.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean match(String key, Pattern pattern, String equalsString) {
        if (null != pattern) {
            return pattern.matcher(key).matches();
        }
        return equalsString.equals(key);
    }

    @Override
    public String toString() {
        return "Matches{" + (null != this.keyPattern ? "~" : "") + this.getKey() + (null != this.valuePattern ? "=~" : "==") + this.getValue() + "}";
    }
}

