/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authentication.Group;
import com.dtolabs.rundeck.core.authentication.Urn;
import com.dtolabs.rundeck.core.authentication.Username;
import com.dtolabs.rundeck.core.authorization.AclRule;
import com.dtolabs.rundeck.core.authorization.AclRuleSet;
import com.dtolabs.rundeck.core.authorization.AclRuleSetAuthorization;
import com.dtolabs.rundeck.core.authorization.AclRuleSetImpl;
import com.dtolabs.rundeck.core.authorization.AclRuleSetSource;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.Authorizations;
import com.dtolabs.rundeck.core.authorization.LoggingAuthorization;
import com.dtolabs.rundeck.core.authorization.RuleEvaluator;
import com.dtolabs.rundeck.core.authorization.TypedSubject;
import com.dtolabs.rundeck.core.authorization.providers.Logger;
import com.dtolabs.rundeck.core.authorization.providers.Policies;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

public class AclsUtil {
    public static AclRuleSetAuthorization createFromDirectory(File dir) {
        return AclsUtil.createAuthorization(Policies.load((File)dir));
    }

    public static AclRuleSetAuthorization createFromDirectory(File dir, Logger logger) {
        return AclsUtil.createAuthorization(Policies.load((File)dir, (Logger)logger));
    }

    public static AclRuleSetAuthorization createAuthorization(AclRuleSetSource aclRuleSetSource) {
        return AclsUtil.logging((AclRuleSetAuthorization)RuleEvaluator.createRuleEvaluator((AclRuleSetSource)aclRuleSetSource, (RuleEvaluator.AclSubjectCreator)TypedSubject.aclSubjectCreator(Username.class, Group.class, Urn.class)));
    }

    public static AclRuleSetAuthorization createAuthorization(Policies policies) {
        return AclsUtil.logging((AclRuleSetAuthorization)RuleEvaluator.createRuleEvaluator((AclRuleSetSource)policies, (RuleEvaluator.AclSubjectCreator)TypedSubject.aclSubjectCreator(Username.class, Group.class, Urn.class)));
    }

    private static AclRuleSetAuthorization logging(AclRuleSetAuthorization authorization) {
        return new LoggingAuthorization(authorization);
    }

    public static Set<String> getGroups(AclRuleSetSource source) {
        HashSet<String> strings = new HashSet<String>();
        for (AclRule rule : source.getRuleSet().getRules()) {
            if (rule.getGroup() == null) continue;
            strings.add(rule.getGroup());
        }
        return strings;
    }

    public static Authorization appendAuthorization(Authorization a, Authorization b) {
        if (a instanceof AclRuleSetAuthorization && b instanceof AclRuleSetAuthorization) {
            return AclsUtil.append(a, b);
        }
        return Authorizations.append((Authorization)a, (Authorization)b);
    }

    public static AclRuleSetAuthorization append(Authorization a, Authorization b) {
        AclRuleSetAuthorization a1 = AclsUtil.toAclRuleSetSource(a);
        AclRuleSetAuthorization b1 = AclsUtil.toAclRuleSetSource(b);
        return AclsUtil.append(a1, b1);
    }

    public static AclRuleSetAuthorization append(AclRuleSetAuthorization a, AclRuleSetAuthorization b) {
        if (a != null || b != null) {
            return AclsUtil.logging((AclRuleSetAuthorization)RuleEvaluator.createRuleEvaluator((AclRuleSetSource)AclsUtil.merge((AclRuleSetSource)a, (AclRuleSetSource)b), (RuleEvaluator.AclSubjectCreator)TypedSubject.aclSubjectCreator(Username.class, Group.class, Urn.class)));
        }
        throw new IllegalArgumentException();
    }

    private static AclRuleSetAuthorization toAclRuleSetSource(Authorization a) {
        if (a instanceof AclRuleSetAuthorization) {
            return (AclRuleSetAuthorization)a;
        }
        return null;
    }

    public static AclRuleSetSource source(AclRuleSet a) {
        return a.source();
    }

    public static AclRuleSetSource merge(final AclRuleSetSource a, final AclRuleSetSource b) {
        return new AclRuleSetSource(){

            public AclRuleSet getRuleSet() {
                HashSet aclRules = new HashSet();
                if (a != null) {
                    aclRules.addAll(a.getRuleSet().getRules());
                }
                if (null != b) {
                    aclRules.addAll(b.getRuleSet().getRules());
                }
                return new AclRuleSetImpl(aclRules);
            }
        };
    }

    public static Subject getSubjectUrnForProject(String project) {
        String urn = "project:" + project;
        Subject t = new Subject();
        t.getPrincipals().add(new Urn(urn));
        return t;
    }
}

