/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.shared.resources;

import com.dtolabs.shared.resources.ResourceXMLConstants;
import com.dtolabs.shared.resources.ResourceXMLParserException;
import com.dtolabs.shared.resources.ResourceXMLReceiver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class ResourceXMLParser {
    static Logger log4j = LoggerFactory.getLogger((String)ResourceXMLParser.class.getName());
    private File file;
    private InputStream input;
    private Document doc;
    private ResourceXMLReceiver receiver;
    public static final String DEFAULT_ENTITY_XPATH = "node";
    private String entityXpath = "node";
    private static final HashMap<String, String[]> entityProperties = new HashMap();

    public ResourceXMLParser(File file) {
        this.file = file;
    }

    public ResourceXMLParser(InputStream input) {
        this.input = input;
    }

    public ResourceXMLParser(Document doc) {
        this.doc = doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws ResourceXMLParserException, IOException {
        EntityResolver resolver = ResourceXMLParser.createEntityResolver();
        SAXReader reader = new SAXReader(false);
        reader.setEntityResolver(resolver);
        try {
            Document doc;
            if (null == this.doc) {
                InputStream in = null != this.file ? new FileInputStream(this.file) : this.input;
                try {
                    doc = reader.read(in);
                }
                finally {
                    if (null != this.file) {
                        in.close();
                    }
                }
            } else {
                doc = this.doc;
            }
            EntitySet set = new EntitySet();
            Element root = doc.getRootElement();
            List list = root.selectNodes(this.entityXpath);
            for (Object n : list) {
                Node node = (Node)n;
                Entity ent = this.parseEnt(node, set);
                if (null == this.receiver || this.receiver.resourceParsed(ent)) continue;
                break;
            }
            if (null != this.receiver) {
                this.receiver.resourcesParsed(set);
            }
        }
        catch (DocumentException e) {
            throw new ResourceXMLParserException((Exception)((Object)e));
        }
    }

    public static EntityResolver createEntityResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (publicId.equals("-//DTO Labs Inc.//DTD Resources Document 1.0//EN")) {
                    InputStream in = ResourceXMLParser.class.getClassLoader().getResourceAsStream("com/dtolabs/shared/resources/project.dtd");
                    if (null != in) {
                        return new InputSource(in);
                    }
                    System.err.println("couldn't load resource com/dtolabs/shared/resources/project.dtd:" + ResourceXMLParser.class.getClassLoader().getResource("com/dtolabs/shared/resources/project.dtd"));
                    File file1 = new File("src/java/com/dtolabs/shared/resources/project.dtd");
                    if (file1.exists()) {
                        try {
                            return new InputSource(new FileInputStream(file1));
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return null;
            }
        };
    }

    private Entity parseEnt(Node node, EntitySet set) throws ResourceXMLParserException {
        Entity ent = this.parseResourceRef(set, node);
        ent.setResourceType(node.getName());
        this.parseEntProperties(ent, node);
        this.parseEntSubAttributes(ent, node);
        return ent;
    }

    private Entity parseResourceRef(EntitySet set, Node n) throws ResourceXMLParserException {
        Node node2 = n.selectSingleNode("@name");
        if (null == node2) {
            throw new ResourceXMLParserException("@name required: " + ResourceXMLParser.reportNodeErrorLocation(n));
        }
        String rname = node2.getStringValue();
        return set.getOrCreateEntity(rname);
    }

    private void parseEntProperties(Entity ent, Node node) throws ResourceXMLParserException {
        if (null == entityProperties.get(node.getName())) {
            throw new ResourceXMLParserException("Unexpected entity declaration: " + node.getName() + ": " + ResourceXMLParser.reportNodeErrorLocation(node));
        }
        Element node1 = (Element)node;
        for (Object o : node1.attributes()) {
            Attribute attr = (Attribute)o;
            ent.properties.setProperty(attr.getName(), attr.getStringValue());
        }
    }

    private void parseEntSubAttributes(Entity ent, Node node) throws ResourceXMLParserException {
        Element node1 = (Element)node;
        for (Object attribute : node1.selectNodes("attribute")) {
            String attrvalue;
            Element attr = (Element)attribute;
            if (null == attr.selectSingleNode("@name")) {
                throw new ResourceXMLParserException("attribute element has no 'name' attribute: " + ResourceXMLParser.reportNodeErrorLocation((Node)attr));
            }
            String attrname = attr.selectSingleNode("@name").getStringValue();
            if (null != attr.selectSingleNode("@value")) {
                attrvalue = attr.selectSingleNode("@value").getStringValue();
            } else if (null != attr.getText()) {
                attrvalue = attr.getText();
            } else {
                throw new ResourceXMLParserException("attribute element has no 'value' attribute or text content: " + ResourceXMLParser.reportNodeErrorLocation((Node)attr));
            }
            ent.properties.setProperty(attrname, attrvalue);
        }
    }

    protected static String reportNodeErrorLocation(Node e) {
        return "at xpath " + e.getUniquePath();
    }

    public ResourceXMLReceiver getReceiver() {
        return this.receiver;
    }

    public void setReceiver(ResourceXMLReceiver receiver) {
        this.receiver = receiver;
    }

    static {
        entityProperties.put(DEFAULT_ENTITY_XPATH, ResourceXMLConstants.nodeProps);
    }

    public static class Entity {
        private EntitySet set;
        private Properties properties = new Properties();
        private String name;
        private String resourceType;

        Entity() {
        }

        public String getId() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entity entity = (Entity)o;
            return !(this.name != null ? !this.name.equals(entity.name) : entity.name != null);
        }

        public int hashCode() {
            int result = this.set != null ? this.set.hashCode() : 0;
            result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String getProperty(String prop) {
            return this.properties.getProperty(prop);
        }

        public void setProperty(String prop, String value) {
            this.properties.setProperty(prop, value);
        }

        public String getResourceType() {
            return this.resourceType;
        }

        void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }
    }

    public static class EntitySet {
        private HashMap<String, Entity> entcache = new HashMap();

        void addEntity(Entity ent) {
            this.entcache.put(ent.getId(), ent);
        }

        boolean containsEntity(String name) {
            return this.entcache.containsKey(name);
        }

        Entity createEntity(String name) {
            Entity ent = new Entity();
            ent.setName(name);
            ent.set = this;
            this.addEntity(ent);
            return ent;
        }

        Entity getOrCreateEntity(String name) {
            if (this.containsEntity(name)) {
                return this.entcache.get(name);
            }
            return this.createEntity(name);
        }

        public Collection<Entity> getEntities() {
            return this.entcache.values();
        }
    }
}

