/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.acl;

import com.dtolabs.rundeck.core.authorization.RuleSetValidation;
import com.dtolabs.rundeck.core.authorization.providers.BaseValidator;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.rundeck.app.acl.ACLFileManagerListener;
import org.rundeck.app.acl.AclPolicyFile;

public interface ACLFileManager {
    public BaseValidator getValidator();

    default public void addListener(ACLFileManagerListener listener) {
        throw new UnsupportedOperationException("addListener");
    }

    default public void removeListener(ACLFileManagerListener listener) {
        throw new UnsupportedOperationException("removeListener");
    }

    public long storePolicyFile(String var1, InputStream var2) throws IOException;

    public boolean deletePolicyFile(String var1) throws IOException;

    public long storePolicyFileContents(String var1, String var2) throws IOException;

    public AclPolicyFile getAclPolicy(String var1);

    public String getPolicyFileContents(String var1) throws IOException;

    public long loadPolicyFileContents(String var1, OutputStream var2) throws IOException;

    public boolean existsPolicyFile(String var1);

    default public RuleSetValidation<PolicyCollection> validatePolicyFile(String fname) throws IOException {
        String policyFileContents = this.getPolicyFileContents(fname);
        if (policyFileContents == null) {
            return null;
        }
        return this.getValidator().validateYamlPolicy(fname, policyFileContents);
    }

    public List<String> listStoredPolicyFiles();
}

