/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.data;

import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.data.ViewTraverse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface MultiDataContext<K extends ViewTraverse<K>, D extends DataContext> {
    public MultiDataContext<K, D> getBase();

    public Map<K, D> getData();

    public D getData(K var1);

    public Set<K> getKeys();

    public Set<K> getConsolidatedKeys();

    public MultiDataContext<K, D> consolidate();

    public void merge(K var1, D var2);

    public void merge(MultiDataContext<K, D> var1);

    default public String resolve(K view, String group, String key) {
        return this.resolve(view, group, key, null);
    }

    default public String resolve(K view, String group, String key, String defaultValue) {
        return this.resolve(view, null, group, key, defaultValue);
    }

    default public String resolve(K view, K widestScope, String group, String key, String defaultValue) {
        String resolve;
        String result;
        if (null == view) {
            throw new NullPointerException("view is null");
        }
        D data = this.getData(view);
        if (null != data && null != (result = data.resolve(group, key, null))) {
            return result;
        }
        MultiDataContext<K, D> base = this.getBase();
        if (base != null && null != (resolve = base.resolve(view, view, group, key, null))) {
            return resolve;
        }
        if (null != widestScope && widestScope.isWider(view.widenView().getView())) {
            return defaultValue;
        }
        if (!view.isWidest()) {
            return this.resolve((ViewTraverse)view.widenView().getView(), widestScope, group, key, defaultValue);
        }
        return defaultValue;
    }

    default public List<String> collect(Predicate<K> viewFilter, String group, String key) {
        return new TreeSet<K>(this.getConsolidatedKeys()).stream().filter(viewFilter).map(v -> Optional.ofNullable(this.resolve(v, group, key))).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    default public Map<String, String> collectMap(Predicate<K> viewFilter, Function<K, String> keyMapper, String group, String key) {
        return new TreeSet<K>(this.getConsolidatedKeys()).stream().filter(viewFilter).filter(v -> null != this.resolve(v, group, key)).collect(Collectors.toMap(keyMapper, v -> this.resolve(v, group, key)));
    }
}

