/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.data.BaseDataContext;
import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.proxy.DefaultSecretBundle;
import com.dtolabs.rundeck.core.execution.proxy.ProxySecretBundleCreator;
import com.dtolabs.rundeck.core.execution.proxy.SecretBundle;
import com.dtolabs.rundeck.core.plugins.AbstractDescribableScriptPlugin;
import com.dtolabs.rundeck.core.plugins.ScriptDataContextUtil;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.plugins.configuration.StringRenderingConstants;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.utils.MapData;
import com.dtolabs.rundeck.core.utils.ScriptExecHelper;
import com.dtolabs.rundeck.core.utils.ScriptExecUtil;
import com.dtolabs.rundeck.plugins.step.PluginStepContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.rundeck.storage.api.Resource;

public abstract class BaseScriptPlugin
extends AbstractDescribableScriptPlugin
implements ProxySecretBundleCreator {
    private ScriptExecHelper scriptExecHelper = ScriptExecUtil.helper();

    protected BaseScriptPlugin(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
    }

    protected BaseScriptPlugin(ScriptPluginProvider provider) {
        super(provider);
    }

    protected int runPluginScript(PluginStepContext executionContext, PrintStream outputStream, PrintStream errorStream, Framework framework, Map<String, Object> configuration) throws IOException, InterruptedException, ConfigurationException {
        Description pluginDesc = this.getDescription();
        DataContext localDataContext = this.createScriptDataContext(framework, executionContext.getFrameworkProject(), executionContext.getDataContext());
        HashMap<String, Object> instanceData = new HashMap<String, Object>(configuration);
        Map<String, String> data = MapData.toStringStringMap(instanceData);
        this.loadContentConversionPropertyValues(data, executionContext.getExecutionContext(), pluginDesc.getProperties());
        localDataContext.merge(new BaseDataContext("config", data));
        String[] finalargs = this.createScriptArgs(localDataContext);
        executionContext.getLogger().log(3, "[" + this.getProvider().getName() + "] executing: " + Arrays.asList(finalargs));
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (this.isMergeEnvVars()) {
            envMap.putAll(this.getScriptExecHelper().loadLocalEnvironment());
        }
        envMap.putAll(DataContextUtils.generateEnvVarsFromContext(localDataContext));
        return this.getScriptExecHelper().runLocalCommand(finalargs, envMap, null, outputStream, errorStream);
    }

    protected Map<String, Map<String, String>> createStepItemDataContext(Framework framework, String project, Map<String, Map<String, String>> context, Map<String, Object> configuration) {
        DataContext localDataContext = this.createScriptDataContext(framework, project, context);
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : configuration.entrySet()) {
            configMap.put(entry.getKey(), entry.getValue().toString());
        }
        localDataContext.put("config", configMap);
        return localDataContext;
    }

    protected DataContext createScriptDataContext(Framework framework, String project, Map<String, Map<String, String>> context) {
        BaseDataContext localDataContext = new BaseDataContext();
        localDataContext.merge(ScriptDataContextUtil.createScriptDataContextObjectForProject(framework, project));
        localDataContext.group("plugin").putAll(this.createPluginData());
        localDataContext.putAll((Map<? extends String, ? extends Map<String, String>>)context);
        return localDataContext;
    }

    protected DataContext createScriptDataContext(Map<String, Map<String, String>> context) {
        BaseDataContext localDataContext = new BaseDataContext();
        localDataContext.group("plugin").putAll(this.createPluginData());
        if (null != context) {
            localDataContext.putAll((Map<? extends String, ? extends Map<String, String>>)context);
        }
        return localDataContext;
    }

    protected String[] createScriptArgs(Map<String, Map<String, String>> localDataContext) {
        ScriptPluginProvider plugin = this.getProvider();
        File scriptfile = plugin.getScriptFile();
        String scriptargs = plugin.getScriptArgs();
        String[] scriptargsarray = plugin.getScriptArgsArray();
        String scriptinterpreter = plugin.getScriptInterpreter();
        boolean interpreterargsquoted = plugin.getInterpreterArgsQuoted();
        return this.getScriptExecHelper().createScriptArgs(localDataContext, scriptargs, scriptargsarray, scriptinterpreter, interpreterargsquoted, scriptfile.getAbsolutePath());
    }

    protected ExecArgList createScriptArgsList(Map<String, Map<String, String>> dataContext) {
        ScriptPluginProvider plugin = this.getProvider();
        File scriptfile = plugin.getScriptFile();
        String scriptargs = null != plugin.getScriptArgs() ? DataContextUtils.replaceDataReferencesInString(plugin.getScriptArgs(), dataContext) : null;
        String[] scriptargsarr = null != plugin.getScriptArgsArray() ? DataContextUtils.replaceDataReferencesInArray(plugin.getScriptArgsArray(), dataContext) : null;
        String scriptinterpreter = plugin.getScriptInterpreter();
        boolean interpreterargsquoted = plugin.getInterpreterArgsQuoted();
        return this.getScriptExecHelper().createScriptArgList(scriptfile.getAbsolutePath(), scriptargs, scriptargsarr, scriptinterpreter, interpreterargsquoted);
    }

    public ScriptExecHelper getScriptExecHelper() {
        return this.scriptExecHelper;
    }

    public void setScriptExecHelper(ScriptExecHelper scriptExecHelper) {
        this.scriptExecHelper = scriptExecHelper;
    }

    @Override
    public SecretBundle prepareSecretBundle(ExecutionContext context, INodeEntry node) {
        DefaultSecretBundle bundle = new DefaultSecretBundle();
        Description pluginDesc = this.getDescription();
        DataContext localDataContext = this.createScriptDataContext(context.getFramework(), context.getFrameworkProject(), context.getDataContext());
        PropertyResolver resolver = PropertyResolverFactory.createPluginRuntimeResolver(context, this.loadInstanceDataFromNodeAttributes(node, pluginDesc), this.getProvider().getService(), this.getProvider().getName());
        Map<String, Object> config = PluginAdapterUtility.mapDescribedProperties(resolver, pluginDesc, PropertyScope.Instance);
        Map<String, Object> expanded = DataContextUtils.replaceDataReferences(config, (Map<String, Map<String, String>>)localDataContext);
        Map<String, String> data = MapData.toStringStringMap(expanded);
        for (Property property : pluginDesc.getProperties()) {
            Resource r;
            Object conversion;
            Map<String, Object> renderingOptions;
            String name = property.getName();
            String propValue = data.get(name);
            if (null == propValue || (renderingOptions = property.getRenderingOptions()) == null || !StringRenderingConstants.ValueConversion.STORAGE_PATH_AUTOMATIC_READ.equalsOrString(conversion = renderingOptions.get("valueConversion")) || (r = context.getStorageTree().getResource(propValue)) == null) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ((ResourceMeta)r.getContents()).writeContent(byteArrayOutputStream);
                bundle.addSecret(propValue, byteArrayOutputStream.toByteArray());
            }
            catch (IOException iex) {
                context.getExecutionLogger().log(0, String.format("IOException Unable to add secret value to secret bundle for: %s", name));
            }
        }
        return bundle;
    }
}

