/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.net.api;

import com.dtolabs.rundeck.net.api.RundeckApi;
import com.dtolabs.rundeck.net.api.util.StaticHeaderInterceptor;
import com.dtolabs.rundeck.net.model.ErrorDetail;
import com.dtolabs.rundeck.net.model.ErrorResponse;
import com.dtolabs.rundeck.net.model.ProjectImportStatus;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class Client {
    private String url;
    private String authToken;
    private RundeckApi api;
    private OkHttpClient.Builder builder;
    private Retrofit retrofit;
    static Logger projectLogger = LoggerFactory.getLogger((String)"org.rundeck.project.events");
    private static final String APPLICATION_ZIP = "application/zip";
    private static final MediaType MEDIA_TYPE_ZIP = MediaType.parse((String)"application/zip");
    private final long HTTP_TIMEOUT_MIN = 10L;

    public Client(String url, String authToken) {
        this.url = url;
        this.authToken = authToken;
        this.builder = new OkHttpClient.Builder();
        this.builder.addInterceptor((Interceptor)new StaticHeaderInterceptor("X-Rundeck-Auth-Token", authToken));
        this.builder.readTimeout(10L, TimeUnit.MINUTES);
        this.builder.connectTimeout(10L, TimeUnit.MINUTES);
        this.builder.writeTimeout(10L, TimeUnit.MINUTES);
        this.retrofit = new Retrofit.Builder().baseUrl(url).client(this.builder.build()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
    }

    public void setApi(RundeckApi api) {
        this.api = api;
    }

    public ProjectImportStatus importProjectArchive(String project, File file, boolean preserveUuids, boolean importExecutions, boolean importConfig, boolean importACL, boolean importSCM) throws IOException {
        ProjectImportStatus response = new ProjectImportStatus();
        response.successful = true;
        RequestBody body = RequestBody.create((MediaType)MEDIA_TYPE_ZIP, (File)file);
        Response status = this.getApi().importProjectArchive(project, preserveUuids ? "remove" : "preserve", importExecutions, importConfig, importACL, importSCM, body).execute();
        if (status.isSuccessful()) {
            if (null != status.body()) {
                response = (ProjectImportStatus)status.body();
                if (!response.getResultSuccess()) {
                    if (null != response.errors) {
                        projectLogger.error(String.format("Error on import jobs to new project: %d", response.errors.size()));
                    }
                    if (null != response.executionErrors) {
                        projectLogger.error(String.format("Error on import executions to new project: %d", response.executionErrors.size()));
                    }
                    if (null != response.aclErrors) {
                        projectLogger.error(String.format("Error on import acls to new project: %d", response.aclErrors.size()));
                    }
                }
            } else {
                projectLogger.error("Null body on response");
                response.successful = false;
            }
        } else {
            ResponseBody responseBody = status.errorBody();
            Converter errorConverter = this.retrofit.responseBodyConverter(ErrorResponse.class, new Annotation[0]);
            ErrorDetail error = (ErrorDetail)errorConverter.convert((Object)responseBody);
            if (status.code() == 401 || status.code() == 403) {
                throw new RuntimeException(String.format("Authorization failed: %d %s", status.code(), error.getErrorMessage()));
            }
            if (status.code() == 409) {
                throw new RuntimeException(String.format("Could not create resource: %d %s", status.code(), error.getErrorMessage()));
            }
            if (status.code() == 404) {
                throw new RuntimeException(String.format("Could not find resource:  %d %s", status.code(), error.getErrorMessage()));
            }
            throw new RuntimeException(String.format("Request failed:  %d %s", status.code(), error.getErrorMessage()));
        }
        return response;
    }

    private RundeckApi getApi() {
        if (this.api == null) {
            this.api = (RundeckApi)this.retrofit.create(RundeckApi.class);
        }
        return this.api;
    }
}

