/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.plugins.JarPluginProviderLoader;
import com.dtolabs.rundeck.core.plugins.PluginValidation;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProviderLoader;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginValidator {
    private static final Logger log = LoggerFactory.getLogger((String)PluginValidator.class.getName());

    public static boolean validate(File pluginFile) {
        if (pluginFile.getName().endsWith(".jar")) {
            return JarPluginProviderLoader.isValidJarPlugin(pluginFile);
        }
        if (pluginFile.getName().endsWith(".zip")) {
            try {
                return ScriptPluginProviderLoader.validatePluginMeta(ScriptPluginProviderLoader.loadMeta(pluginFile), pluginFile).getState() == PluginValidation.State.VALID;
            }
            catch (Exception iex) {
                log.error("Error loading plugin.", (Throwable)iex);
            }
        } else {
            if (pluginFile.getName().endsWith(".groovy")) {
                return true;
            }
            log.error("File: ${pluginFile.getName()} is not a valid Rundeck plugin.");
        }
        return false;
    }
}

