/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class NodeExecutorUtils {
    static final String RD_VARIABLE_PATTERN = "ssh-variable-export-pattern";
    static final String RD_VARIABLE_PATTERN_SEPARATOR = "ssh-variable-export-separator";
    static final String RD_VARIABLE_PATTERN_EXCLUDE_NODES = "ssh-variable-export-exclude-nodes";
    static final String RD_VARIABLE_PATTERN_EXCLUDE_NODES_PATTERN = "RD_NODE";
    static final String RD_VARIABLE_PATTERN_DEFAULT_SEPARATOR = ";";

    public static String[] getExportedVariablesForNode(INodeEntry node, ExecutionContext nodeContext, List commandList) {
        String exportedVariables = "";
        ArrayList<String> commandsList = new ArrayList<String>();
        if (node.getAttributes().get(RD_VARIABLE_PATTERN) != null) {
            ArrayList envArgs = new ArrayList();
            String replacementPattern = node.getAttributes().get(RD_VARIABLE_PATTERN);
            Map<String, String> envVars = DataContextUtils.generateEnvVarsFromContext(nodeContext.getDataContext());
            envVars.forEach((k, v) -> {
                if (node.getAttributes().get(RD_VARIABLE_PATTERN_EXCLUDE_NODES) != null && Boolean.TRUE.equals(Boolean.valueOf(node.getAttributes().get(RD_VARIABLE_PATTERN_EXCLUDE_NODES)))) {
                    if (!k.startsWith(RD_VARIABLE_PATTERN_EXCLUDE_NODES_PATTERN)) {
                        envArgs.add(replacementPattern.replace("{key}", (CharSequence)k).replace("{value}", (CharSequence)v));
                    }
                } else {
                    envArgs.add(replacementPattern.replace("{key}", (CharSequence)k).replace("{value}", (CharSequence)v));
                }
            });
            if (!envArgs.isEmpty()) {
                String variablePatternSeparator = RD_VARIABLE_PATTERN_DEFAULT_SEPARATOR;
                if (node.getAttributes().get(RD_VARIABLE_PATTERN_SEPARATOR) != null) {
                    variablePatternSeparator = node.getAttributes().get(RD_VARIABLE_PATTERN_SEPARATOR);
                }
                exportedVariables = StringUtils.join(envArgs, (String)StringEscapeUtils.unescapeJava((String)variablePatternSeparator)) + StringEscapeUtils.unescapeJava((String)variablePatternSeparator);
                commandsList.add(exportedVariables);
            }
        }
        commandsList.addAll(commandList);
        return commandsList.toArray(new String[commandsList.size()]);
    }
}

