/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.NodesetEmptyException;
import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.HasSourceResult;
import com.dtolabs.rundeck.core.execution.StatusResult;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.dispatch.Dispatchable;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResultImpl;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.workflow.BaseWorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.ControlBehavior;
import com.dtolabs.rundeck.core.execution.workflow.IWorkflow;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WFSharedContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItemImpl;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionService;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowImpl;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStatusDataResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStatusResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.NodeDispatchStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeFirstWorkflowExecutor
extends BaseWorkflowExecutor {
    static final Logger logger = LoggerFactory.getLogger((String)NodeFirstWorkflowExecutor.class.getName());

    public NodeFirstWorkflowExecutor(IFramework framework) {
        super(framework);
    }

    @Override
    public WorkflowExecutionResult executeWorkflowImpl(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        Exception exception = null;
        IWorkflow workflow = item.getWorkflow();
        WorkflowStatusResult wfresult = null;
        ArrayList<StepExecutionResult> results = new ArrayList<StepExecutionResult>();
        HashMap<String, Collection<StepExecutionResult>> failures = new HashMap<String, Collection<StepExecutionResult>>();
        HashMap<Integer, StepExecutionResult> stepFailures = new HashMap<Integer, StepExecutionResult>();
        boolean workflowsuccess = true;
        String statusString = null;
        ControlBehavior controlBehavior = null;
        WFSharedContext wfCurrentContext = WFSharedContext.withBase(executionContext.getSharedDataContext());
        try {
            NodesSelector nodeSelector = executionContext.getNodeSelector();
            if (workflow.getCommands().size() < 1) {
                executionContext.getExecutionListener().log(1, "Workflow has 0 items");
            }
            this.validateNodeSet(executionContext, nodeSelector);
            logger.debug("Begin loop");
            List<IWorkflow> sections = this.splitWorkflowDispatchedSections(workflow, executionContext);
            int stepCount = 1;
            if (sections.size() > 1) {
                logger.debug("Split workflow into " + sections.size() + " sections");
            }
            assert (sections.size() >= 1);
            if (sections.size() < 1) {
                throw new IllegalStateException();
            }
            for (IWorkflow flowsection : sections) {
                WorkflowStatusResult sectionData;
                WorkflowStatusResult sectionSuccess;
                StepExecutor stepExecutor = this.getFramework().getStepExecutorForItem(flowsection.getCommands().get(0), executionContext.getFrameworkProject());
                if (stepExecutor.isNodeDispatchStep(flowsection.getCommands().get(0))) {
                    WorkflowStatusDataResult workflowStatusDataResult;
                    sectionSuccess = workflowStatusDataResult = this.executeWFSectionNodeDispatch(executionContext, stepCount, results, failures, stepFailures, flowsection, wfCurrentContext);
                    sectionData = workflowStatusDataResult;
                } else {
                    WorkflowExecutionItem innerLoopItem = NodeFirstWorkflowExecutor.createInnerLoopItem(flowsection);
                    WorkflowExecutor executorForItem = this.getFramework().getWorkflowExecutionService().getExecutorForItem(innerLoopItem);
                    WFSharedContext currentData = new WFSharedContext(wfCurrentContext);
                    ExecutionContextImpl newContext = ExecutionContextImpl.builder(executionContext).sharedDataContext(currentData).stepNumber(stepCount).build();
                    WorkflowExecutionResult workflowExecutionResult = executorForItem.executeWorkflow(newContext, innerLoopItem);
                    results.addAll(workflowExecutionResult.getResultSet());
                    this.mergeFailure(failures, workflowExecutionResult.getNodeFailures());
                    stepFailures.putAll(workflowExecutionResult.getStepFailures());
                    sectionSuccess = workflowExecutionResult;
                    sectionData = workflowExecutionResult;
                }
                wfCurrentContext.merge(sectionData.getSharedContext());
                wfresult = sectionSuccess;
                if (!sectionSuccess.isSuccess()) {
                    workflowsuccess = false;
                }
                if (sectionSuccess.getControlBehavior() != null && sectionSuccess.getControlBehavior() != ControlBehavior.Continue) {
                    controlBehavior = sectionSuccess.getControlBehavior();
                }
                if (sectionSuccess.getStatusString() != null) {
                    statusString = sectionSuccess.getStatusString();
                }
                if (!workflowsuccess && !item.getWorkflow().isKeepgoing() || controlBehavior == ControlBehavior.Halt) break;
                stepCount += flowsection.getCommands().size();
            }
            wfresult = NodeFirstWorkflowExecutor.workflowResult(workflowsuccess, statusString, controlBehavior, wfCurrentContext);
        }
        catch (NodesetEmptyException e) {
            Boolean successOnEmptyNodeFilter = Boolean.valueOf(executionContext.getDataContext().get("job").get("successOnEmptyNodeFilter"));
            if (!successOnEmptyNodeFilter.booleanValue()) {
                exception = e;
                e.printStackTrace();
                executionContext.getExecutionListener().log(0, "Exception: " + e.getClass() + ": " + e.getMessage());
                wfresult = WorkflowResultFailed;
            } else {
                logger.debug("No matched nodes");
                wfresult = NodeFirstWorkflowExecutor.workflowResult(true, null, ControlBehavior.Continue, wfCurrentContext);
            }
        }
        catch (RuntimeException e) {
            exception = e;
            e.printStackTrace();
            executionContext.getExecutionListener().log(0, "Exception: " + e.getClass() + ": " + e.getMessage());
            wfresult = WorkflowResultFailed;
        }
        catch (DispatcherException | ExecutionServiceException e) {
            exception = e;
            executionContext.getExecutionListener().log(0, "Exception: " + e.getClass() + ": " + e.getMessage());
            wfresult = WorkflowResultFailed;
        }
        Exception fexception = exception;
        return new BaseWorkflowExecutor.BaseWorkflowExecutionResult(results, failures, stepFailures, fexception, wfresult, wfCurrentContext);
    }

    private WorkflowStatusDataResult executeWFSectionNodeDispatch(StepExecutionContext executionContext, int stepCount, List<StepExecutionResult> results, Map<String, Collection<StepExecutionResult>> failures, Map<Integer, StepExecutionResult> stepFailures, IWorkflow flowsection, WFSharedContext sharedContext) throws ExecutionServiceException, DispatcherException {
        logger.debug("Node dispatch for " + flowsection.getCommands().size() + " steps");
        WorkflowExecutionItem innerLoopItem = NodeFirstWorkflowExecutor.createInnerLoopItem(flowsection);
        DispatchedWorkflow dispatchedWorkflow = new DispatchedWorkflow(this.getFramework().getWorkflowExecutionService(), innerLoopItem, stepCount, executionContext.getStepContext());
        WFSharedContext dispatchSharedContext = new WFSharedContext(sharedContext);
        DispatcherResult dispatch = this.getFramework().getExecutionService().dispatchToNodes((StepExecutionContext)ExecutionContextImpl.builder(executionContext).sharedDataContext(dispatchSharedContext).stepNumber(stepCount).build(), dispatchedWorkflow);
        logger.debug("Node dispatch result: " + dispatch);
        WFSharedContext resultData = this.extractWFDispatcherResult(dispatch, results, failures, stepFailures, flowsection.getCommands().size(), stepCount);
        return NodeFirstWorkflowExecutor.workflowResult(dispatch.isSuccess(), null, ControlBehavior.Continue, resultData);
    }

    private WFSharedContext extractWFDispatcherResult(DispatcherResult dispatcherResult, List<StepExecutionResult> results, Map<String, Collection<StepExecutionResult>> failures, Map<Integer, StepExecutionResult> stepFailures, int index, int max) {
        DispatcherResultImpl r;
        WFSharedContext wfSharedContext = new WFSharedContext();
        ArrayList mergedStepResults = new ArrayList(max);
        ArrayList<Boolean> successes = new ArrayList<Boolean>(max);
        HashMap<Integer, Map> mergedStepFailures = new HashMap<Integer, Map>();
        for (String nodeName : dispatcherResult.getResults().keySet()) {
            NodeStepResult nodeStepResult = dispatcherResult.getResults().get(nodeName);
            if (nodeStepResult.getSharedContext() != null) {
                wfSharedContext.merge(nodeStepResult.getSharedContext());
            }
            WorkflowExecutionResult result = DispatchedWorkflow.extractWorkflowResult(nodeStepResult);
            failures.computeIfAbsent(nodeName, k -> new ArrayList());
            Collection<StepExecutionResult> thisNodeFailures = result.getNodeFailures().get(nodeName);
            if (null != thisNodeFailures && thisNodeFailures.size() > 0) {
                failures.get(nodeName).addAll(thisNodeFailures);
            }
            Map<Integer, NodeStepResult> perStepFailures = DispatchedWorkflow.extractStepFailures(result, nodeStepResult.getNode());
            for (Map.Entry<Integer, NodeStepResult> entry : perStepFailures.entrySet()) {
                Integer stepNum = entry.getKey();
                NodeStepResult value = entry.getValue();
                mergedStepFailures.computeIfAbsent(stepNum, k -> new HashMap());
                ((Map)mergedStepFailures.get(stepNum)).put(nodeName, value);
            }
            if (result.getResultSet().size() < 1 && result.getNodeFailures().size() < 1 && result.getStepFailures().size() < 1 && !result.isSuccess()) {
                mergedStepFailures.computeIfAbsent(0, k -> new HashMap());
                ((Map)mergedStepFailures.get(0)).put(nodeName, nodeStepResult);
            }
            List<NodeStepResult> results1 = DispatchedWorkflow.extractNodeStepResults(result, nodeStepResult.getNode());
            int i = 0;
            for (NodeStepResult nodeStepResult2 : results1) {
                while (mergedStepResults.size() <= i) {
                    mergedStepResults.add(new HashMap());
                }
                while (successes.size() <= i) {
                    successes.add(Boolean.TRUE);
                }
                HashMap map = (HashMap)mergedStepResults.get(i);
                map.put(nodeName, nodeStepResult2);
                if (!nodeStepResult2.isSuccess()) {
                    successes.set(i, false);
                }
                ++i;
            }
        }
        int x = 0;
        for (HashMap hashMap : mergedStepResults) {
            Boolean success = (Boolean)successes.get(x);
            r = new DispatcherResultImpl(hashMap, null != success ? success : false);
            results.add(NodeDispatchStepExecutor.wrapDispatcherResult(r));
            ++x;
        }
        for (Integer n : mergedStepFailures.keySet()) {
            Map map = (Map)mergedStepFailures.get(n);
            r = new DispatcherResultImpl(map, false);
            stepFailures.put(n, NodeDispatchStepExecutor.wrapDispatcherResult(r));
        }
        return wfSharedContext;
    }

    private void mergeFailure(Map<String, Collection<StepExecutionResult>> destination, Map<String, Collection<StepExecutionResult>> source) {
        for (String s : source.keySet()) {
            if (null == destination.get(s)) {
                destination.put(s, new ArrayList());
            }
            destination.get(s).addAll(source.get(s));
        }
    }

    private List<IWorkflow> splitWorkflowDispatchedSections(IWorkflow workflow, StepExecutionContext executionContext) throws ExecutionServiceException {
        ArrayList<StepExecutionItem> dispatchItems = new ArrayList<StepExecutionItem>();
        ArrayList<IWorkflow> sections = new ArrayList<IWorkflow>();
        for (StepExecutionItem item : workflow.getCommands()) {
            StepExecutor executor = this.getFramework().getStepExecutorForItem(item, executionContext.getFrameworkProject());
            if (executor.isNodeDispatchStep(item)) {
                dispatchItems.add(item);
                continue;
            }
            if (dispatchItems.size() > 0) {
                sections.add(new WorkflowImpl(dispatchItems, workflow.getThreadcount(), workflow.isKeepgoing(), workflow.getStrategy()));
                dispatchItems = new ArrayList();
            }
            sections.add(new WorkflowImpl(Collections.singletonList(item), workflow.getThreadcount(), workflow.isKeepgoing(), workflow.getStrategy()));
        }
        if (null != dispatchItems && dispatchItems.size() > 0) {
            sections.add(new WorkflowImpl(dispatchItems, workflow.getThreadcount(), workflow.isKeepgoing(), workflow.getStrategy()));
        }
        return sections;
    }

    public static WorkflowExecutionItem createInnerLoopItem(IWorkflow item) {
        return new WorkflowExecutionItemImpl(new BaseWorkflowExecutor.StepFirstWrapper(item));
    }

    static class DispatchedWorkflow
    implements Dispatchable {
        WorkflowExecutionItem workflowItem;
        int beginStep;
        List<Integer> stack;
        WorkflowExecutionService workflowExecutionService;

        DispatchedWorkflow(WorkflowExecutionService workflowExecutionService, WorkflowExecutionItem workflowItem, int beginStep, List<Integer> stack) {
            this.workflowExecutionService = workflowExecutionService;
            this.workflowItem = workflowItem;
            this.beginStep = beginStep;
            this.stack = stack;
        }

        @Override
        public NodeStepResult dispatch(ExecutionContext context, INodeEntry node) {
            WorkflowExecutor executor;
            ExecutionContextImpl newcontext = new ExecutionContextImpl.Builder(context).singleNodeContext(node, true).stepNumber(this.beginStep).stepContext(this.stack).build();
            try {
                executor = this.workflowExecutionService.getExecutorForItem(this.workflowItem);
            }
            catch (ExecutionServiceException e) {
                return new NodeStepResultImpl(e, Reason.ExecutionServiceError, "Exception: " + e.getClass() + ": " + e.getMessage(), node);
            }
            WorkflowExecutionResult result = executor.executeWorkflow(newcontext, this.workflowItem);
            NodeStepResultImpl result1 = result.isSuccess() ? new NodeStepResultImpl(node) : new NodeStepResultImpl(result.getException(), Reason.WorkflowSequenceFailures, null == result.getException() ? "Sequence failed" : "Exception: " + result.getException().getClass() + ": " + result.getException().getMessage(), node);
            result1.setSharedContext(result.getSharedContext());
            result1.setSourceResult(result);
            return result1;
        }

        static WorkflowExecutionResult extractWorkflowResult(NodeStepResult dispatcherResult) {
            assert (dispatcherResult instanceof HasSourceResult);
            if (!(dispatcherResult instanceof HasSourceResult)) {
                throw new IllegalArgumentException("Cannot extract source result from dispatcher result");
            }
            HasSourceResult sourced = (HasSourceResult)((Object)dispatcherResult);
            StatusResult sourceResult = sourced.getSourceResult();
            while (!(sourceResult instanceof WorkflowExecutionResult) && sourceResult instanceof HasSourceResult) {
                sourceResult = ((HasSourceResult)sourceResult).getSourceResult();
            }
            if (!(sourceResult instanceof WorkflowExecutionResult)) {
                throw new IllegalArgumentException("Cannot extract workflow result from dispatcher result: " + sourceResult.getClass().getName());
            }
            WorkflowExecutionResult wfresult = (WorkflowExecutionResult)sourceResult;
            return wfresult;
        }

        static List<NodeStepResult> extractNodeStepResults(WorkflowExecutionResult result, INodeEntry node) {
            ArrayList<NodeStepResult> results = new ArrayList<NodeStepResult>();
            for (StepExecutionResult executionResult : result.getResultSet()) {
                DispatcherException exception;
                NodeStepException nodeStepException;
                if (NodeDispatchStepExecutor.isWrappedDispatcherResult(executionResult)) {
                    DispatcherResult dispatcherResult = NodeDispatchStepExecutor.extractDispatcherResult(executionResult);
                    NodeStepResult stepResult = dispatcherResult.getResults().get(node.getNodename());
                    if (null == stepResult) continue;
                    results.add(stepResult);
                    continue;
                }
                if (!NodeDispatchStepExecutor.isWrappedDispatcherException(executionResult) || null == (nodeStepException = (exception = NodeDispatchStepExecutor.extractDispatcherException(executionResult)).getNodeStepException())) continue;
                results.add(BaseWorkflowExecutor.nodeStepResultFromNodeStepException(node, nodeStepException));
            }
            return results;
        }

        static Map<Integer, NodeStepResult> extractStepFailures(WorkflowExecutionResult result, INodeEntry node) {
            HashMap<Integer, NodeStepResult> results = new HashMap<Integer, NodeStepResult>();
            for (Map.Entry<Integer, StepExecutionResult> entry : result.getStepFailures().entrySet()) {
                DispatcherException exception;
                NodeStepException nodeStepException;
                int num = entry.getKey();
                StepExecutionResult executionResult = entry.getValue();
                if (NodeDispatchStepExecutor.isWrappedDispatcherResult(executionResult)) {
                    DispatcherResult dispatcherResult = NodeDispatchStepExecutor.extractDispatcherResult(executionResult);
                    NodeStepResult stepResult = dispatcherResult.getResults().get(node.getNodename());
                    if (null == stepResult) continue;
                    results.put(num, stepResult);
                    continue;
                }
                if (!NodeDispatchStepExecutor.isWrappedDispatcherException(executionResult) || null == (nodeStepException = (exception = NodeDispatchStepExecutor.extractDispatcherException(executionResult)).getNodeStepException())) continue;
                results.put(num, BaseWorkflowExecutor.nodeStepResultFromNodeStepException(node, nodeStepException));
            }
            return results;
        }
    }

    static enum Reason implements FailureReason
    {
        WorkflowSequenceFailures,
        ExecutionServiceError;

    }
}

