/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.plugins.CloseableProvider;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public class Closeables {
    public static final Closeable NO_OP = new Closeable(){

        @Override
        public void close() throws IOException {
        }
    };

    public static <T> CloseableProvider<T> closeableProvider(T object) {
        return Closeables.closeableProvider(object, null);
    }

    public static Closeable closeOnce(final Closeable closer) {
        return new Closeable(){
            final AtomicBoolean closed = new AtomicBoolean(false);

            @Override
            public void close() throws IOException {
                if (this.closed.compareAndSet(false, true)) {
                    closer.close();
                }
            }
        };
    }

    public static <T> CloseableProvider<T> closeableProvider(final T object, final Closeable closer) {
        return new CloseableProvider<T>(){

            @Override
            public T getProvider() {
                return object;
            }

            @Override
            public void close() throws IOException {
                if (null != closer) {
                    closer.close();
                }
            }
        };
    }

    public static Closeable maybeCloseable(Object object) {
        if (object instanceof Closeable) {
            return (Closeable)object;
        }
        return NO_OP;
    }

    public static Closeable single(boolean throwIOException, Collection<Closeable> closeables) {
        return Closeables.single(throwIOException, closeables.toArray(new Closeable[closeables.size()]));
    }

    public static Closeable single(Collection<Closeable> closeables) {
        return Closeables.single(true, closeables);
    }

    public static Closeable single(Closeable ... closeables) {
        return Closeables.single(true, closeables);
    }

    public static Closeable single(boolean throwIOException, Closeable ... closeables) {
        return Closeables.single(throwIOException, true, closeables);
    }

    public static Closeable single(final boolean throwIOException, final boolean throwLast, final Closeable ... closeables) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                Closeables.closeAll(throwIOException, throwLast, closeables);
            }
        };
    }

    public static void closeQuietly(Collection<Closeable> closeables) {
        if (null == closeables) {
            return;
        }
        Closeables.closeQuietly(closeables.toArray(new Closeable[closeables.size()]));
    }

    public static void closeAll(Collection<Closeable> closeables) throws IOException {
        if (null == closeables) {
            return;
        }
        Closeables.closeAll(closeables.toArray(new Closeable[closeables.size()]));
    }

    public static void closeAll(Closeable ... closeables) throws IOException {
        Closeables.closeAll(true, true, closeables);
    }

    public static void closeQuietly(Closeable ... closeables) {
        try {
            Closeables.closeAll(false, false, closeables);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeAll(boolean throwIOException, boolean throwLast, Closeable ... closeables) throws IOException {
        if (null == closeables) {
            return;
        }
        IOException last = null;
        for (Closeable closeable : closeables) {
            if (null == closeable) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                last = e;
                if (!throwIOException || throwLast) continue;
                throw e;
            }
        }
        if (throwIOException && null != last) {
            throw last;
        }
    }
}

