/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.impl.common.BaseFileCopier;
import com.dtolabs.rundeck.core.execution.script.ScriptfileUtils;
import com.dtolabs.rundeck.core.execution.service.FileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepFailureReason;
import com.dtolabs.rundeck.core.plugins.BaseScriptPlugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ScriptPluginFileCopier
extends BaseScriptPlugin
implements FileCopier {
    @Override
    public boolean isAllowCustomProperties() {
        return true;
    }

    @Override
    public boolean isUseConventionalPropertiesMapping() {
        return true;
    }

    public ScriptPluginFileCopier(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
    }

    static void validateScriptPlugin(ScriptPluginProvider plugin) throws PluginException {
        if (null == plugin.getScriptArgs() && null == plugin.getScriptArgsArray()) {
            throw new PluginException("no script-args defined for provider: " + plugin);
        }
        try {
            ScriptPluginFileCopier.createDescription(plugin, true, DescriptionBuilder.builder());
        }
        catch (ConfigurationException e) {
            throw new PluginException(e);
        }
    }

    @Override
    public String copyFileStream(ExecutionContext executionContext, InputStream inputStream, INodeEntry node, String destination) throws FileCopierException {
        return this.copyFile(executionContext, null, inputStream, null, node, destination);
    }

    @Override
    public String copyFile(ExecutionContext executionContext, File file, INodeEntry node, String destination) throws FileCopierException {
        return this.copyFile(executionContext, file, null, null, node, destination);
    }

    @Override
    public String copyScriptContent(ExecutionContext executionContext, String s, INodeEntry node, String destination) throws FileCopierException {
        return this.copyFile(executionContext, null, null, s, node, destination);
    }

    String copyFile(ExecutionContext executionContext, File file, InputStream input, String content, INodeEntry node, String destination) throws FileCopierException {
        Map<String, Map<String, String>> finalDataContext;
        String pluginname = this.getProvider().getName();
        DataContext localDataContext = this.createScriptDataContext(executionContext.getFramework(), executionContext.getFrameworkProject(), executionContext.getDataContext());
        localDataContext.put("node", DataContextUtils.nodeData(node));
        Description pluginDesc = this.getDescription();
        try {
            finalDataContext = this.loadConfigData(executionContext, this.loadInstanceDataFromNodeAttributes(node, pluginDesc), localDataContext, pluginDesc, "FileCopier");
        }
        catch (ConfigurationException e) {
            throw new FileCopierException("[" + pluginname + "]: " + e.getMessage(), StepFailureReason.ConfigurationFailure, e);
        }
        File srcFile = null != file ? file : BaseFileCopier.writeTempFile(executionContext, null, input, content);
        Object destFilePath = destination;
        if (null == destFilePath) {
            String identity = null != executionContext.getDataContext() && null != executionContext.getDataContext().get("job") ? executionContext.getDataContext().get("job").get("execid") : null;
            destFilePath = BaseFileCopier.generateRemoteFilepathForNode(node, executionContext.getFramework().getFrameworkProjectMgr().getFrameworkProject(executionContext.getFrameworkProject()), executionContext.getFramework(), null != file ? file.getName() : "dispatch-script", null, identity);
        }
        if (null != destFilePath && ((String)destFilePath).endsWith("/")) {
            destFilePath = (String)destFilePath + srcFile.getName();
        }
        HashMap<String, String> scptexec = new HashMap<String, String>();
        scptexec.put("file", srcFile.getAbsolutePath());
        scptexec.put("destination", (String)(null != destFilePath ? destFilePath : ""));
        finalDataContext.put("file-copy", scptexec);
        Map<String, Map<String, String>> fileCopyContext = DataContextUtils.addContext("file-copy", scptexec, null);
        ExecArgList execArgList = this.createScriptArgsList(fileCopyContext);
        String localNodeOsFamily = this.getFramework().createFrameworkNode().getOsFamily();
        executionContext.getExecutionListener().log(3, "[" + this.getProvider().getName() + "] executing: " + execArgList.asFlatStringList());
        ByteArrayOutputStream captureSysOut = new ByteArrayOutputStream();
        try {
            int result = this.getScriptExecHelper().runLocalCommand(localNodeOsFamily, execArgList, finalDataContext, null, captureSysOut, System.err);
            executionContext.getExecutionListener().log(3, "[" + pluginname + "]: result code: " + result);
            if (result != 0) {
                throw new FileCopierException("[" + pluginname + "]: external script failed with exit code: " + result, NodeStepFailureReason.NonZeroResultCode);
            }
        }
        catch (IOException e) {
            throw new FileCopierException("[" + pluginname + "] " + e.getMessage(), StepFailureReason.IOFailure);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FileCopierException("[" + pluginname + "] " + e.getMessage(), StepFailureReason.Interrupted);
        }
        finally {
            if (null == file && !ScriptfileUtils.releaseTempFile(srcFile)) {
                executionContext.getExecutionListener().log(1, "Unable to remove local temp file: " + srcFile.getAbsolutePath());
            }
        }
        String output = captureSysOut.toString();
        if (null == output || output.length() < 1) {
            if (null != destFilePath) {
                return destFilePath;
            }
            throw new FileCopierException("[" + pluginname + "]: No output from external script", ScriptPluginFailureReason.ScriptPluginFileCopierOutputMissing);
        }
        String[] split1 = output.split("(\\r?\\n)");
        if (split1.length < 1) {
            if (null != destFilePath) {
                return destFilePath;
            }
            throw new FileCopierException("[" + pluginname + "]: No output from external script", ScriptPluginFailureReason.ScriptPluginFileCopierOutputMissing);
        }
        String remotefilepath = split1[0];
        executionContext.getExecutionListener().log(3, "[" + pluginname + "]: result filepath: " + remotefilepath);
        return remotefilepath;
    }

    static enum ScriptPluginFailureReason implements FailureReason
    {
        ScriptPluginFileCopierOutputMissing;

    }
}

