/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.logging;

import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.data.MultiDataContext;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionLogger;
import com.dtolabs.rundeck.core.execution.StatusResult;
import com.dtolabs.rundeck.core.execution.workflow.SharedOutputContext;
import com.dtolabs.rundeck.core.logging.FilterStreamingLogWriter;
import com.dtolabs.rundeck.core.logging.LogEvent;
import com.dtolabs.rundeck.core.logging.LogEventControl;
import com.dtolabs.rundeck.core.logging.LogLevel;
import com.dtolabs.rundeck.core.logging.PluginLoggingContext;
import com.dtolabs.rundeck.core.logging.StreamingLogWriter;
import com.dtolabs.rundeck.plugins.logging.LogFilterPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PluginFilteredStreamingLogWriter
extends FilterStreamingLogWriter {
    private final List<LogFilterPlugin> plugins = new ArrayList<LogFilterPlugin>();
    private final MyLoggingContext myLoggingContext;

    PluginFilteredStreamingLogWriter(StreamingLogWriter writer, ExecutionContext context, ExecutionLogger directLogger) {
        super(writer);
        this.myLoggingContext = new MyLoggingContext(context.getOutputContext(), directLogger, context.getDataContextObject(), context.getPrivateDataContextObject(), context.getSharedDataContext(), context);
    }

    @Override
    public void openStream() throws IOException {
    }

    @Override
    public void addEvent(LogEvent orig) {
        if (!"log".equals(orig.getEventType())) {
            this.getWriter().addEvent(orig);
            return;
        }
        ControlState state = ControlState.EMIT;
        EventControl eventControl = EventControl.with(orig);
        for (LogFilterPlugin plugin : this.plugins) {
            eventControl.emit();
            plugin.handleEvent(this.myLoggingContext, eventControl);
            if (eventControl.state == ControlState.REMOVE) {
                state = eventControl.state;
                break;
            }
            if (state != ControlState.EMIT || eventControl.state == ControlState.EMIT) continue;
            state = eventControl.state;
        }
        if (state != ControlState.REMOVE && state != ControlState.QUELL) {
            if (state == ControlState.QUIET) {
                eventControl.setLoglevel(LogLevel.VERBOSE);
            }
            this.getWriter().addEvent(eventControl.modified ? eventControl : orig);
        }
    }

    @Override
    public void close() {
        this.finish(null);
    }

    public void finish(StatusResult result) {
        for (LogFilterPlugin plugin : this.plugins) {
            plugin.complete(this.myLoggingContext, result);
        }
    }

    void addPlugin(LogFilterPlugin plugin) {
        plugin.init(this.myLoggingContext);
        this.plugins.add(plugin);
    }

    private static class MyLoggingContext
    implements PluginLoggingContext {
        SharedOutputContext outputContext;
        ExecutionLogger logger;
        DataContext dataContext;
        DataContext privateDataContext;
        MultiDataContext<ContextView, DataContext> sharedDataContext;
        ExecutionContext executionContext;

        MyLoggingContext(SharedOutputContext outputContext, ExecutionLogger logger, DataContext dataContext, DataContext privateDataContext, MultiDataContext<ContextView, DataContext> sharedDataContext, ExecutionContext executionContext) {
            this.outputContext = outputContext;
            this.logger = logger;
            this.dataContext = dataContext;
            this.privateDataContext = privateDataContext;
            this.sharedDataContext = sharedDataContext;
            this.executionContext = executionContext;
        }

        @Override
        public void log(int level, String message) {
            this.logger.log(level, message);
        }

        @Override
        public void log(int level, String message, Map eventMeta) {
            this.logger.log(level, message, eventMeta);
        }

        @Override
        public void event(String eventType, String message, Map eventMeta) {
            this.logger.event(eventType, message, eventMeta);
        }

        @Override
        public SharedOutputContext getOutputContext() {
            return this.outputContext;
        }

        @Override
        public DataContext getDataContext() {
            return this.dataContext;
        }

        @Override
        public DataContext getPrivateDataContext() {
            return this.privateDataContext;
        }

        @Override
        public MultiDataContext<ContextView, DataContext> getSharedDataContext() {
            return this.sharedDataContext;
        }

        @Override
        public ExecutionContext getExecutionContext() {
            return this.executionContext;
        }
    }

    private static enum ControlState {
        EMIT,
        QUELL,
        QUIET,
        REMOVE;

    }

    static class EventControl
    implements LogEventControl {
        private String eventType;
        private Date datetime;
        private LogLevel loglevel;
        private String message;
        private Map<String, String> metadata;
        ControlState state = ControlState.EMIT;
        private boolean modified;

        EventControl(String eventType, Date datetime, LogLevel loglevel, String message, Map<String, String> metadata) {
            this.eventType = eventType;
            this.datetime = datetime;
            this.loglevel = loglevel;
            this.message = message;
            this.metadata = metadata;
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
        }

        @Override
        public String getEventType() {
            return this.eventType;
        }

        @Override
        public LogEventControl setEventType(String eventType) {
            this.modified |= !this.eventType.equals(eventType);
            this.eventType = eventType;
            return this;
        }

        @Override
        public Date getDatetime() {
            return this.datetime;
        }

        @Override
        public LogLevel getLoglevel() {
            return this.loglevel;
        }

        @Override
        public LogEventControl setLoglevel(LogLevel loglevel) {
            this.modified |= !this.loglevel.equals((Object)loglevel);
            this.loglevel = loglevel;
            return this;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public LogEventControl setMessage(String message) {
            this.modified |= !this.message.equals(message);
            this.message = message;
            return this;
        }

        @Override
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.modified = true;
            this.metadata = metadata;
        }

        @Override
        public LogEventControl addMetadata(Map<String, String> data) {
            this.metadata.putAll(data);
            this.modified = true;
            return this;
        }

        @Override
        public LogEventControl addMetadata(String key, String value) {
            this.metadata.put(key, value);
            this.modified = true;
            return this;
        }

        @Override
        public LogEventControl emit() {
            this.state = ControlState.EMIT;
            return this;
        }

        @Override
        public LogEventControl quell() {
            this.modified = true;
            this.state = ControlState.QUELL;
            return this;
        }

        @Override
        public LogEventControl remove() {
            this.modified = true;
            this.state = ControlState.REMOVE;
            return this;
        }

        @Override
        public LogEventControl quiet() {
            this.modified = true;
            this.state = ControlState.QUIET;
            return this;
        }

        static EventControl with(LogEvent event) {
            return new EventControl(event.getEventType(), event.getDatetime(), event.getLoglevel(), event.getMessage(), event.getMetadata());
        }

        public boolean isModified() {
            return this.modified;
        }
    }
}

