/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps.node;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.data.SharedDataContextUtils;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.execution.ConfiguredStepExecutionItem;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.CustomFieldsAdapter;
import com.dtolabs.rundeck.core.execution.workflow.steps.PluginStepContextImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.DynamicProperties;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.utils.Converter;
import com.dtolabs.rundeck.plugins.step.NodeStepPlugin;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.rundeck.app.spi.Services;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeStepPluginAdapter
implements NodeStepExecutor,
Describable,
DynamicProperties {
    protected static Logger log = LoggerFactory.getLogger((String)NodeStepPluginAdapter.class.getName());
    private String serviceName;
    private boolean blankIfUnexpanded;
    private NodeStepPlugin plugin;
    public static final ConvertToNodeStepExecutor CONVERT_TO_NODE_STEP_EXECUTOR = new ConvertToNodeStepExecutor();

    @Override
    public Description getDescription() {
        if (this.plugin instanceof Describable) {
            Describable desc = (Describable)((Object)this.plugin);
            return desc.getDescription();
        }
        return PluginAdapterUtility.buildDescription(this.plugin, DescriptionBuilder.builder());
    }

    @Override
    public Map<String, Object> dynamicProperties(Map<String, Object> projectAndFrameworkValues, Services services) {
        if (this.plugin instanceof DynamicProperties) {
            return ((DynamicProperties)((Object)this.plugin)).dynamicProperties(projectAndFrameworkValues, services);
        }
        return null;
    }

    @Override
    public Map<String, Object> dynamicDefaults(Map<String, Object> projectAndFrameworkValues, Services services) {
        if (this.plugin instanceof DynamicProperties) {
            return ((DynamicProperties)((Object)this.plugin)).dynamicDefaults(projectAndFrameworkValues, services);
        }
        return null;
    }

    public NodeStepPluginAdapter(NodeStepPlugin plugin) {
        this("WorkflowNodeStep", plugin, true);
    }

    public NodeStepPluginAdapter(String serviceName, NodeStepPlugin plugin, boolean blankIfUnexpanded) {
        this.serviceName = serviceName;
        this.plugin = plugin;
        this.blankIfUnexpanded = blankIfUnexpanded;
    }

    public static boolean canAdaptType(Class<?> testType) {
        return NodeStepPlugin.class.isAssignableFrom(testType);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public NodeStepResult executeNodeStep(StepExecutionContext context, NodeStepExecutionItem item, INodeEntry node) throws NodeStepException {
        String providerName = item.getNodeStepType();
        PluginStepContextImpl pluginContext = PluginStepContextImpl.from(context);
        Map<String, Object> instanceConfiguration = this.createConfig(context, item, node);
        PropertyResolver resolver = PropertyResolverFactory.createStepPluginRuntimeResolver(context, instanceConfiguration, this.getServiceName(), providerName);
        Map<String, Object> config = PluginAdapterUtility.configureProperties(resolver, this.getDescription(), this.plugin, PropertyScope.InstanceOnly);
        try {
            this.plugin.executeNodeStep(pluginContext, config, node);
        }
        catch (NodeStepException e) {
            log.error("Error executing node step.", (Throwable)e);
            return new NodeStepResultImpl(e, e.getFailureReason(), e.getMessage(), e.getFailureData(), node);
        }
        catch (Throwable e) {
            log.error("Uncaught throwable executing node step.", e);
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            context.getExecutionListener().log(4, "Failed executing node plugin [" + providerName + "] on node " + node.getNodename() + ": " + stringWriter.toString());
            return new NodeStepResultImpl(e, StepFailureReason.PluginFailed, e.getMessage(), node);
        }
        return new NodeStepResultImpl(node);
    }

    public Map<String, Object> createConfig(StepExecutionContext context, NodeStepExecutionItem item, INodeEntry node) {
        Map<String, Object> instanceConfiguration = this.getStepConfiguration(item);
        Description description = this.getDescription();
        HashMap<String, Boolean> blankIfUnexMap = new HashMap<String, Boolean>();
        if (description != null) {
            description.getProperties().forEach(p -> {
                if (!p.isBlankIfUnexpandable()) {
                    blankIfUnexMap.put(p.getName(), p.isBlankIfUnexpandable());
                } else {
                    blankIfUnexMap.put(p.getName(), this.blankIfUnexpanded);
                }
            });
        }
        if (null != instanceConfiguration) {
            CustomFieldsAdapter customFieldsAdapter = CustomFieldsAdapter.create(description);
            instanceConfiguration = SharedDataContextUtils.replaceDataReferences(instanceConfiguration, ContextView.node(node.getNodename()), ContextView::nodeStep, null, context.getSharedDataContext(), false, blankIfUnexMap, customFieldsAdapter::convertInput, customFieldsAdapter::convertOutput);
        }
        return instanceConfiguration;
    }

    public Map<String, Object> getStepConfiguration(StepExecutionItem item) {
        if (item instanceof ConfiguredStepExecutionItem) {
            return ((ConfiguredStepExecutionItem)item).getStepConfiguration();
        }
        return null;
    }

    public NodeStepPlugin getPlugin() {
        return this.plugin;
    }

    public static class ConvertToNodeStepExecutor
    implements Converter<NodeStepPlugin, NodeStepExecutor> {
        String serviceName;
        boolean blankIfUnexpanded;

        public ConvertToNodeStepExecutor(String serviceName, boolean blankIfUnexpanded) {
            this.serviceName = serviceName;
            this.blankIfUnexpanded = blankIfUnexpanded;
        }

        public ConvertToNodeStepExecutor() {
            this("WorkflowNodeStep", true);
        }

        public NodeStepExecutor convert(NodeStepPlugin plugin, boolean blankIfUnexpanded) {
            return new NodeStepPluginAdapter(this.serviceName, plugin, blankIfUnexpanded);
        }

        @Override
        public NodeStepExecutor convert(NodeStepPlugin plugin) {
            return new NodeStepPluginAdapter(this.serviceName, plugin, this.blankIfUnexpanded);
        }
    }
}

