/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.AdditiveListNodeSet;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.IProjectNodes;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.common.MergedAttributesNodeSet;
import com.dtolabs.rundeck.core.common.NodeSetMerge;
import com.dtolabs.rundeck.core.common.NodeSourceLoader;
import com.dtolabs.rundeck.core.common.NodeSourceLoaderConfig;
import com.dtolabs.rundeck.core.common.SourceDefinitionImpl;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.plugins.CloseableProvider;
import com.dtolabs.rundeck.core.plugins.Closeables;
import com.dtolabs.rundeck.core.plugins.ExtPluginConfiguration;
import com.dtolabs.rundeck.core.plugins.PluginConfiguration;
import com.dtolabs.rundeck.core.plugins.SimplePluginConfiguration;
import com.dtolabs.rundeck.core.resources.DelegateResourceModelSource;
import com.dtolabs.rundeck.core.resources.ExceptionCatchingResourceModelSource;
import com.dtolabs.rundeck.core.resources.FileResourceModelSource;
import com.dtolabs.rundeck.core.resources.FileResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.LoggingResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceErrors;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceService;
import com.dtolabs.rundeck.core.resources.SourceFactory;
import com.dtolabs.rundeck.core.resources.SourceType;
import com.dtolabs.rundeck.core.resources.WriteableModelSource;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorService;
import com.dtolabs.rundeck.core.resources.format.UnsupportedFormatException;
import com.dtolabs.rundeck.core.utils.TextUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectNodeSupport
implements IProjectNodes,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ProjectNodeSupport.class);
    public static final String PROJECT_RESOURCES_URL_PROPERTY = "project.resources.url";
    public static final String PROJECT_RESOURCES_FILE_PROPERTY = "project.resources.file";
    public static final String RESOURCES_SOURCE_PROP_PREFIX = "resources.source";
    public static final String NODE_ENHANCER_PROP_PREFIX = "nodes.plugin";
    public static final String PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES = "project.resources.mergeNodeAttributes";
    private IRundeckProjectConfig projectConfig;
    private final Map<String, Throwable> nodesSourceExceptions;
    private long nodesSourcesLastReload = -1L;
    private List<LoadedResourceModelSource> nodesSourceList;
    private Set<Closeable> nodeSourceReferences = new HashSet<Closeable>();
    private ResourceFormatGeneratorService resourceFormatGeneratorService;
    private ResourceModelSourceService resourceModelSourceService;
    private NodeSourceLoader nodeSourceLoader;
    private boolean sourcesOpened;
    private static Set<String> uncachedResourceTypes = new HashSet<String>();

    public ProjectNodeSupport(IRundeckProjectConfig projectConfig, ResourceFormatGeneratorService resourceFormatGeneratorService, ResourceModelSourceService resourceModelSourceService, NodeSourceLoader nodeSourceLoader) {
        this.projectConfig = projectConfig;
        this.resourceFormatGeneratorService = resourceFormatGeneratorService;
        this.resourceModelSourceService = resourceModelSourceService;
        this.nodeSourceLoader = nodeSourceLoader;
        this.nodesSourceExceptions = Collections.synchronizedMap(new HashMap());
    }

    public ProjectNodeSupport(IRundeckProjectConfig projectConfig, ResourceFormatGeneratorService resourceFormatGeneratorService, ResourceModelSourceService resourceModelSourceService) {
        this.projectConfig = projectConfig;
        this.resourceFormatGeneratorService = resourceFormatGeneratorService;
        this.resourceModelSourceService = resourceModelSourceService;
        this.nodesSourceExceptions = Collections.synchronizedMap(new HashMap());
    }

    private boolean shouldCacheForType(String type) {
        return !uncachedResourceTypes.contains(type);
    }

    private NodeSetMerge getNodeSetMerge() {
        if (this.projectConfig.hasProperty(PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES) && "false".equals(this.projectConfig.getProperty(PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES))) {
            return new AdditiveListNodeSet();
        }
        return new MergedAttributesNodeSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INodeSet getNodeSet() {
        NodeSetMerge list = this.getNodeSetMerge();
        Map<CallSite, ResourceModelSourceException> exceptions = Collections.synchronizedMap(new HashMap());
        int index = 1;
        this.nodesSourceExceptions.clear();
        for (ResourceModelSource resourceModelSource : this.getResourceModelSourcesInternal()) {
            try {
                ResourceModelSourceErrors nodeerrors;
                List<String> modelSourceErrors;
                INodeSet nodes = resourceModelSource.getNodes();
                if (null == nodes) {
                    logger.warn("Empty nodes result from [" + resourceModelSource.toString() + "]");
                } else {
                    list.addNodeSet(nodes);
                }
                if (resourceModelSource instanceof ResourceModelSourceErrors && (modelSourceErrors = (nodeerrors = (ResourceModelSourceErrors)((Object)resourceModelSource)).getModelSourceErrors()) != null && modelSourceErrors.size() > 0) {
                    logger.error("Some errors getting nodes from [" + resourceModelSource.toString() + "]: " + modelSourceErrors);
                    exceptions.put((CallSite)((Object)(index + ".source")), new ResourceModelSourceException(TextUtils.join(modelSourceErrors.toArray(new String[0]), ';')));
                }
            }
            catch (ResourceModelSourceException | RuntimeException e) {
                logger.error("Cannot get nodes from [" + resourceModelSource.toString() + "]: " + e.getMessage());
                logger.debug("Cannot get nodes from [" + resourceModelSource.toString() + "]: " + e.getMessage(), (Throwable)e);
                exceptions.put((CallSite)((Object)(index + ".source")), new ResourceModelSourceException(e.getMessage(), e));
            }
            catch (Throwable e) {
                logger.error("Cannot get nodes from [" + resourceModelSource.toString() + "]: " + e.getMessage());
                logger.debug("Cannot get nodes from [" + resourceModelSource.toString() + "]: " + e.getMessage(), e);
                exceptions.put((CallSite)((Object)(index + ".source")), new ResourceModelSourceException(e.getMessage()));
            }
            ++index;
        }
        Map<String, Throwable> map = this.nodesSourceExceptions;
        synchronized (map) {
            this.nodesSourceExceptions.putAll(exceptions);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Throwable> getResourceModelSourceExceptions() {
        Map<String, Throwable> map = this.nodesSourceExceptions;
        synchronized (map) {
            return new ArrayList<Throwable>(this.nodesSourceExceptions.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Throwable> getResourceModelSourceExceptionsMap() {
        Map<String, Throwable> map = this.nodesSourceExceptions;
        synchronized (map) {
            return Collections.unmodifiableMap(this.nodesSourceExceptions);
        }
    }

    @Override
    public List<IProjectNodes.ReadableProjectNodes> getResourceModelSources() {
        List<LoadedResourceModelSource> resourceModelSources = this.getResourceModelSourcesInternal();
        return resourceModelSources.stream().map(i -> i).collect(Collectors.toList());
    }

    private synchronized List<LoadedResourceModelSource> getResourceModelSourcesInternal() {
        long lastMod;
        long l = lastMod = this.projectConfig.getConfigLastModifiedTime() != null ? this.projectConfig.getConfigLastModifiedTime().getTime() : 0L;
        if (lastMod > this.nodesSourcesLastReload) {
            this.unloadSources();
        }
        if (!this.sourcesOpened) {
            this.loadResourceModelSources();
            this.sourcesOpened = true;
        }
        return this.nodesSourceList;
    }

    @Override
    public Collection<IProjectNodes.WriteableProjectNodes> getWriteableResourceModelSources() {
        List<LoadedResourceModelSource> resourceModelSources = this.getResourceModelSourcesInternal();
        return resourceModelSources.stream().filter(i -> i.getSourceType() == SourceType.READ_WRITE).map(i -> new ProjectWriteableNodes(i.getWriteable(), i.getIndex(), i.getType())).collect(Collectors.toList());
    }

    @Override
    public void close() throws IOException {
        this.unloadSources();
    }

    private synchronized void unloadSources() {
        this.nodesSourceList = new ArrayList<LoadedResourceModelSource>();
        Closeables.closeQuietly(this.nodeSourceReferences);
        this.nodeSourceReferences = new HashSet<Closeable>();
        this.sourcesOpened = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResourceModelSources() {
        Map<CallSite, ExecutionServiceException> exceptions = Collections.synchronizedMap(new HashMap());
        HashSet<CallSite> validSources = new HashSet<CallSite>();
        if (this.projectConfig.hasProperty(PROJECT_RESOURCES_FILE_PROPERTY)) {
            logger.error("Project config: project.resources.file is no longer supported.");
        }
        if (this.projectConfig.hasProperty(PROJECT_RESOURCES_URL_PROPERTY)) {
            logger.error("Project config: project.resources.url is no longer supported.");
        }
        String name = this.projectConfig.getName();
        List<Map<String, Object>> list = this.listResourceModelConfigurations();
        int i = 1;
        for (Map<String, Object> map : list) {
            String string = (String)map.get("type");
            Properties props = (Properties)map.get("props");
            Properties extraProps = (Properties)map.get("extraProps");
            logger.info("Source #" + i + " (" + string + "): loading with properties: " + props);
            try {
                this.nodesSourceList.add(this.loadResourceModelSource(string, props, extraProps, this.shouldCacheForType(string), i + ".source", i));
                validSources.add((CallSite)((Object)(i + ".source")));
            }
            catch (ExecutionServiceException e) {
                logger.error(String.format("Failed loading resource model source #%d in project %s, skipping: %s", i, name, e.getMessage()), (Throwable)e);
                exceptions.put((CallSite)((Object)(i + ".source")), e);
            }
            ++i;
        }
        Map<String, Throwable> map = this.nodesSourceExceptions;
        synchronized (map) {
            this.nodesSourceExceptions.putAll(exceptions);
            for (String string : validSources) {
                this.nodesSourceExceptions.remove(string);
            }
        }
        Date configLastModifiedTime = this.projectConfig.getConfigLastModifiedTime();
        this.nodesSourcesLastReload = configLastModifiedTime != null ? configLastModifiedTime.getTime() : -1L;
    }

    private File getResourceModelSourceFileCacheForType(String ident) {
        String varDir = this.projectConfig.getProperty("framework.var.dir");
        File file = new File(varDir, "resourceModelSourceCache/" + this.projectConfig.getName() + "/" + ident + ".xml");
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            logger.warn("Failed to create cache dirs for source file cache");
        }
        return file;
    }

    public static ResourceModelSource asModelSource(IProjectNodes nodes) {
        return new ProjectNodesSource(nodes);
    }

    private ResourceModelSource createCachingSource(ResourceModelSource origin, String ident, String descr) {
        return this.createCachingSource(origin, ident, descr, SourceFactory.CacheType.BOTH, true);
    }

    public ResourceModelSource createCachingSource(ResourceModelSource origin, String ident, String descr, SourceFactory.CacheType type, boolean logging) {
        File file = this.getResourceModelSourceFileCacheForType(ident);
        ResourceModelSourceService nodesSourceService = this.resourceModelSourceService;
        ResourceFormatGeneratorService resourceFormatGeneratorService = this.getResourceFormatGeneratorService();
        Properties fileSourceConfig = this.generateFileSourceConfigurationProperties(file.getAbsolutePath(), "resourcexml", false, false);
        try {
            ResourceModelSource fileSource = nodesSourceService.getSourceForConfiguration("file", fileSourceConfig);
            ResourceFormatGenerator generatorForFormat = resourceFormatGeneratorService.getGeneratorForFormat("resourcexml");
            String ident1 = "[ResourceModelSource: " + descr + ", project: " + this.projectConfig.getName() + "]";
            StoreExceptionHandler handler = new StoreExceptionHandler(ident);
            ResourceModelSourceCache cache = new FileResourceModelSourceCache(file, generatorForFormat, fileSource);
            if (logging) {
                cache = new LoggingResourceModelSourceCache(cache, ident1);
            }
            return SourceFactory.cachedSource(origin, ident1, handler, cache, type);
        }
        catch (ExecutionServiceException | UnsupportedFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ResourceFormatGeneratorService getResourceFormatGeneratorService() {
        return this.resourceFormatGeneratorService;
    }

    private LoadedResourceModelSource loadResourceModelSource(String type, Properties configuration, Properties extraConfiguration, boolean useCache, String ident, int index) throws ExecutionServiceException {
        CloseableProvider<ResourceModelSource> sourceForConfiguration;
        configuration.put("project", this.projectConfig.getName());
        if (null == this.nodeSourceLoader) {
            sourceForConfiguration = this.resourceModelSourceService.getCloseableSourceForConfiguration(type, configuration);
        } else {
            try {
                NodeSourceLoaderConfig nodeSourceLoaderConfig = this.nodeSourceLoader.getSourceForConfiguration(this.projectConfig.getName(), new SourceDefinitionImpl(type, configuration, extraConfiguration, ident, index));
                sourceForConfiguration = nodeSourceLoaderConfig.getCloseableProvider();
            }
            catch (Throwable e) {
                throw new ExecutionServiceException(e, "Could not create node source: " + e.getMessage());
            }
            if (sourceForConfiguration == null) {
                throw new ExecutionServiceException("Could not create node source: not found");
            }
        }
        this.nodeSourceReferences.add(sourceForConfiguration);
        if (useCache) {
            return new LoadedSource(index, type, this.createCachingSource(sourceForConfiguration.getProvider(), ident, ident + " (" + type + ")"));
        }
        return new LoadedSource(index, type, sourceForConfiguration.getProvider());
    }

    private Properties generateFileSourceConfigurationProperties(String filepath, String format, boolean generate, boolean includeServerNode) {
        FileResourceModelSource.Configuration build = FileResourceModelSource.Configuration.build();
        build.file(filepath);
        if (null != format) {
            build.format(format);
        }
        build.project(this.projectConfig.getName());
        build.generateFileAutomatically(generate);
        build.includeServerNode(includeServerNode);
        return build.getProperties();
    }

    @Override
    public synchronized List<Map<String, Object>> listResourceModelConfigurations() {
        Map<String, String> propertiesMap = this.projectConfig.getProperties();
        Properties properties = new Properties();
        properties.putAll(propertiesMap);
        return ProjectNodeSupport.listResourceModelConfigurations(properties);
    }

    @Override
    public synchronized List<ExtPluginConfiguration> listResourceModelPluginConfigurations() {
        return ProjectNodeSupport.listPluginConfigurations(this.projectConfig.getProjectProperties(), RESOURCES_SOURCE_PROP_PREFIX, "ResourceModelSource");
    }

    @Override
    public synchronized List<ExtPluginConfiguration> listNodeEnhancerConfigurations() {
        return ProjectNodeSupport.listPluginConfigurations(this.projectConfig.getProjectProperties(), NODE_ENHANCER_PROP_PREFIX, "NodeEnhancer");
    }

    public static Properties serializeResourceModelConfigurations(List<Map<String, Object>> configs) {
        Properties projProps = new Properties();
        int count = 1;
        for (Map<String, Object> config : configs) {
            String prefix = "resources.source." + count + ".";
            String type = config.get("type").toString();
            Properties props = (Properties)config.get("props");
            projProps.setProperty(prefix + "type", type);
            for (String k : props.stringPropertyNames()) {
                String v = props.getProperty(k);
                projProps.setProperty(prefix + "config." + k, v);
            }
            ++count;
        }
        return projProps;
    }

    public static Properties serializePluginConfigurations(String prefix, List<PluginConfiguration> configs) {
        Properties projProps = new Properties();
        int count = 1;
        for (PluginConfiguration config : configs) {
            ProjectNodeSupport.serializeProp(prefix, projProps, count, config);
            ++count;
        }
        return projProps;
    }

    public static void serializeProp(String prefix, Properties projProps, int count, PluginConfiguration config) {
        String propPrefix = prefix + "." + count + ".";
        projProps.setProperty(propPrefix + "type", config.getProvider());
        Map<String, Object> configuration = config.getConfiguration();
        for (String k : configuration.keySet()) {
            Object v = configuration.get(k);
            projProps.setProperty(propPrefix + "config." + k, v.toString());
        }
    }

    public static Properties serializePluginConfigurations(String prefix, List<ExtPluginConfiguration> configs, boolean extra) {
        Properties projProps = new Properties();
        int count = 1;
        for (ExtPluginConfiguration config : configs) {
            String propPrefix = prefix + "." + count + ".";
            ProjectNodeSupport.serializeProp(prefix, projProps, count, config);
            if (extra && config.getExtra() != null && config.getExtra().size() > 0) {
                Properties extraProperties = ProjectNodeSupport.generateExtraProperties(propPrefix, config.getExtra());
                extraProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    if (!projProps.containsKey(key)) {
                        projProps.put(key, value);
                    }
                }));
            }
            ++count;
        }
        return projProps;
    }

    public static Properties generateExtraProperties(String propPrefix, Map<String, Object> extra) {
        Properties extraProps = new Properties();
        for (String s : extra.keySet()) {
            if (extra.get(s) instanceof Map) {
                Properties subprops = ProjectNodeSupport.generateExtraProperties(propPrefix + s + ".", (Map)extra.get(s));
                extraProps.putAll((Map<?, ?>)subprops);
                continue;
            }
            extraProps.setProperty(propPrefix + s, extra.get(s).toString());
        }
        return extraProps;
    }

    public static List<Map<String, Object>> listResourceModelConfigurations(Properties props) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int i = 1;
        boolean done = false;
        while (!done) {
            String prefix = "resources.source." + i;
            if (props.containsKey(prefix + ".type")) {
                String providerType = props.getProperty(prefix + ".type");
                Properties configProps = new Properties();
                Properties extraConfigProps = new Properties();
                int len = (prefix + ".config.").length();
                for (Object object : props.keySet()) {
                    String key = (String)object;
                    if (!key.startsWith(prefix + ".config.")) continue;
                    configProps.setProperty(key.substring(len), props.getProperty(key));
                }
                int extraLen = (prefix + ".").length();
                for (Object o3 : props.keySet()) {
                    String key = (String)o3;
                    if (!key.startsWith(prefix) || key.startsWith(prefix + ".config.") || key.startsWith(prefix + ".type")) continue;
                    extraConfigProps.setProperty(key.substring(extraLen), props.getProperty(key));
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("type", providerType);
                hashMap.put("props", configProps);
                hashMap.put("extraProps", extraConfigProps);
                list.add(hashMap);
            } else {
                done = true;
            }
            ++i;
        }
        return list;
    }

    @Override
    public List<ExtPluginConfiguration> listPluginConfigurations(String keyprefix, String serviceName) {
        return this.listPluginConfigurations(keyprefix, serviceName, true);
    }

    @Override
    public List<ExtPluginConfiguration> listPluginConfigurations(String keyprefix, String serviceName, boolean extra) {
        return ProjectNodeSupport.listPluginConfigurations(this.projectConfig.getProjectProperties(), keyprefix, serviceName, extra);
    }

    public static List<ExtPluginConfiguration> listPluginConfigurations(Map<String, String> props, String keyprefix, String serviceName) {
        return ProjectNodeSupport.listPluginConfigurations(props, keyprefix, serviceName, false);
    }

    public static List<ExtPluginConfiguration> listPluginConfigurations(Map<String, String> props, String keyprefix, String serviceName, boolean extra) {
        ArrayList<ExtPluginConfiguration> list = new ArrayList<ExtPluginConfiguration>();
        int i = 1;
        boolean done = false;
        while (!done) {
            String prefix = keyprefix + "." + i;
            if (props.containsKey(prefix + ".type")) {
                String providerType = props.get(prefix + ".type");
                HashMap<String, Object> configProps = new HashMap<String, Object>();
                HashMap<String, Object> extraData = extra ? new HashMap<String, Object>() : null;
                int len = (prefix + ".config.").length();
                for (String string : props.keySet()) {
                    String key = string;
                    if (!key.startsWith(prefix + ".config.")) continue;
                    configProps.put(key.substring(len), props.get(key));
                }
                if (extra) {
                    HashMap<String, Object> extraConfig = new HashMap<String, Object>();
                    for (String s : props.keySet()) {
                        String suffix;
                        if (!s.startsWith(prefix + ".") || "type".equalsIgnoreCase(suffix = s.substring(prefix.length() + 1)) || suffix.startsWith("config.")) continue;
                        extraConfig.put(suffix, props.get(s));
                    }
                    Map<String, Object> map = ProjectNodeSupport.createMapExtraProperties(extraConfig);
                    if (map.size() > 0) {
                        extraData.putAll(map);
                    }
                }
                list.add(new SimplePluginConfiguration(serviceName, providerType, configProps, extraData));
            } else {
                done = true;
            }
            ++i;
        }
        return list;
    }

    public static Map<String, Object> createMapExtraProperties(Map<String, Object> extraProps) {
        HashMap<String, Object> extraMap = new HashMap<String, Object>();
        for (String key : extraProps.keySet()) {
            String[] paths = key.split("\\.");
            Map<String, Object> nestedMap = new HashMap<String, Object>();
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (i < paths.length - 1) {
                    HashMap newMap = new HashMap();
                    if (i == 0) {
                        extraMap.putIfAbsent(path, newMap);
                        nestedMap = (Map)extraMap.get(path);
                        continue;
                    }
                    nestedMap.putIfAbsent(path, newMap);
                    nestedMap = (Map)nestedMap.get(path);
                    continue;
                }
                if (i == 0) {
                    extraMap.putIfAbsent(path, extraProps.get(key));
                    continue;
                }
                nestedMap.put(path, extraProps.get(key));
            }
        }
        return extraMap;
    }

    public IRundeckProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    static {
        uncachedResourceTypes.add("file");
        uncachedResourceTypes.add("directory");
    }

    static class LoadedSource
    extends DelegateResourceModelSource
    implements LoadedResourceModelSource {
        final int index;
        final String type;

        LoadedSource(int index, String type, ResourceModelSource delegate) {
            super(delegate);
            this.index = index;
            this.type = type;
        }

        @Override
        public ResourceModelSource getSource() {
            return this.getDelegate();
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getType() {
            return this.type;
        }
    }

    static interface LoadedResourceModelSource
    extends ResourceModelSource,
    IProjectNodes.ReadableProjectNodes {
        @Override
        public int getIndex();

        @Override
        public String getType();
    }

    private static class ProjectNodesSource
    implements ResourceModelSource {
        IProjectNodes nodes;

        ProjectNodesSource(IProjectNodes nodes) {
            this.nodes = nodes;
        }

        @Override
        public INodeSet getNodes() {
            return this.nodes.getNodeSet();
        }
    }

    class StoreExceptionHandler
    implements ExceptionCatchingResourceModelSource.ExceptionHandler {
        String sourceIdent;

        StoreExceptionHandler(String sourceIdent) {
            this.sourceIdent = sourceIdent;
        }

        @Override
        public void handleException(Throwable t, ResourceModelSource origin) {
            ProjectNodeSupport.this.nodesSourceExceptions.put(this.sourceIdent, t);
        }
    }

    public static final class ProjectWriteableNodes
    implements IProjectNodes.WriteableProjectNodes {
        final WriteableModelSource writeableSource;
        final int index;
        final String type;

        @Override
        public WriteableModelSource getWriteableSource() {
            return this.writeableSource;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectWriteableNodes)) {
                return false;
            }
            ProjectWriteableNodes other = (ProjectWriteableNodes)o;
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            WriteableModelSource this$writeableSource = this.getWriteableSource();
            WriteableModelSource other$writeableSource = other.getWriteableSource();
            if (this$writeableSource == null ? other$writeableSource != null : !this$writeableSource.equals(other$writeableSource)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            WriteableModelSource $writeableSource = this.getWriteableSource();
            result = result * 59 + ($writeableSource == null ? 43 : $writeableSource.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "ProjectNodeSupport.ProjectWriteableNodes(writeableSource=" + this.getWriteableSource() + ", index=" + this.getIndex() + ", type=" + this.getType() + ")";
        }

        public ProjectWriteableNodes(WriteableModelSource writeableSource, int index, String type) {
            this.writeableSource = writeableSource;
            this.index = index;
            this.type = type;
        }
    }
}

