/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.proxy.DefaultSecretBundle;
import com.dtolabs.rundeck.core.execution.proxy.SecretBundle;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.StringRenderingConstants;
import com.dtolabs.rundeck.core.resources.FileResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.storage.StorageTree;
import com.dtolabs.rundeck.core.utils.MapData;
import com.dtolabs.rundeck.core.utils.StringArrayUtil;
import com.dtolabs.utils.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.rundeck.storage.api.Resource;
import org.slf4j.Logger;

class ScriptResourceUtil {
    ScriptResourceUtil() {
    }

    public static INodeSet executeScript(File scriptfile, String scriptargs, String[] scriptargsarray, String scriptinterpreter, String pluginname, Map<String, Map<String, String>> dataContext, String fileformat, Framework framework, String project, Logger logger, boolean interpreterArgsQuoted) throws ResourceModelSourceException {
        Process exec;
        File destinationTempFile;
        File workingdir = null;
        int result = -1;
        boolean success = false;
        Streams.StreamCopyThread errthread = null;
        Streams.StreamCopyThread outthread = null;
        try {
            destinationTempFile = File.createTempFile("script-plugin", ".resources");
            destinationTempFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new ResourceModelSourceException(e);
        }
        logger.info("Tempfile: " + destinationTempFile.getAbsolutePath());
        try {
            exec = null != scriptinterpreter ? ScriptResourceUtil.execShellScript(logger, workingdir, scriptfile, scriptargs, scriptargsarray, dataContext, dataContext, scriptinterpreter, pluginname, interpreterArgsQuoted) : ScriptResourceUtil.execScript(logger, workingdir, scriptfile, scriptargs, scriptargsarray, dataContext, dataContext, pluginname);
        }
        catch (IOException e) {
            throw new ResourceModelSourceException("Script execution could not start: " + e.getMessage(), e);
        }
        try {
            exec.getOutputStream().close();
            try (FileOutputStream fileOutputStream = new FileOutputStream(destinationTempFile);){
                errthread = Streams.copyStreamThread(exec.getErrorStream(), System.err);
                outthread = Streams.copyStreamThread(exec.getInputStream(), fileOutputStream);
                errthread.start();
                outthread.start();
                result = exec.waitFor();
                System.err.flush();
                fileOutputStream.flush();
                errthread.join();
                outthread.join();
                exec.getErrorStream().close();
                exec.getInputStream().close();
                success = 0 == result;
            }
        }
        catch (InterruptedException e) {
            logger.error("[" + pluginname + "]: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            logger.error("[" + pluginname + "]: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        logger.debug("[" + pluginname + "]: result code: " + result + ", success: " + success);
        if (null != outthread && null != outthread.getException()) {
            logger.error("[" + pluginname + "]: stream copy error: " + outthread.getException().getMessage(), (Throwable)outthread.getException());
        }
        if (null != errthread && null != errthread.getException()) {
            logger.error("[" + pluginname + "]: stream copy error: " + errthread.getException().getMessage(), (Throwable)errthread.getException());
        }
        try {
            if (!success) {
                throw new ResourceModelSourceException("Script execution failed with result: " + result);
            }
            if (destinationTempFile.isFile() && destinationTempFile.length() > 0L) {
                try {
                    INodeSet e = FileResourceModelSource.parseFile(destinationTempFile, fileformat, framework, project);
                    return e;
                }
                catch (ConfigurationException e) {
                    throw new ResourceModelSourceException(e);
                }
            }
            throw new ResourceModelSourceException("Script output was empty");
        }
        finally {
            if (!destinationTempFile.delete()) {
                logger.warn("[" + pluginname + "]: could not delete temp file: " + destinationTempFile.getAbsolutePath());
            }
        }
    }

    static Process execShellScript(Logger logger, File workingdir, File scriptfile, String scriptargs, String[] scriptargsarr, Map<String, Map<String, String>> envContext, Map<String, Map<String, String>> newDataContext, String interpreter, String logName, boolean interpreterArgsQuoted) throws IOException {
        ProcessBuilder processBuilder = ScriptResourceUtil.buildProcess(workingdir, scriptfile, scriptargs, scriptargsarr, envContext, newDataContext, interpreter, interpreterArgsQuoted);
        logger.info("[" + logName + "] executing: " + processBuilder.command());
        return processBuilder.start();
    }

    static ProcessBuilder buildProcess(File workingdir, File scriptfile, String scriptargs, Map<String, Map<String, String>> envContext, Map<String, Map<String, String>> newDataContext, String interpreter, boolean interpreterArgsQuoted) {
        return ScriptResourceUtil.buildProcess(workingdir, scriptfile, scriptargs, null, envContext, newDataContext, interpreter, interpreterArgsQuoted);
    }

    static ProcessBuilder buildProcess(File workingdir, File scriptfile, String scriptargs, String[] scriptargsarr, Map<String, Map<String, String>> envContext, Map<String, Map<String, String>> newDataContext, String interpreter, boolean interpreterArgsQuoted) {
        ArrayList<String> shells = new ArrayList<String>();
        if (null != interpreter) {
            shells.addAll(Arrays.asList(interpreter.split(" ")));
        }
        if (null != scriptargs || null != scriptargsarr) {
            if (interpreterArgsQuoted) {
                String newargs = null != scriptargs ? DataContextUtils.replaceDataReferencesInString(scriptargs, newDataContext) : DataContextUtils.join(Arrays.asList(DataContextUtils.replaceDataReferencesInArray(scriptargsarr, newDataContext)), " ");
                shells.add(scriptfile.getAbsolutePath() + " " + newargs);
            } else {
                shells.add(scriptfile.getAbsolutePath());
                shells.addAll(Arrays.asList(DataContextUtils.replaceDataReferencesInArray(null != scriptargsarr ? scriptargsarr : scriptargs.split(" "), newDataContext)));
            }
        } else {
            shells.add(scriptfile.getAbsolutePath());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(shells).directory(workingdir);
        Map<String, String> environment = processBuilder.environment();
        if (null != envContext) {
            environment.putAll(DataContextUtils.generateEnvVarsFromContext(envContext));
        }
        return processBuilder;
    }

    static Process execScript(Logger logger, File workingdir, File scriptfile, String scriptargs, String[] scriptargsarr, Map<String, Map<String, String>> envContext, Map<String, Map<String, String>> newDataContext, String logName) throws IOException {
        ExecParams execArgs = ScriptResourceUtil.buildExecParams(scriptfile, scriptargs, scriptargsarr, envContext, newDataContext);
        String[] args = execArgs.getArgs();
        String[] envarr = execArgs.getEnvarr();
        Runtime runtime = Runtime.getRuntime();
        logger.info("[" + logName + "] executing: " + StringArrayUtil.asString(args, " "));
        return runtime.exec(args, envarr, workingdir);
    }

    static ExecParams buildExecParams(File scriptfile, String scriptargs, Map<String, Map<String, String>> envContext, Map<String, Map<String, String>> newDataContext) {
        return ScriptResourceUtil.buildExecParams(scriptfile, scriptargs, null, envContext, newDataContext);
    }

    static ExecParams buildExecParams(File scriptfile, String scriptargs, String[] scriptargsarr, Map<String, Map<String, String>> envContext, Map<String, Map<String, String>> newDataContext) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(scriptfile.getAbsolutePath());
        if (null != scriptargsarr && scriptargsarr.length > 0) {
            list.addAll(Arrays.asList(DataContextUtils.replaceDataReferencesInArray(scriptargsarr, newDataContext)));
        } else if (null != scriptargs && !"".equals(scriptargs)) {
            list.addAll(Arrays.asList(DataContextUtils.replaceDataReferencesInArray(scriptargs.split(" "), newDataContext)));
        }
        String[] args = list.toArray(new String[list.size()]);
        Map<String, String> envMap = DataContextUtils.generateEnvVarsFromContext(envContext);
        ArrayList<CallSite> envlist = new ArrayList<CallSite>();
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            envlist.add((CallSite)((Object)(entry.getKey() + "=" + entry.getValue())));
        }
        String[] envarr = envlist.toArray(new String[envlist.size()]);
        return new ExecParams(args, envarr);
    }

    public static List<String> generateListStoragePath(Description pluginDesc, DataContext dataContext, Map<String, Object> configuration) {
        ArrayList<String> listStoragePath = new ArrayList<String>();
        Map<String, Object> expanded = DataContextUtils.replaceDataReferences(configuration, (Map<String, Map<String, String>>)dataContext);
        Map<String, String> data = MapData.toStringStringMap(expanded);
        for (Property property : pluginDesc.getProperties()) {
            Object conversion;
            Map<String, Object> renderingOptions;
            String name = property.getName();
            String propValue = data.get(name);
            if (null == propValue || (renderingOptions = property.getRenderingOptions()) == null || !StringRenderingConstants.ValueConversion.STORAGE_PATH_AUTOMATIC_READ.equalsOrString(conversion = renderingOptions.get("valueConversion"))) continue;
            listStoragePath.add(propValue);
        }
        return listStoragePath;
    }

    public static SecretBundle generateBundle(Description pluginDesc, DataContext dataContext, StorageTree storageTree, Map<String, Object> configuration, Logger logger) {
        List<String> listStoragePaths = ScriptResourceUtil.generateListStoragePath(pluginDesc, dataContext, configuration);
        DefaultSecretBundle bundle = new DefaultSecretBundle();
        for (String propValue : listStoragePaths) {
            Resource r = storageTree.getResource(propValue);
            if (r == null) continue;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                ((ResourceMeta)r.getContents()).writeContent(byteArrayOutputStream);
                bundle.addSecret(propValue, byteArrayOutputStream.toByteArray());
            }
            catch (IOException iex) {
                throw new RuntimeException(String.format("IOException Unable to add secret value to secret bundle for: %s", propValue));
            }
        }
        return bundle;
    }

    static class ExecParams {
        private String[] args;
        private String[] envarr;

        ExecParams(String[] args, String[] envarr) {
            this.args = args;
            this.envarr = envarr;
        }

        public String[] getArgs() {
            return this.args;
        }

        public String[] getEnvarr() {
            return this.envarr;
        }
    }
}

