/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.jsch;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.impl.common.BaseFileCopier;
import com.dtolabs.rundeck.core.execution.impl.jsch.JschNodeExecutor;
import com.dtolabs.rundeck.core.execution.impl.jsch.JschSecretBundleUtil;
import com.dtolabs.rundeck.core.execution.impl.jsch.NodeSSHConnectionInfo;
import com.dtolabs.rundeck.core.execution.proxy.ProxySecretBundleCreator;
import com.dtolabs.rundeck.core.execution.proxy.SecretBundle;
import com.dtolabs.rundeck.core.execution.script.ScriptfileUtils;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.service.MultiFileCopier;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.tasks.net.SSHTaskBuilder;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.taskdefs.optional.ssh.Scp;

public class JschScpFileCopier
extends BaseFileCopier
implements MultiFileCopier,
Describable,
ProxySecretBundleCreator {
    public static final String SERVICE_PROVIDER_TYPE = "jsch-scp";
    static final Description DESC = DescriptionBuilder.builder().name("jsch-scp").title("SCP").description("Copies a script file to a remote node via SCP.").property(JschNodeExecutor.SSH_KEY_FILE_PROP).property(JschNodeExecutor.SSH_KEY_STORAGE_PROP).property(JschNodeExecutor.SSH_PASSWORD_STORAGE_PROP).property(JschNodeExecutor.SSH_AUTH_TYPE_PROP).property(JschNodeExecutor.SSH_PASSPHRASE_STORAGE_PROP).property(JschNodeExecutor.PROP_BIND_ADDRESS).mapping("keypath", "project.ssh-keypath").mapping("authentication", "project.ssh-authentication").mapping("keystoragepath", "project.ssh-key-storage-path").mapping("passwordstoragepath", "project.ssh-password-storage-path").frameworkMapping("keystoragepath", "framework.ssh-key-storage-path").frameworkMapping("passwordstoragepath", "framework.ssh-password-storage-path").frameworkMapping("keypath", "framework.ssh-keypath").frameworkMapping("authentication", "framework.ssh-authentication").mapping("passphrasestoragepath", "project.ssh-key-passphrase-storage-path").frameworkMapping("passphrasestoragepath", "framework.ssh-key-passphrase-storage-path").mapping("ssh-bind-address", "project.bind-address").frameworkMapping("ssh-bind-address", "framework.bind-address").build();
    private Framework framework;

    @Override
    public Description getDescription() {
        return DESC;
    }

    public JschScpFileCopier(Framework framework) {
        this.framework = framework;
    }

    public String copyFileStream(ExecutionContext context, InputStream input, INodeEntry node) throws FileCopierException {
        return this.copyFile(context, null, input, null, node);
    }

    public String copyFile(ExecutionContext context, File scriptfile, INodeEntry node) throws FileCopierException {
        return this.copyFile(context, scriptfile, null, null, node);
    }

    public String copyScriptContent(ExecutionContext context, String script, INodeEntry node) throws FileCopierException {
        return this.copyFile(context, null, null, script, node);
    }

    private String copyFile(ExecutionContext context, File scriptfile, InputStream input, String script, INodeEntry node) throws FileCopierException {
        return this.copyFile(context, scriptfile, input, script, node, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyFile(ExecutionContext context, File scriptfile, InputStream input, String script, INodeEntry node, String destinationPath) throws FileCopierException {
        Scp scp;
        String remotefile;
        Project project = new Project();
        if (null == destinationPath) {
            String identity = null != context.getDataContext() && null != context.getDataContext().get("job") ? context.getDataContext().get("job").get("execid") : null;
            remotefile = JschScpFileCopier.generateRemoteFilepathForNode(node, context.getFramework().getFrameworkProjectMgr().getFrameworkProject(context.getFrameworkProject()), context.getFramework(), null != scriptfile ? scriptfile.getName() : "dispatch-script", null, identity);
        } else {
            remotefile = destinationPath;
        }
        File localTempfile = null != scriptfile ? scriptfile : JschScpFileCopier.writeTempFile(context, scriptfile, input, script);
        NodeSSHConnectionInfo nodeAuthentication = new NodeSSHConnectionInfo(node, this.framework, context);
        try {
            scp = null != scriptfile && scriptfile.isDirectory() ? SSHTaskBuilder.buildRecursiveScp(node, project, remotefile, localTempfile, nodeAuthentication, context.getLoglevel(), context.getExecutionListener()) : SSHTaskBuilder.buildScp(node, project, remotefile, localTempfile, nodeAuthentication, context.getLoglevel(), context.getExecutionListener());
        }
        catch (SSHTaskBuilder.BuilderException e) {
            throw new FileCopierException("Configuration error: " + e.getMessage(), StepFailureReason.ConfigurationFailure, e);
        }
        context.getExecutionListener().log(3, "copying file: '" + localTempfile.getAbsolutePath() + "' to: '" + node.getNodename() + ":" + remotefile + "'");
        Object errormsg = null;
        try {
            scp.execute();
        }
        catch (BuildException e) {
            this.handleBuildException(context, node, nodeAuthentication, e);
        }
        finally {
            if (null == scriptfile && !ScriptfileUtils.releaseTempFile(localTempfile)) {
                context.getExecutionListener().log(1, "Unable to remove local temp file: " + localTempfile.getAbsolutePath());
            }
        }
        return remotefile;
    }

    private String[] copyMultipleFiles(ExecutionContext context, File basedir, List<File> files, String remotePath, INodeEntry node) throws FileCopierException {
        Scp scp;
        Project project = new Project();
        ArrayList ret = new ArrayList();
        if (null == remotePath) {
            throw new FileCopierException("[jsch-scp] remotePath cant be null on multiple files", StepFailureReason.ConfigurationFailure);
        }
        NodeSSHConnectionInfo nodeAuthentication = new NodeSSHConnectionInfo(node, this.framework, context);
        try {
            scp = SSHTaskBuilder.buildMultiScp(node, project, basedir, files, remotePath, nodeAuthentication, context.getLoglevel(), context.getExecutionListener());
        }
        catch (SSHTaskBuilder.BuilderException e) {
            throw new FileCopierException("Configuration error: " + e.getMessage(), StepFailureReason.ConfigurationFailure, e);
        }
        context.getExecutionListener().log(3, String.format("copying  '%d' files to: '%s:%s'", files.size(), node.getNodename(), remotePath));
        Object errormsg = null;
        try {
            scp.execute();
        }
        catch (BuildException e) {
            this.handleBuildException(context, node, nodeAuthentication, e);
        }
        return ret.toArray(new String[0]);
    }

    private void handleBuildException(ExecutionContext context, INodeEntry node, NodeSSHConnectionInfo nodeAuthentication, BuildException e) throws FileCopierException {
        JschNodeExecutor.ExtractFailure failure = JschNodeExecutor.extractFailure(e, node, nodeAuthentication.getCommandTimeout(), nodeAuthentication.getConnectTimeout(), this.framework);
        String errormsg = failure.getErrormsg();
        FailureReason failureReason = failure.getReason();
        context.getExecutionListener().log(0, errormsg);
        throw new FileCopierException("[jsch-scp] Failed copying the file: " + errormsg, failureReason, (Exception)((Object)e));
    }

    private Echo createEcho(String message, Project project, String logLevel) {
        Echo echo = new Echo();
        echo.setProject(project);
        Echo.EchoLevel level = new Echo.EchoLevel();
        level.setValue(logLevel);
        echo.setLevel(level);
        echo.setMessage(message);
        return echo;
    }

    private Echo createEchoVerbose(String message, Project project) {
        return this.createEcho(message, project, "debug");
    }

    @Override
    public String copyFileStream(ExecutionContext context, InputStream input, INodeEntry node, String destination) throws FileCopierException {
        return this.copyFile(context, null, input, null, node, destination);
    }

    @Override
    public String copyFile(ExecutionContext context, File file, INodeEntry node, String destination) throws FileCopierException {
        return this.copyFile(context, file, null, null, node, destination);
    }

    @Override
    public String copyScriptContent(ExecutionContext context, String script, INodeEntry node, String destination) throws FileCopierException {
        return this.copyFile(context, null, null, script, node, destination);
    }

    @Override
    public String[] copyFiles(ExecutionContext context, File basedir, List<File> files, String remotePath, INodeEntry node) throws FileCopierException {
        return this.copyMultipleFiles(context, basedir, files, remotePath, node);
    }

    @Override
    public SecretBundle prepareSecretBundle(ExecutionContext context, INodeEntry node) {
        return JschSecretBundleUtil.createBundle(context, node);
    }

    @Override
    public List<String> listSecretsPath(ExecutionContext context, INodeEntry node) {
        return JschSecretBundleUtil.getSecretsPath(context, node);
    }
}

