/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.storage;

import com.dtolabs.rundeck.core.plugins.ConfiguredPlugin;
import com.dtolabs.rundeck.core.plugins.PluggableProviderService;
import com.dtolabs.rundeck.core.plugins.PluginRegistry;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.storage.KeyStorageLayer;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.storage.StorageConverterPluginAdapter;
import com.dtolabs.rundeck.core.storage.StorageLogger;
import com.dtolabs.rundeck.core.storage.StorageTimestamperConverter;
import com.dtolabs.rundeck.core.storage.StorageTree;
import com.dtolabs.rundeck.core.storage.StorageTreeInitializationException;
import com.dtolabs.rundeck.core.storage.StorageUtil;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import com.dtolabs.rundeck.core.utils.PropertyUtil;
import com.dtolabs.rundeck.plugins.storage.StorageConverterPlugin;
import com.dtolabs.rundeck.plugins.storage.StoragePlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.PathUtil;
import org.rundeck.storage.api.Tree;
import org.rundeck.storage.conf.ContentConverter;
import org.rundeck.storage.conf.Listener;
import org.rundeck.storage.conf.TreeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageTreeFactory {
    public static final String ORG_RUNDECK_STORAGE_EVENTS_LOGGER_NAME = "org.rundeck.storage.events";
    public static final String LOGGER_NAME = "loggerName";
    static Logger logger = LoggerFactory.getLogger(StorageTreeFactory.class);
    public static final String TYPE = "type";
    public static final String PATH = "path";
    public static final String CONFIG = "config";
    public static final String SEP = ".";
    public static final String REMOVE_PATH_PREFIX = "removePathPrefix";
    public static final String RESOURCE_SELECTOR = "resourceSelector";
    private IPropertyLookup frameworkPropertyLookup;
    private PluginRegistry pluginRegistry;
    private String storageConfigPrefix;
    private String converterConfigPrefix;
    private String baseStorageType;
    private String loggerName = "org.rundeck.storage.events";
    private Map<String, String> baseStorageConfig = new HashMap<String, String>();
    private Map<String, String> configuration = new HashMap<String, String>();
    private Set<String> defaultConverters = new HashSet<String>();
    private PluggableProviderService<StoragePlugin> storagePluginProviderService;
    private PluggableProviderService<StorageConverterPlugin> storageConverterPluginProviderService;

    public StorageTree createTree() throws Exception {
        if (null == this.frameworkPropertyLookup) {
            throw new StorageTreeInitializationException("'frameworkPropertyLookup' is required");
        }
        if (null == this.pluginRegistry) {
            throw new StorageTreeInitializationException("'pluginRegistry' is required");
        }
        if (null == this.storagePluginProviderService) {
            throw new StorageTreeInitializationException("'storagePluginProviderService' is required");
        }
        if (null == this.storageConverterPluginProviderService) {
            throw new StorageTreeInitializationException("'storageConverterPluginProviderService' is required");
        }
        if (null == this.storageConfigPrefix) {
            throw new StorageTreeInitializationException("'storageConfigPrefix' is required");
        }
        if (null == this.converterConfigPrefix) {
            throw new StorageTreeInitializationException("'converterConfigPrefix' is required");
        }
        if (null == this.baseStorageType) {
            throw new StorageTreeInitializationException("'baseStorageType' is required");
        }
        return StorageUtil.asStorageTree(this.buildTree(this.configuration));
    }

    public static StorageTree subTree(StorageTree storageTree, String subpath) {
        return StorageUtil.asStorageTree((Tree<ResourceMeta>)TreeBuilder.subPathTree((Tree)storageTree, (Path)PathUtil.asPath((String)subpath)));
    }

    private Tree<ResourceMeta> buildTree(Map<String, String> config) {
        if (null == config) {
            config = new HashMap<String, String>();
        }
        TreeBuilder<ResourceMeta> builder = this.baseStorage((TreeBuilder<ResourceMeta>)TreeBuilder.builder());
        int storeIndex = 1;
        while (config.containsKey(this.getStorageConfigPrefix() + SEP + storeIndex + ".type")) {
            this.configureStoragePlugin(builder, storeIndex, config);
            ++storeIndex;
        }
        if (1 == storeIndex) {
            logger.debug("No storage plugins configured with prefix " + this.getStorageConfigPrefix());
        }
        builder = this.addLogger(builder, config);
        builder = this.baseConverter(builder);
        int converterIndex = 1;
        while (config.containsKey(this.getConverterConfigPrefix() + SEP + converterIndex + ".type")) {
            builder = this.configureConverterPlugin(builder, converterIndex, config);
            ++converterIndex;
        }
        if (1 == converterIndex) {
            logger.debug("No converter plugins configured with prefix " + this.getConverterConfigPrefix());
        }
        return builder.build();
    }

    private TreeBuilder<ResourceMeta> baseConverter(TreeBuilder<ResourceMeta> builder) {
        if (null != this.defaultConverters && this.defaultConverters.contains("StorageTimestamperConverter")) {
            logger.debug("Configuring base converter: StorageTimestamperConverter");
            builder = builder.convert((ContentConverter)new StorageConverterPluginAdapter("builtin:timestamp", new StorageTimestamperConverter()));
        }
        if (null != this.defaultConverters && this.defaultConverters.contains("KeyStorageLayer")) {
            logger.debug("Configuring base converter: KeyStorageLayer");
            builder = builder.convert((ContentConverter)new StorageConverterPluginAdapter("builtin:ssh-storage", new KeyStorageLayer()), PathUtil.asPath((String)"/keys"));
        }
        return builder;
    }

    private TreeBuilder<ResourceMeta> addLogger(TreeBuilder<ResourceMeta> builder, Map<String, String> config) {
        String loggerName = this.getLoggerName();
        if (null != config.get(LOGGER_NAME)) {
            loggerName = config.get(LOGGER_NAME);
        }
        if (null == loggerName) {
            loggerName = ORG_RUNDECK_STORAGE_EVENTS_LOGGER_NAME;
        }
        logger.debug("Add log4j logger for storage with name: " + loggerName);
        return builder.listen((Listener)new StorageLogger(loggerName));
    }

    private TreeBuilder<ResourceMeta> baseStorage(TreeBuilder<ResourceMeta> builder) {
        Map<String, String> config1 = this.expandConfig(this.getBaseStorageConfig());
        logger.debug("Default base storage provider: " + this.getBaseStorageType() + ", config: " + config1);
        StoragePlugin base = this.loadPlugin(this.getBaseStorageType(), config1, this.storagePluginProviderService);
        if (null == base) {
            throw new IllegalArgumentException("Plugin could not be loaded: " + this.getBaseStorageType());
        }
        return builder.base((Tree)base);
    }

    private Map<String, String> stringStringMap(Map map) {
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        for (Object o : map.keySet()) {
            stringStringHashMap.put(o.toString(), map.get(o).toString());
        }
        return stringStringHashMap;
    }

    private TreeBuilder<ResourceMeta> configureConverterPlugin(TreeBuilder<ResourceMeta> builder, int index, Map<String, String> configProps) {
        String pref1 = this.getConverterConfigPrefix() + SEP + index;
        String pluginType = configProps.get(pref1 + ".type");
        String pathProp = pref1 + ".path";
        String selectorProp = pref1 + ".resourceSelector";
        String path = configProps.get(pathProp);
        String selector = configProps.get(selectorProp);
        if (null == path && null == selector) {
            throw new IllegalArgumentException("Converter plugin [" + index + "] specified by " + pref1 + " MUST define one of: " + pathProp + " OR " + selectorProp);
        }
        Map<String, String> config = this.subPropertyMap(pref1 + ".config.", configProps);
        config = this.expandConfig(config);
        logger.debug("Add Converter[" + index + "]:" + (null != path ? path : "/") + "[" + (null != selector ? selector : "*") + "] " + pluginType + ", config: " + config);
        return this.buildConverterPlugin(builder, pluginType, path, selector, config);
    }

    private TreeBuilder<ResourceMeta> buildConverterPlugin(TreeBuilder<ResourceMeta> builder, String pluginType, String path, String selector, Map<String, String> config) {
        StorageConverterPlugin converterPlugin = this.loadPlugin(pluginType, config, this.storageConverterPluginProviderService);
        return builder.convert((ContentConverter)new StorageConverterPluginAdapter(pluginType, converterPlugin), null != path ? PathUtil.asPath((String)path.trim()) : null, null != selector ? PathUtil.resourceSelector((String)selector) : null);
    }

    private Map<String, String> subPropertyMap(String configPrefix, Map propertiesMap) {
        HashMap<String, String> config = new HashMap<String, String>();
        for (Object o : propertiesMap.keySet()) {
            String key = (String)o;
            if (!key.startsWith(configPrefix)) continue;
            String conf = key.substring(configPrefix.length());
            config.put(conf, propertiesMap.get(key).toString());
        }
        return config;
    }

    private void configureStoragePlugin(TreeBuilder<ResourceMeta> builder, int index, Map<String, String> configProps) {
        String pref1 = this.getStorageConfigPrefix() + SEP + index;
        String pluginType = configProps.get(pref1 + ".type");
        String path = configProps.get(pref1 + ".path");
        boolean removePathPrefix = Boolean.parseBoolean(configProps.get(pref1 + ".removePathPrefix"));
        Map<String, String> config = this.subPropertyMap(pref1 + ".config.", configProps);
        config = this.expandConfig(config);
        Tree resourceMetaTree = this.loadPlugin(pluginType, config, this.storagePluginProviderService);
        if (index == 1 && PathUtil.isRoot((String)path)) {
            logger.debug("New base Storage[" + index + "]:" + path + " " + pluginType + ", config: " + config);
            builder.base(resourceMetaTree);
        } else {
            logger.debug("Subtree Storage[" + index + "]:" + path + " " + pluginType + ", config: " + config);
            builder.subTree(PathUtil.asPath((String)path.trim()), resourceMetaTree, !removePathPrefix);
        }
    }

    private Map<String, String> expandConfig(Map<String, String> map) {
        return this.expandAllProperties(map, this.getPropertyLookup().getPropertiesMap());
    }

    private IPropertyLookup getPropertyLookup() {
        return this.frameworkPropertyLookup;
    }

    private Map<String, String> expandAllProperties(Map<String, String> source, Map values) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : source.keySet()) {
            result.put(s, PropertyUtil.expand(source.get(s), values));
        }
        return result;
    }

    private <T> T loadPlugin(String pluginType, Map<String, String> config, PluggableProviderService<T> service) {
        ConfiguredPlugin<T> configured = this.getPluginRegistry().retainConfigurePluginByName(pluginType, service, PropertyResolverFactory.createResolver(PropertyResolverFactory.instanceRetriever(config), null, this.getPropertyLookup()), PropertyScope.Instance);
        if (null == configured) {
            throw new IllegalArgumentException(service.getName() + " Plugin named \"" + pluginType + "\" could not be loaded");
        }
        return configured.getInstance();
    }

    public String getStorageConfigPrefix() {
        return this.storageConfigPrefix;
    }

    public void setStorageConfigPrefix(String storageConfigPrefix) {
        this.storageConfigPrefix = storageConfigPrefix;
    }

    public String getConverterConfigPrefix() {
        return this.converterConfigPrefix;
    }

    public void setConverterConfigPrefix(String converterConfigPrefix) {
        this.converterConfigPrefix = converterConfigPrefix;
    }

    public PluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public void setPluginRegistry(PluginRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
    }

    public PluggableProviderService getStorageConverterPluginProviderService() {
        return this.storageConverterPluginProviderService;
    }

    public void setStorageConverterPluginProviderService(PluggableProviderService storageConverterPluginProviderService) {
        this.storageConverterPluginProviderService = storageConverterPluginProviderService;
    }

    public PluggableProviderService getStoragePluginProviderService() {
        return this.storagePluginProviderService;
    }

    public void setStoragePluginProviderService(PluggableProviderService storagePluginProviderService) {
        this.storagePluginProviderService = storagePluginProviderService;
    }

    public String getBaseStorageType() {
        return this.baseStorageType;
    }

    public void setBaseStorageType(String baseStorageType) {
        this.baseStorageType = baseStorageType;
    }

    public Map<String, String> getBaseStorageConfig() {
        return this.baseStorageConfig;
    }

    public void setBaseStorageConfig(Map<String, String> baseStorageConfig) {
        this.baseStorageConfig = baseStorageConfig;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public Set<String> getDefaultConverters() {
        return this.defaultConverters;
    }

    public void setDefaultConverters(Set<String> defaultConverters) {
        this.defaultConverters = defaultConverters;
    }

    public IPropertyLookup getFrameworkPropertyLookup() {
        return this.frameworkPropertyLookup;
    }

    public void setFrameworkPropertyLookup(IPropertyLookup frameworkPropertyLookup) {
        this.frameworkPropertyLookup = frameworkPropertyLookup;
    }
}

