/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.gui;

import java.util.function.Function;

public interface MenuItem {
    public MenuType getType();

    default public Integer getPriority() {
        return 0;
    }

    public String getTitleCode();

    public String getTitle();

    default public String getHref() {
        return null;
    }

    default public String getProjectHref(String project) {
        return null;
    }

    default public String getExecutionHref(String project, String executionId) {
        return null;
    }

    default public String getIconCSS() {
        return null;
    }

    default public boolean isEnabled() {
        return true;
    }

    default public boolean isEnabled(String project) {
        return true;
    }

    default public boolean isEnabledExecution(String project, String executionId) {
        return true;
    }

    public static Function<MenuItem, Boolean> getEnabledCheck(MenuType menuType, String project, String executionId) {
        return item -> item.getType().isProjectType() && menuType.isProjectType() ? item.isEnabled(project) : (item.getType().isExecutionType() && menuType.isExecutionType() ? item.isEnabledExecution(project, executionId) : item.isEnabled());
    }

    public static enum MenuType {
        PROJECT(MenuDomain.PROJECT),
        PROJECT_CONFIG(MenuDomain.PROJECT),
        SYSTEM_CONFIG(MenuDomain.SYSTEM),
        USER_MENU(MenuDomain.SYSTEM),
        EXECUTION_RETRY(MenuDomain.EXECUTION);

        private final MenuDomain domain;

        private MenuType(MenuDomain domain) {
            this.domain = domain;
        }

        public boolean isProjectType() {
            return this.domain == MenuDomain.PROJECT;
        }

        public boolean isExecutionType() {
            return this.domain == MenuDomain.EXECUTION;
        }

        public boolean isSystemType() {
            return this.domain == MenuDomain.SYSTEM;
        }

        public Function<MenuItem, Boolean> getEnabledCheck(String project, String executionId) {
            return MenuItem.getEnabledCheck(this, project, executionId);
        }
    }

    public static enum MenuDomain {
        SYSTEM,
        PROJECT,
        EXECUTION;

    }
}

