/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.NodesSelector;
import java.util.Collection;
import java.util.HashSet;

public class SelectorUtils {
    public static NodesSelector and(NodesSelector a, NodesSelector b) {
        return new AndNodesSelector(a, b);
    }

    public static NodesSelector or(NodesSelector a, NodesSelector b) {
        return new OrNodesSelector(a, b);
    }

    public static NodesSelector singleNode(String nodename) {
        return new MultiNodeSelector(nodename);
    }

    public static NodesSelector nodeList(Collection<String> nodenames) {
        return new MultiNodeSelector(nodenames);
    }

    public static class MultiNodeSelector
    implements NodesSelector {
        private final HashSet<String> nodenames;

        public MultiNodeSelector(String nodename) {
            this.nodenames = new HashSet();
            this.nodenames.add(nodename);
        }

        public MultiNodeSelector(Collection<String> nodenames) {
            this.nodenames = new HashSet<String>(nodenames);
        }

        @Override
        public boolean acceptNode(INodeEntry entry) {
            return this.nodenames.contains(entry.getNodename());
        }

        public String toString() {
            return "MultiNodeSelector{nodenames=" + this.nodenames + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiNodeSelector that = (MultiNodeSelector)o;
            return !(this.nodenames != null ? !this.nodenames.equals(that.nodenames) : that.nodenames != null);
        }

        public int hashCode() {
            return this.nodenames != null ? this.nodenames.hashCode() : 0;
        }
    }

    public static class OrNodesSelector
    extends ChainNodesSelector {
        public OrNodesSelector(NodesSelector aselector, NodesSelector bselector) {
            super(aselector, bselector);
        }

        @Override
        public boolean acceptNode(INodeEntry entry) {
            return this.aselector.acceptNode(entry) || this.bselector.acceptNode(entry);
        }
    }

    public static class AndNodesSelector
    extends ChainNodesSelector {
        public AndNodesSelector(NodesSelector aselector, NodesSelector bselector) {
            super(aselector, bselector);
        }

        @Override
        public boolean acceptNode(INodeEntry entry) {
            return this.aselector.acceptNode(entry) && this.bselector.acceptNode(entry);
        }
    }

    private static abstract class ChainNodesSelector
    implements NodesSelector {
        NodesSelector aselector;
        NodesSelector bselector;

        public ChainNodesSelector(NodesSelector aselector, NodesSelector bselector) {
            this.aselector = aselector;
            this.bselector = bselector;
        }
    }
}

