/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.utils;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.IRundeckProject;

public class ResolverUtil {
    public static final String PROJ_PROP_PREFIX = "project.";
    public static final String FWK_PROP_PREFIX = "framework.";

    public static String resolveProperty(String nodeAttribute, String defaultValue, INodeEntry node, IRundeckProject frameworkProject, Framework framework) {
        if (null != node.getAttributes().get(nodeAttribute)) {
            return node.getAttributes().get(nodeAttribute);
        }
        if (frameworkProject.hasProperty(PROJ_PROP_PREFIX + nodeAttribute) && !"".equals(frameworkProject.getProperty(PROJ_PROP_PREFIX + nodeAttribute))) {
            return frameworkProject.getProperty(PROJ_PROP_PREFIX + nodeAttribute);
        }
        if (framework.hasProperty(FWK_PROP_PREFIX + nodeAttribute)) {
            return framework.getProperty(FWK_PROP_PREFIX + nodeAttribute);
        }
        return defaultValue;
    }

    public static int resolveIntProperty(String attribute, int defaultValue, INodeEntry iNodeEntry, IRundeckProject frameworkProject, Framework framework) {
        int value = defaultValue;
        String string = ResolverUtil.resolveProperty(attribute, null, iNodeEntry, frameworkProject, framework);
        if (null != string) {
            try {
                value = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static long resolveLongProperty(String attribute, long defaultValue, INodeEntry iNodeEntry, IRundeckProject frameworkProject, Framework framework) {
        long value = defaultValue;
        String string = ResolverUtil.resolveProperty(attribute, null, iNodeEntry, frameworkProject, framework);
        if (null != string) {
            try {
                value = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static boolean resolveBooleanProperty(String attribute, boolean defaultValue, INodeEntry iNodeEntry, IRundeckProject frameworkProject, Framework framework) {
        boolean value = defaultValue;
        String string = ResolverUtil.resolveProperty(attribute, null, iNodeEntry, frameworkProject, framework);
        if (null != string) {
            value = Boolean.parseBoolean(string);
        }
        return value;
    }
}

