/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeReceiver;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class NodeSetImpl
implements INodeSet,
NodeReceiver {
    TreeMap<String, INodeEntry> nodes;

    public NodeSetImpl() {
        this(new HashMap<String, INodeEntry>());
    }

    public NodeSetImpl(HashMap<String, INodeEntry> nodes) {
        this.nodes = new TreeMap<String, INodeEntry>(nodes);
    }

    public static NodeSetImpl singleNodeSet(INodeEntry node) {
        NodeSetImpl entries = new NodeSetImpl();
        entries.putNode(node);
        return entries;
    }

    @Override
    public void putNode(INodeEntry node) {
        if (null == node.getNodename()) {
            throw new IllegalArgumentException("nodename is null");
        }
        this.nodes.put(node.getNodename(), node);
    }

    @Override
    public Collection<INodeEntry> getNodes() {
        return this.nodes.values();
    }

    @Override
    public INodeEntry getNode(String name) {
        return this.nodes.get(name);
    }

    @Override
    public Collection<String> getNodeNames() {
        return this.nodes.keySet();
    }

    public void putNodes(INodeSet set) {
        this.putNodes(set.getNodes());
    }

    public void putNodes(Collection<INodeEntry> set) {
        for (INodeEntry iNodeEntry : set) {
            this.putNode(iNodeEntry);
        }
    }

    public String toString() {
        return "NodeSetImpl{nodes=" + this.nodes + "}";
    }

    @Override
    public Iterator<INodeEntry> iterator() {
        return this.nodes.values().iterator();
    }
}

