/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution;

import com.dtolabs.rundeck.core.CoreException;
import com.dtolabs.rundeck.core.common.IExecutionProviders;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.data.SharedDataContextUtils;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.NodeExecutorUtils;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.dispatch.Dispatchable;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.FileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.service.MultiFileCopier;
import com.dtolabs.rundeck.core.execution.service.MultiFileCopierUtil;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WFSharedContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import com.dtolabs.rundeck.core.logging.PluginLoggingManager;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExecutionServiceImpl
implements ExecutionService {
    private IExecutionProviders executionProviders;

    protected WorkflowExecutionListener getWorkflowListener(ExecutionContext executionContext) {
        WorkflowExecutionListener wlistener = executionContext.getWorkflowExecutionListener();
        if (null != wlistener) {
            return wlistener;
        }
        ExecutionListener elistener = executionContext.getExecutionListener();
        if (null != elistener && elistener instanceof WorkflowExecutionListener) {
            return (WorkflowExecutionListener)((Object)elistener);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StepExecutionResult executeStep(StepExecutionContext context, StepExecutionItem item) throws StepException {
        StepExecutor executor;
        try {
            executor = this.getExecutionProviders().getStepExecutorForItem(item, context.getFrameworkProject());
        }
        catch (ExecutionServiceException e) {
            return new StepExecutionResultImpl(e, ServiceFailureReason.ServiceFailure, e.getMessage());
        }
        StepExecutionResult result = null;
        try {
            if (null != this.getWorkflowListener(context)) {
                this.getWorkflowListener(context).beginStepExecution(executor, context, item);
            }
            PluginLoggingManager pluginLogging = null;
            if (null != context.getLoggingManager()) {
                pluginLogging = context.getLoggingManager().createPluginLogging(context, item);
            }
            if (null != pluginLogging) {
                pluginLogging.begin();
            }
            try {
                context.getPluginControlService().checkDisabledPlugin(item.getType(), "WorkflowStep");
                result = executor.executeWorkflowStep(context, item);
                if (null != pluginLogging) {
                    pluginLogging.end(result);
                }
            }
            catch (Throwable throwable) {
                if (null != pluginLogging) {
                    pluginLogging.end(result);
                }
                throw throwable;
            }
            if (null != this.getWorkflowListener(context)) {
                this.getWorkflowListener(context).finishStepExecution(executor, result, context, item);
            }
        }
        catch (Throwable throwable) {
            if (null != this.getWorkflowListener(context)) {
                this.getWorkflowListener(context).finishStepExecution(executor, result, context, item);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeStepResult executeNodeStep(StepExecutionContext context, NodeStepExecutionItem item, INodeEntry node) throws NodeStepException {
        NodeStepExecutor interpreter;
        try {
            interpreter = this.getExecutionProviders().getNodeStepExecutorForItem(item, context, node);
        }
        catch (ExecutionServiceException e) {
            throw new NodeStepException((Throwable)e, (FailureReason)ServiceFailureReason.ServiceFailure, node.getNodename());
        }
        if (null != this.getWorkflowListener(context)) {
            this.getWorkflowListener(context).beginExecuteNodeStep(context, item, node);
        }
        boolean secureOptionReplaced = false;
        Map<String, String> nodeDeferredOptions = context.getDataContext().get("nodeDeferred");
        Map<String, String> options = context.getDataContext().get("option");
        if (nodeDeferredOptions != null) {
            for (String key : nodeDeferredOptions.keySet()) {
                String currentValue;
                String val = nodeDeferredOptions.get(key);
                if (options == null || !options.containsKey(key) || !(currentValue = options.get(key)).equals(val)) continue;
                val = SharedDataContextUtils.replaceDataReferences(val, context.getSharedDataContext(), ContextView.node(node.getNodename()), ContextView::nodeStep, DataContextUtils.replaceMissingOptionsWithBlank, false, false);
                try {
                    InputStream defaultVal = ((ResourceMeta)context.getStorageTree().getResource(val).getContents()).getInputStream();
                    String pass = CharStreams.toString((Readable)new InputStreamReader(defaultVal, Charsets.UTF_8));
                    context.getDataContext().get("option").put(key, pass);
                    secureOptionReplaced = true;
                }
                catch (IOException ex) {
                    throw new NodeStepException((Throwable)ex, (FailureReason)StepFailureReason.Unknown, node.getNodename());
                }
            }
        }
        NodeStepResult result = null;
        try {
            ExecutionContextImpl nodeContext = secureOptionReplaced ? new ExecutionContextImpl.Builder(context).singleNodeContext(node, true).sharedDataContext(WFSharedContext.with(ContextView.global(), context.getDataContextObject())).build() : new ExecutionContextImpl.Builder(context).singleNodeContext(node, true).build();
            PluginLoggingManager pluginLogging = null;
            if (null != context.getLoggingManager()) {
                pluginLogging = context.getLoggingManager().createPluginLogging(nodeContext, item);
            }
            if (null != pluginLogging) {
                pluginLogging.begin();
            }
            try {
                context.getPluginControlService().checkDisabledPlugin(item.getNodeStepType(), "WorkflowNodeStep");
                result = interpreter.executeNodeStep(nodeContext, item, node);
            }
            finally {
                if (null != pluginLogging) {
                    pluginLogging.end(result);
                }
            }
            if (!result.isSuccess()) {
                context.getExecutionListener().log(0, "Failed: " + result.toString());
            }
        }
        catch (NodeStepException e) {
            result = new NodeStepResultImpl(e, e.getFailureReason(), e.getMessage(), node);
            throw e;
        }
        catch (Throwable t) {
            result = new NodeStepResultImpl(t, StepFailureReason.Unknown, t.getMessage(), node);
            throw new NodeStepException(t, (FailureReason)StepFailureReason.Unknown, node.getNodename());
        }
        finally {
            if (null != this.getWorkflowListener(context)) {
                this.getWorkflowListener(context).finishExecuteNodeStep(result, context, item, node);
            }
        }
        return result;
    }

    @Override
    public DispatcherResult dispatchToNodes(StepExecutionContext context, NodeStepExecutionItem item) throws DispatcherException, ExecutionServiceException {
        return this.dispatchToNodesWith(context, null, item);
    }

    @Override
    public DispatcherResult dispatchToNodes(StepExecutionContext context, Dispatchable item) throws DispatcherException, ExecutionServiceException {
        return this.dispatchToNodesWith(context, item, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DispatcherResult dispatchToNodesWith(StepExecutionContext context, Dispatchable dispatchable, NodeStepExecutionItem item) throws DispatcherException, ExecutionServiceException {
        if (null != context.getExecutionListener()) {
            if (null != item) {
                context.getExecutionListener().beginNodeDispatch((ExecutionContext)context, item);
            } else if (null != dispatchable) {
                context.getExecutionListener().beginNodeDispatch((ExecutionContext)context, dispatchable);
            }
        }
        NodeDispatcher dispatcher = this.getExecutionProviders().getNodeDispatcherForContext(context);
        DispatcherResult result = null;
        try {
            result = null != item ? dispatcher.dispatch(context, item) : dispatcher.dispatch(context, dispatchable);
        }
        finally {
            if (null != context.getExecutionListener()) {
                if (null != item) {
                    context.getExecutionListener().finishNodeDispatch(result, (ExecutionContext)context, item);
                } else if (null != dispatchable) {
                    context.getExecutionListener().finishNodeDispatch(result, (ExecutionContext)context, dispatchable);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileCopyFileStream(ExecutionContext context, InputStream input, INodeEntry node, String destinationPath) throws FileCopierException {
        FileCopier copier;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginFileCopyFileStream(context, input, node);
        }
        try {
            copier = this.getExecutionProviders().getFileCopierForNodeAndProject(node, context);
        }
        catch (ExecutionServiceException e) {
            throw new FileCopierException(e.getMessage(), ServiceFailureReason.ServiceFailure, e);
        }
        String result = null;
        try {
            result = copier.copyFileStream(context, input, node, destinationPath);
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishFileCopy(result, context, node);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileCopyFile(ExecutionContext context, File file, INodeEntry node, String destinationPath) throws FileCopierException {
        FileCopier copier;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginFileCopyFile(context, file, node);
        }
        try {
            copier = this.getExecutionProviders().getFileCopierForNodeAndProject(node, context);
        }
        catch (ExecutionServiceException e) {
            throw new FileCopierException(e.getMessage(), ServiceFailureReason.ServiceFailure, e);
        }
        String result = null;
        try {
            result = copier.copyFile(context, file, node, destinationPath);
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishFileCopy(result, context, node);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] fileCopyFiles(ExecutionContext context, File basedir, List<File> files, String remotePath, INodeEntry node) throws FileCopierException {
        FileCopier copier;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginFileCopyFile(context, files, node);
        }
        try {
            copier = this.getExecutionProviders().getFileCopierForNodeAndProject(node, context);
        }
        catch (ExecutionServiceException e) {
            throw new FileCopierException(e.getMessage(), ServiceFailureReason.ServiceFailure, e);
        }
        String[] result = null;
        try {
            if (copier instanceof MultiFileCopier) {
                MultiFileCopier dcopier = (MultiFileCopier)copier;
                result = dcopier.copyFiles(context, basedir, files, remotePath, node);
            } else {
                result = MultiFileCopierUtil.copyMultipleFiles(copier, context, basedir, files, remotePath, node);
            }
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishMultiFileCopy(result, context, node);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileCopyScriptContent(ExecutionContext context, String script, INodeEntry node, String destinationPath) throws FileCopierException {
        FileCopier copier;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginFileCopyScriptContent(context, script, node);
        }
        try {
            copier = this.getExecutionProviders().getFileCopierForNodeAndProject(node, context);
        }
        catch (ExecutionServiceException e) {
            throw new FileCopierException(e.getMessage(), ServiceFailureReason.ServiceFailure, e);
        }
        String result = null;
        try {
            result = copier.copyScriptContent(context, script, node, destinationPath);
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishFileCopy(result, context, node);
            }
        }
        return result;
    }

    @Override
    public NodeExecutorResult executeCommand(ExecutionContext context, String[] command, INodeEntry node) {
        boolean featureQuotingBackwardCompatible = Boolean.valueOf(context.getIFramework().getPropertyRetriever().getProperty("rundeck.feature.quoting.backwardCompatible"));
        return this.executeCommand(context, ExecArgList.fromStrings(featureQuotingBackwardCompatible, DataContextUtils.stringContainsPropertyReferencePredicate, command), node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeExecutorResult executeCommand(ExecutionContext context, ExecArgList command, INodeEntry node) {
        NodeExecutor nodeExecutor;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginNodeExecution(context, command.asFlatStringArray(), node);
        }
        try {
            nodeExecutor = this.getExecutionProviders().getNodeExecutorForNodeAndProject(node, context);
        }
        catch (ExecutionServiceException e) {
            throw new CoreException(e);
        }
        ExecutionContextImpl nodeContext = new ExecutionContextImpl.Builder(context).nodeContextData(node).build();
        ArrayList<String> commandList = command.buildCommandForNode(nodeContext.getSharedDataContext(), node.getNodename(), node.getOsFamily());
        NodeExecutorResult result = null;
        String[] commandArray = commandList.toArray(new String[commandList.size()]);
        if (nodeExecutor.supportVariableInjection()) {
            commandArray = NodeExecutorUtils.getExportedVariablesForNode(node, nodeContext, commandList);
        }
        try {
            result = nodeExecutor.executeCommand(nodeContext, commandArray, node);
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishNodeExecution(result, context, commandArray, node);
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return "ExecutionService";
    }

    public IExecutionProviders getExecutionProviders() {
        return this.executionProviders;
    }

    public void setExecutionProviders(IExecutionProviders executionProviders) {
        this.executionProviders = executionProviders;
    }

    static enum ServiceFailureReason implements FailureReason
    {
        ServiceFailure;

    }
}

