/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.dispatch;

import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.IServicesRegistration;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import com.dtolabs.rundeck.core.execution.dispatch.OrchestratorNodeDispatcher;
import com.dtolabs.rundeck.core.execution.dispatch.ParallelNodeDispatcher;
import com.dtolabs.rundeck.core.execution.dispatch.SequentialNodeDispatcher;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.plugins.IFrameworkProviderRegistryService;
import com.dtolabs.rundeck.core.plugins.PluggableProviderService;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableServiceUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import java.util.List;

public class NodeDispatcherService
extends IFrameworkProviderRegistryService<NodeDispatcher>
implements PluggableProviderService<NodeDispatcher> {
    private static final String SERVICE_NAME = "NodeDispatcher";

    public NodeDispatcherService(IFramework framework) {
        super(framework);
        this.registry.put("parallel", ParallelNodeDispatcher.class);
        this.registry.put("sequential", SequentialNodeDispatcher.class);
        this.registry.put("orchestrator", OrchestratorNodeDispatcher.class);
    }

    public NodeDispatcher getNodeDispatcher(ExecutionContext context) throws ExecutionServiceException {
        if (context.getOrchestrator() != null) {
            return (NodeDispatcher)this.providerOfType("orchestrator");
        }
        if (context.getThreadCount() > 1 && context.getNodes().getNodeNames().size() > 1) {
            return (NodeDispatcher)this.providerOfType("parallel");
        }
        return (NodeDispatcher)this.providerOfType("sequential");
    }

    public static NodeDispatcherService getInstanceForFramework(IFramework framework, IServicesRegistration registration) {
        if (null == registration.getService(SERVICE_NAME)) {
            NodeDispatcherService service = new NodeDispatcherService(framework);
            registration.setService(SERVICE_NAME, service);
            return service;
        }
        return (NodeDispatcherService)registration.getService(SERVICE_NAME);
    }

    @Override
    public List<Description> listDescriptions() {
        return DescribableServiceUtil.listDescriptions(this);
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return DescribableServiceUtil.listDescribableProviders(this);
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }
}

