/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.logging.internal;

import com.dtolabs.rundeck.core.execution.Contextual;
import com.dtolabs.rundeck.core.logging.LogEvent;
import com.dtolabs.rundeck.core.logging.LogLevel;
import com.dtolabs.rundeck.core.logging.internal.DefaultLogEvent;
import com.dtolabs.rundeck.core.utils.LogBuffer;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class LogEventBuffer
implements Comparable,
LogBuffer<LogEvent> {
    Date time;
    Map<String, String> context;
    Contextual listener;
    ByteArrayOutputStream baos;
    Long serial;
    static final AtomicLong counter = new AtomicLong(0L);
    private Charset charset;
    private LogLevel level;

    public LogEventBuffer(LogLevel level, Contextual listener, Charset charset) {
        this.level = level;
        this.serial = counter.incrementAndGet();
        this.listener = listener;
        this.reset(listener.getContext());
        this.charset = charset;
    }

    public LogEventBuffer(LogLevel level, Contextual listener) {
        this(level, listener, null);
    }

    @Override
    public boolean isEmpty() {
        return this.time == null;
    }

    @Override
    public void clear() {
        this.time = null;
        this.context = null;
        this.baos = new ByteArrayOutputStream();
    }

    @Override
    public void reset() {
        this.reset(this.listener.getContext());
    }

    void reset(Map<String, String> context) {
        this.time = new Date();
        this.context = context;
        this.baos = new ByteArrayOutputStream();
    }

    @Override
    public void write(byte b) {
        this.baos.write(b);
    }

    @Override
    public LogEvent get() {
        String string = this.baos != null ? (this.charset != null ? this.baos.toString(this.charset) : this.baos.toString()) : "";
        return new DefaultLogEvent(this.level, this.time != null ? this.time : new Date(), string, "log", this.context != null ? this.context : new HashMap<String, String>());
    }

    public int compareTo(Object o) {
        if (!(o instanceof LogEventBuffer)) {
            return -1;
        }
        LogEventBuffer other = (LogEventBuffer)o;
        int td = LogEventBuffer.compareDates(this.time, other.time);
        if (td != 0) {
            return td;
        }
        return this.serial.compareTo(other.serial);
    }

    static int compareDates(Date a, Date b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a != null && b != null) {
            return a.compareTo(b);
        }
        return a != null ? -1 : 1;
    }
}

