/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.Condition;
import com.dtolabs.rundeck.core.rules.NumericCondition;
import com.dtolabs.rundeck.core.rules.StateObj;

public class NumericLessThanCondition
implements Condition {
    private String key;
    private String value;

    public NumericLessThanCondition(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean test(StateObj input) {
        String anObject = input.getState().get(this.key);
        if (this.value == null) {
            return false;
        }
        String nValue = input.getState().get(this.value);
        Float fValue = nValue == null ? NumericCondition.extractFloat(this.value) : NumericCondition.extractFloat(nValue);
        Float fObject = NumericCondition.extractFloat(anObject);
        return fObject.floatValue() < fValue.floatValue();
    }

    public String toString() {
        return "(" + this.value + " < '" + this.key + "')";
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

