/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.storage;

import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.storage.ResourceMetaBuilder;
import com.dtolabs.rundeck.core.storage.StorageConverter;
import com.dtolabs.rundeck.core.storage.StorageUtil;
import com.dtolabs.rundeck.plugins.storage.StorageConverterPlugin;
import java.util.HashMap;
import org.rundeck.storage.api.HasInputStream;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageConverterPluginAdapter
implements StorageConverter {
    static final Logger logger = LoggerFactory.getLogger(StorageConverterPluginAdapter.class);
    StorageConverterPlugin plugin;
    String providerName;

    public StorageConverterPluginAdapter(String providerName, StorageConverterPlugin plugin) {
        this.providerName = providerName;
        this.plugin = plugin;
    }

    private ResourceMeta filter(Path path, ResourceMeta resourceMeta, Operation op) {
        HasInputStream result;
        ResourceMetaBuilder resourceMetaBuilder = StorageUtil.create(new HashMap<String, String>(resourceMeta.getMeta()));
        switch (op) {
            case READ: 
            case UPDATE: 
            case CREATE: {
                try {
                    if (op == Operation.CREATE) {
                        result = this.plugin.createResource(path, resourceMetaBuilder, (HasInputStream)resourceMeta);
                        break;
                    }
                    if (op == Operation.READ) {
                        result = this.plugin.readResource(path, resourceMetaBuilder, (HasInputStream)resourceMeta);
                        break;
                    }
                    result = this.plugin.updateResource(path, resourceMetaBuilder, (HasInputStream)resourceMeta);
                    break;
                }
                catch (Throwable e) {
                    throw new StorageException("Converter Plugin " + this.providerName + " threw exception during " + op + ": " + e.getMessage(), e, StorageException.Event.valueOf((String)op.toString()), path);
                }
            }
            default: {
                throw new IllegalStateException();
            }
        }
        logger.debug("Plugin(" + this.providerName + "):" + op + ":" + path + ";" + (null == result ? "_" : "+") + ":" + resourceMetaBuilder.getResourceMeta());
        return StorageUtil.withStream((HasInputStream)(null == result ? resourceMeta : result), resourceMetaBuilder.getResourceMeta());
    }

    public ResourceMeta convertReadData(Path path, ResourceMeta resourceMeta) {
        return this.filter(path, resourceMeta, Operation.READ);
    }

    public ResourceMeta convertCreateData(Path path, ResourceMeta resourceMeta) {
        return this.filter(path, resourceMeta, Operation.CREATE);
    }

    public ResourceMeta convertUpdateData(Path path, ResourceMeta resourceMeta) {
        return this.filter(path, resourceMeta, Operation.UPDATE);
    }

    static enum Operation {
        READ,
        UPDATE,
        CREATE;

    }
}

