/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.logging.internal;

import com.dtolabs.rundeck.core.logging.LogEvent;
import com.dtolabs.rundeck.core.logging.LogLevel;
import com.dtolabs.rundeck.core.logging.internal.DefaultLogEvent;
import com.dtolabs.rundeck.core.logging.internal.LineLogFormat;
import com.dtolabs.rundeck.core.logging.internal.OutputLogFormat;
import com.dtolabs.rundeck.core.utils.Utility;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RundeckLogFormat
implements OutputLogFormat,
LineLogFormat {
    private static final Logger log = LoggerFactory.getLogger(RundeckLogFormat.class);
    public static final String FORMAT_MIME = "text/x-rundeck-log-v2.0";
    public static final String DELIM = "^";
    public static final String PIPE = String.valueOf('|');
    public static final String FILE_START = "^text/x-rundeck-log-v2.0^";
    public static final String FILE_END = "^END^";
    public static final String DEFAULT_EVENT_TYPE = "log";
    public static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.NORMAL;
    static final char BACKSLASH = '\\';
    private static final ThreadLocal<DateFormat> w3cDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX", Locale.US);
            fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            return fmt;
        }
    };

    public String getHead() {
        return FILE_START;
    }

    public String getTail() {
        return FILE_END;
    }

    @Override
    public String outputBegin() {
        return this.getHead();
    }

    @Override
    public String outputFinish() {
        return this.getTail();
    }

    static boolean detectFormat(String firstLine) {
        return firstLine != null && firstLine.startsWith(FILE_START);
    }

    @Override
    public String outputEvent(LogEvent entry) {
        String dMesg;
        String date = w3cDateFormat.get().format(entry.getDatetime());
        String string = dMesg = entry.getMessage() != null ? entry.getMessage() : "";
        while (dMesg.endsWith("\\r")) {
            dMesg = dMesg.substring(0, dMesg.length() - 1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(DELIM);
        sb.append(date).append('|');
        String et = entry.getEventType();
        sb.append(et != null && !et.equals(DEFAULT_EVENT_TYPE) ? et.replaceAll("\\|", "") : "").append(PIPE);
        sb.append(entry.getLoglevel().equals((Object)DEFAULT_LOG_LEVEL) ? "" : entry.getLoglevel()).append(PIPE);
        if (entry.getMetadata() != null && !entry.getMetadata().isEmpty()) {
            sb.append('{');
            ArrayList<String> sort = new ArrayList<String>(entry.getMetadata().keySet());
            Collections.sort(sort);
            for (int i = 0; i < sort.size(); ++i) {
                String key = (String)sort.get(i);
                if (null == entry.getMetadata().get(key)) continue;
                if (i > 0) {
                    sb.append('|');
                }
                sb.append(RundeckLogFormat.backslashEscape(key, "=|}"));
                sb.append('=');
                sb.append(RundeckLogFormat.backslashEscape(entry.getMetadata().get(key), "=|}"));
            }
            sb.append('}');
        }
        sb.append("|");
        sb.append(RundeckLogFormat.backslashEscape(dMesg, DELIM));
        sb.append(DELIM);
        return sb.toString();
    }

    static String backslashEscape(String dMesg, String chars) {
        return dMesg != null ? dMesg.replaceAll("([\\\\" + chars + "])", "\\\\$1") : "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public LineLogFormat.FormatItem parseLine(String line) {
        if (FILE_END.equals(line)) {
            return RDFormatItem.asFileEnd();
        }
        if (FILE_START.equals(line)) {
            return RDFormatItem.asFileStart();
        }
        if (line.startsWith(DELIM)) {
            String temp = line.substring(DELIM.length());
            if (StringUtils.isBlank((String)temp)) {
                return new RDFormatItem("", true);
            }
            RDFormatItem item = new RDFormatItem();
            String[] arr = temp.split("\\|", 4);
            if (arr.length != 4) {
                return RDFormatItem.error("Expected 4 sections: " + arr.length);
            }
            Date time = null;
            try {
                time = w3cDateFormat.get().parse(arr[0]);
            }
            catch (ParseException pe) {
                throw new RuntimeException("Unabled to parse date", pe);
            }
            String eventType = StringUtils.isNotBlank((String)arr[1]) ? arr[1] : DEFAULT_EVENT_TYPE;
            LogLevel level = StringUtils.isNotBlank((String)arr[2]) ? LogLevel.valueOf(arr[2]) : DEFAULT_LOG_LEVEL;
            String rest = arr[3];
            HashMap<String, String> meta = new HashMap<String, String>();
            if (rest.startsWith("{")) {
                rest = rest.substring(1);
                boolean done = false;
                while (!done) {
                    UnescapedData decodedKey = RundeckLogFormat.decodeMetaKey(rest);
                    if (!decodedKey.hasReachedDelimiter()) {
                        return RDFormatItem.error("Meta section invalid: " + rest);
                    }
                    rest = decodedKey.remaining;
                    UnescapedData decodedVal = RundeckLogFormat.decodeMetaValue(rest);
                    if (!decodedVal.hasReachedDelimiter()) {
                        return RDFormatItem.error("Meta section invalid: " + rest);
                    }
                    if (decodedVal.delimiterReached.equals("}")) {
                        done = true;
                    }
                    meta.put(decodedKey.unescaped, decodedVal.unescaped);
                    rest = decodedVal.remaining;
                }
                if (!rest.startsWith(PIPE)) return RDFormatItem.error("Expected message section: " + rest);
                rest = rest.substring(1);
            } else {
                arr = rest.split(PIPE, 2);
                if (arr.length != 2) {
                    return RDFormatItem.error("Expected message section: " + rest);
                }
                rest = arr[1];
            }
            UnescapedData decoded = RundeckLogFormat.decodeLog(rest);
            item.lineComplete = decoded.hasReachedDelimiter();
            item.entry = new DefaultLogEvent(level, time, decoded.unescaped + (Serializable)(decoded.hasReachedDelimiter() ? "" : Character.valueOf('\n')), eventType, meta);
            return item;
        }
        UnescapedData decoded = RundeckLogFormat.decodeLog(line);
        return new RDFormatItem(decoded.unescaped + "\n", decoded.hasReachedDelimiter());
    }

    @Override
    public long seekBackwards(File file, int count) {
        String lSep = System.getProperty("line.separator");
        long seek = -1L;
        try {
            int markerLen = (DELIM + lSep).getBytes("UTF-8").length;
            seek = Utility.seekBack(file, count, DELIM + lSep, new LogMessageBegin());
            if (seek > 0L) {
                seek += (long)markerLen;
            }
        }
        catch (IOException iex) {
            log.error("Unable to seek back", (Throwable)iex);
        }
        return seek;
    }

    static UnescapedData decodeMetaKey(String input) {
        return RundeckLogFormat.unescape(input, '\\', "=|}\\", "=");
    }

    static UnescapedData decodeMetaValue(String input) {
        return RundeckLogFormat.unescape(input, '\\', "=|}\\", PIPE, "}");
    }

    static UnescapedData decodeLog(String input) {
        return RundeckLogFormat.unescape(input, '\\', "^\\", DELIM);
    }

    static UnescapedData unescape(String input, char escapeChar, String delimiter) {
        return RundeckLogFormat.unescape(input, escapeChar, delimiter + escapeChar, delimiter);
    }

    static UnescapedData unescape(String input, char escapeChar, String validEscaped, String ... delimiter) {
        int i;
        StringBuilder newline = new StringBuilder();
        boolean done = false;
        String doneDelimiter = null;
        boolean escaped = false;
        int[] delimX = new int[delimiter.length];
        char[][] delimChars = new char[delimiter.length][];
        for (int z = 0; z < delimiter.length; ++z) {
            delimX[z] = 0;
            delimChars[z] = delimiter[z].toCharArray();
        }
        List allowEscaped = validEscaped.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList());
        char[] array = input.toCharArray();
        for (i = 0; i < array.length && !done; ++i) {
            int z;
            int z2;
            char c2 = array[i];
            if (c2 == escapeChar) {
                if (escaped) {
                    newline.append(escapeChar);
                    escaped = false;
                } else {
                    escaped = true;
                }
                for (z2 = 0; z2 < delimiter.length; ++z2) {
                    delimX[z2] = 0;
                }
                continue;
            }
            if (allowEscaped.contains(Character.valueOf(c2))) {
                if (escaped) {
                    newline.append(c2);
                    escaped = false;
                    for (z2 = 0; z2 < delimiter.length; ++z2) {
                        delimX[z2] = 0;
                    }
                    continue;
                }
                boolean delimFound = false;
                for (z = 0; z < delimX.length; ++z) {
                    if (c2 != delimChars[z][delimX[z]]) continue;
                    int n = z;
                    delimX[n] = delimX[n] + 1;
                    delimFound = true;
                    if (delimX[z] != delimChars[z].length) continue;
                    doneDelimiter = delimiter[z];
                    done = true;
                    break;
                }
                if (delimFound) continue;
                newline.append(c2);
                continue;
            }
            if (escaped) {
                newline.append(escapeChar);
                escaped = false;
            }
            boolean partialSeen = false;
            for (z = 0; z < delimiter.length; ++z) {
                if (delimX[z] > 0 && !partialSeen) {
                    newline.append(delimChars[z], 0, delimX[z]);
                    partialSeen = true;
                }
                delimX[z] = 0;
            }
            newline.append(c2);
        }
        if (!done) {
            for (int z = 0; z < delimiter.length; ++z) {
                if (delimX[z] <= 0) continue;
                newline.append(delimChars[z], 0, delimX[z]);
                break;
            }
        }
        String rest = i <= array.length - 1 ? new String(array, i, array.length - i) : null;
        return new UnescapedData(newline.toString(), doneDelimiter, rest);
    }

    static class UnescapedData {
        public final String unescaped;
        public final String delimiterReached;
        public final String remaining;

        public UnescapedData(String unescaped, String delimiterReached, String remaining) {
            this.unescaped = unescaped;
            this.delimiterReached = delimiterReached;
            this.remaining = remaining;
        }

        public boolean hasReachedDelimiter() {
            return this.delimiterReached != null;
        }
    }

    static class LogMessageBegin
    implements Predicate<InputStream> {
        boolean firstTime = true;

        LogMessageBegin() {
        }

        public boolean apply(InputStream stream) {
            if (this.firstTime) {
                this.firstTime = false;
                return false;
            }
            String prefix = "^DDDD-DD-DDTDD:DD:DDZ|";
            String sample = prefix + RundeckLogFormat.DEFAULT_EVENT_TYPE + PIPE;
            byte[] buff = new byte[sample.length()];
            int len = -1;
            try {
                len = stream.read(buff);
            }
            catch (IOException ex) {
                throw new RuntimeException("Stream could not be read", ex);
            }
            if (len != buff.length) {
                return false;
            }
            String s = new String(buff);
            for (int i = 0; i < prefix.length(); ++i) {
                if (prefix.charAt(i) == 'D' || prefix.charAt(i) == s.charAt(i)) continue;
                return false;
            }
            String sub = s.substring(prefix.length());
            return sub.startsWith(PIPE) || sub.startsWith(RundeckLogFormat.DEFAULT_EVENT_TYPE + PIPE);
        }
    }

    public static class RDFormatItem
    implements LineLogFormat.FormatItem {
        boolean fileEnd;
        boolean lineComplete;
        boolean fileStart;
        boolean invalid;
        LogEvent entry;
        String partial;
        String errorMessage;

        RDFormatItem() {
        }

        RDFormatItem(String partial, boolean lineComplete) {
            this.lineComplete = lineComplete;
            this.partial = partial;
        }

        public static LineLogFormat.FormatItem asFileEnd() {
            RDFormatItem i = new RDFormatItem();
            i.fileEnd = true;
            return i;
        }

        public static LineLogFormat.FormatItem asFileStart() {
            RDFormatItem i = new RDFormatItem();
            i.fileStart = true;
            return i;
        }

        public String toString() {
            if (this.invalid) {
                return "Invalid Line: " + this.errorMessage;
            }
            return this.genToString();
        }

        public String genToString() {
            return "RDFormatItem{fileEnd=" + this.fileEnd + ", lineComplete=" + this.lineComplete + ", fileStart=" + this.fileStart + ", entry=" + this.entry + ", partial='" + this.partial + "'}";
        }

        static LineLogFormat.FormatItem error(String message) {
            RDFormatItem item = new RDFormatItem();
            item.invalid = true;
            item.errorMessage = message;
            return item;
        }

        @Override
        public boolean getFileEnd() {
            return this.fileEnd;
        }

        @Override
        public boolean getLineComplete() {
            return this.lineComplete;
        }

        @Override
        public boolean getFileStart() {
            return this.fileStart;
        }

        @Override
        public boolean isInvalid() {
            return this.invalid;
        }

        @Override
        public LogEvent getEntry() {
            return this.entry;
        }

        @Override
        public String getPartial() {
            return this.partial;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

