/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution;

import com.dtolabs.rundeck.core.data.SharedDataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import java.util.List;

public abstract class ExecArg {
    private boolean quoted = true;
    private boolean featureQuotingBackwardCompatible = false;

    public abstract boolean isList();

    public abstract List<ExecArg> getList();

    public abstract String getString();

    public abstract void accept(Visitor var1);

    public boolean isQuoted() {
        return this.quoted;
    }

    void setQuoted(boolean quoted) {
        this.quoted = quoted;
    }

    public boolean isFeatureQuotingBackwardCompatible() {
        return this.featureQuotingBackwardCompatible;
    }

    void setFeatureQuotingBackwardCompatible(boolean featureQuotingBackwardCompatible) {
        this.featureQuotingBackwardCompatible = featureQuotingBackwardCompatible;
    }

    public static ExecArg fromString(String arg, boolean quoted, boolean featureQuotingBackwardCompatible) {
        return new StringArg(arg, quoted, featureQuotingBackwardCompatible);
    }

    static class ListArg
    extends ExecArg {
        private ExecArgList args = null;

        ListArg() {
        }

        @Override
        public boolean isList() {
            return true;
        }

        @Override
        public String getString() {
            return null;
        }

        @Override
        public List<ExecArg> getList() {
            return this.getArgs().getList();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        protected ExecArgList getArgs() {
            return this.args;
        }

        protected void setArgs(ExecArgList list) {
            this.args = list;
        }

        public String toString() {
            return "[" + this.args + "]";
        }
    }

    static class StringArg
    extends ExecArg {
        final String arg;

        public StringArg(String arg, boolean quoted, boolean featureQuotingBackwardCompatible) {
            this.arg = arg;
            this.setFeatureQuotingBackwardCompatible(featureQuotingBackwardCompatible);
            if (SharedDataContextUtils.UNQUOTEDPROPERTY_REF_PATTERN.matcher(arg).matches()) {
                this.setQuoted(false);
            } else {
                this.setQuoted(quoted);
            }
        }

        public String toString() {
            return this.arg;
        }

        @Override
        public String getString() {
            return this.arg;
        }

        @Override
        public boolean isList() {
            return false;
        }

        @Override
        public List<ExecArg> getList() {
            return null;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static interface Visitor {
        public void visit(ExecArg var1);
    }
}

