/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps.node;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ConfiguredStepExecutionItem;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.impl.common.BaseFileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.FileBasedGeneratedScript;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.DefaultScriptFileNodeStepUtils;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.ScriptFileNodeStepUtils;
import com.dtolabs.rundeck.core.plugins.configuration.Configurable;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.utils.Converter;
import com.dtolabs.rundeck.plugins.step.FileExtensionGeneratedScript;
import com.dtolabs.rundeck.plugins.step.GeneratedScript;
import com.dtolabs.rundeck.plugins.step.NodeStepPlugin;
import com.dtolabs.rundeck.plugins.step.PluginStepContext;
import com.dtolabs.rundeck.plugins.step.RemoteScriptNodeStepPlugin;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class RemoteScriptNodeStepPluginAdapter_Ext
implements NodeStepPlugin,
Configurable,
Describable {
    private ScriptFileNodeStepUtils scriptUtils = new DefaultScriptFileNodeStepUtils();
    private RemoteScriptNodeStepPlugin plugin;
    private boolean blankIfUnexpanded;
    public static final NodeStepPluginConverter CONVERT_TO_NODE_STEP_PLUGIN = new NodeStepPluginConverter();

    @Override
    public boolean blankIfUnexpanded() {
        return this.blankIfUnexpanded;
    }

    @Override
    public Description getDescription() {
        if (this.plugin instanceof Describable) {
            Describable desc = (Describable)((Object)this.plugin);
            return desc.getDescription();
        }
        return PluginAdapterUtility.buildDescription(this.plugin, DescriptionBuilder.builder());
    }

    public RemoteScriptNodeStepPluginAdapter_Ext(RemoteScriptNodeStepPlugin plugin, boolean blankIfUnexpanded) {
        this.blankIfUnexpanded = blankIfUnexpanded;
        this.plugin = plugin;
    }

    public ScriptFileNodeStepUtils getScriptUtils() {
        return this.scriptUtils;
    }

    public void setScriptUtils(ScriptFileNodeStepUtils scriptUtils) {
        this.scriptUtils = scriptUtils;
    }

    @Override
    public void configure(Properties configuration) throws ConfigurationException {
        Map<String, Object> config = PluginAdapterUtility.configureProperties(PropertyResolverFactory.createInstanceResolver(configuration), this.getDescription(), this.plugin, PropertyScope.InstanceOnly);
    }

    @Override
    public void executeNodeStep(PluginStepContext pluginContext, Map<String, Object> config, INodeEntry node) throws NodeStepException {
        ExecutionContextImpl newContext;
        NodeStepResult nodeStepResult;
        GeneratedScript script;
        try {
            script = this.plugin.generateScript(pluginContext, config, node);
        }
        catch (RuntimeException e) {
            throw new NodeStepException(e.getMessage(), (FailureReason)StepFailureReason.PluginFailed, node.getNodename());
        }
        HashMap<String, String> stringconfig = new HashMap<String, String>();
        for (Map.Entry<String, Object> objectEntry : config.entrySet()) {
            stringconfig.put(objectEntry.getKey(), objectEntry.getValue().toString());
        }
        ExecutionContextImpl.Builder builder = ExecutionContextImpl.builder(pluginContext.getExecutionContext()).setContext("config", stringconfig);
        if (this.plugin.hasAdditionalConfigVarGroupName()) {
            builder.setContext("nodestep", stringconfig);
        }
        if (!(nodeStepResult = RemoteScriptNodeStepPluginAdapter_Ext.executeRemoteScript(newContext = builder.build(), node, script, pluginContext.getExecutionContext().getDataContextObject().resolve("job", "execid"), this.getDescription().getName(), this.scriptUtils)).isSuccess()) {
            throw new NodeStepException(nodeStepResult.getFailureMessage() != null ? nodeStepResult.getFailureMessage() : "Remote script execution failed", nodeStepResult.getFailureReason(), nodeStepResult.getFailureData(), node.getNodename());
        }
    }

    public static NodeStepResult executeRemoteScript(StepExecutionContext context, INodeEntry node, GeneratedScript script, String ident, String providerName, ScriptFileNodeStepUtils scriptUtils) throws NodeStepException {
        ExecutionService executionService = context.getFramework().getExecutionService();
        boolean expandTokens = true;
        if (context.getFramework().hasProperty("execution.script.tokenexpansion.enabled")) {
            expandTokens = "true".equals(context.getFramework().getProperty("execution.script.tokenexpansion.enabled"));
        }
        if (null != script.getCommand()) {
            boolean featureQuotingBackwardCompatible = Boolean.valueOf(context.getIFramework().getPropertyRetriever().getProperty("rundeck.feature.quoting.backwardCompatible"));
            return executionService.executeCommand((ExecutionContext)context, ExecArgList.fromStrings(featureQuotingBackwardCompatible, DataContextUtils.stringContainsPropertyReferencePredicate, script.getCommand()), node);
        }
        if (null != script.getScript()) {
            String filepath;
            String destpath = BaseFileCopier.generateRemoteFilepathForNode(node, context.getFramework().getFrameworkProjectMgr().getFrameworkProject(context.getFrameworkProject()), context.getFramework(), providerName + "-script", RemoteScriptNodeStepPluginAdapter_Ext.getFileExtension(script), ident);
            try {
                filepath = executionService.fileCopyScriptContent(context, script.getScript(), node, destpath);
            }
            catch (FileCopierException e) {
                throw new NodeStepException(e.getMessage(), (Throwable)e, e.getFailureReason(), node.getNodename());
            }
            return scriptUtils.executeRemoteScript(context, context.getFramework(), node, script.getArgs(), filepath);
        }
        if (script instanceof FileBasedGeneratedScript) {
            FileBasedGeneratedScript fileScript = (FileBasedGeneratedScript)script;
            StepExecutionContext newcontext = fileScript.getConfigData() != null ? ExecutionContextImpl.builder(context).mergeContext("config", fileScript.getConfigData()).build() : context;
            return scriptUtils.executeScriptFile(newcontext, node, null, fileScript.getScriptFile().getAbsolutePath(), null, fileScript.getFileExtension(), fileScript.getArgs(), fileScript.getScriptInterpreter(), fileScript.isInterpreterArgsQuoted(), executionService, expandTokens);
        }
        return new NodeStepResultImpl(null, StepFailureReason.ConfigurationFailure, "Generated script must have a command or script defined", node);
    }

    private static String getFileExtension(GeneratedScript script) {
        if (script instanceof FileExtensionGeneratedScript) {
            return ((FileExtensionGeneratedScript)script).getFileExtension();
        }
        return null;
    }

    private Map<String, Object> getStepConfiguration(StepExecutionItem item) {
        if (item instanceof ConfiguredStepExecutionItem) {
            return ((ConfiguredStepExecutionItem)item).getStepConfiguration();
        }
        return null;
    }

    static class NodeStepPluginConverter
    implements Converter<RemoteScriptNodeStepPlugin, NodeStepPlugin> {
        NodeStepPluginConverter() {
        }

        @Override
        public NodeStepPlugin convert(RemoteScriptNodeStepPlugin plugin) {
            return new RemoteScriptNodeStepPluginAdapter_Ext(plugin, false);
        }
    }
}

