/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.execution.proxy.ProxySecretBundleCreator;
import com.dtolabs.rundeck.core.execution.proxy.SecretBundle;
import com.dtolabs.rundeck.core.plugins.ScriptDataContextUtil;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.Configurable;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.ScriptPluginResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.ScriptResourceUtil;
import com.dtolabs.rundeck.core.storage.StorageTree;
import com.dtolabs.rundeck.core.storage.keys.KeyStorageTree;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.rundeck.app.spi.Services;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScriptPluginResourceModelSource
implements ResourceModelSource,
Configurable,
ProxySecretBundleCreator {
    static Logger logger = LoggerFactory.getLogger((String)ScriptPluginResourceModelSource.class.getName());
    final ScriptPluginProvider provider;
    private final Framework framework;
    Properties configuration;
    private String format;
    private String project;
    private ScriptPluginResourceModelSourceFactory factory;
    private Map<String, Map<String, String>> executionDataContext;
    Map<String, String> configData;

    public ScriptPluginResourceModelSource(ScriptPluginProvider provider, Framework framework, ScriptPluginResourceModelSourceFactory factory) {
        this.provider = provider;
        this.framework = framework;
        this.factory = factory;
        Object o = provider.getMetadata().get("resource-format");
        if (o instanceof String) {
            this.format = (String)o;
        }
    }

    @Override
    public INodeSet getNodes() throws ResourceModelSourceException {
        try {
            return ScriptResourceUtil.executeScript(this.provider.getScriptFile(), this.provider.getScriptArgs(), this.provider.getScriptArgsArray(), this.provider.getScriptInterpreter(), this.provider.getName(), this.executionDataContext, this.format, this.framework, this.project, logger, this.provider.getInterpreterArgsQuoted());
        }
        catch (ResourceModelSourceException e) {
            throw new ResourceModelSourceException("failed to execute: " + this.provider.getScriptFile() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void configure(Properties configuration) throws ConfigurationException {
        this.configuration = configuration;
        if (!configuration.containsKey("project")) {
            throw new ConfigurationException("project is required");
        }
        if (null == this.format) {
            throw new ConfigurationException("resource-format is required");
        }
        this.project = configuration.getProperty("project");
        this.configData = new HashMap<String, String>();
        for (Object o : configuration.keySet()) {
            String k = (String)o;
            this.configData.put(k, configuration.getProperty(k));
        }
        this.executionDataContext = ScriptDataContextUtil.createScriptDataContextObjectForProject(this.framework, this.project);
        this.executionDataContext.get("plugin").putAll(this.factory.createPluginData());
        this.executionDataContext.put("config", this.configData);
    }

    @Override
    public List<String> listSecretsPathResourceModel(Map<String, Object> configuration) {
        Description description = this.factory.getDescription();
        DataContext dataContext = ScriptDataContextUtil.createScriptDataContextObjectForProject(this.framework, this.project);
        return ScriptResourceUtil.generateListStoragePath(description, dataContext, configuration);
    }

    @Override
    public SecretBundle prepareSecretBundleResourceModel(Services services, Map<String, Object> configuration) {
        Description description = this.factory.getDescription();
        DataContext dataContext = ScriptDataContextUtil.createScriptDataContextObjectForProject(this.framework, this.project);
        StorageTree storageTree = services.getService(KeyStorageTree.class);
        try {
            return ScriptResourceUtil.generateBundle(description, dataContext, storageTree, configuration, logger);
        }
        catch (Exception e) {
            throw new RuntimeException("Storage Unauthorized access. The following keys have : " + e.getMessage());
        }
    }

    public String toString() {
        return "script-plugin{name=" + this.provider.getName() + ", plugin file=" + this.provider.getArchiveFile() + ", output format=" + this.format + "}";
    }
}

