/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.ListenableMutableStateObj;
import com.dtolabs.rundeck.core.rules.StateChangeListener;
import com.dtolabs.rundeck.core.rules.StateObj;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataState
implements ListenableMutableStateObj {
    Map<String, String> state;
    List<StateChangeListener> listeners = new ArrayList<StateChangeListener>();

    DataState() {
        this(new HashMap<String, String>());
    }

    DataState(StateObj context) {
        this.state = new HashMap<String, String>(context.getState());
    }

    DataState(Map<String, String> context) {
        this.state = new HashMap<String, String>(context);
    }

    DataState(String key, String val) {
        this.state = new HashMap<String, String>();
        this.state.put(key, val);
    }

    @Override
    public boolean updateState(StateObj values) {
        if (this.updateStateInt(values)) {
            this.stateChanged();
            return true;
        }
        return false;
    }

    private boolean updateStateInt(StateObj values) {
        return this.updateStateInt(values.getState());
    }

    @Override
    public boolean updateState(Map<String, String> values) {
        if (this.updateStateInt(values)) {
            this.stateChanged();
            return true;
        }
        return false;
    }

    private boolean updateStateInt(Map<String, String> values) {
        boolean changed = false;
        if (null == values || values.size() < 1) {
            return false;
        }
        for (String s : values.keySet()) {
            boolean val = this.updateStateInt(s, values.get(s));
            changed = val || changed;
        }
        return changed;
    }

    @Override
    public boolean updateState(String key, String value) {
        if (this.updateStateInt(key, value)) {
            this.stateChanged();
            return true;
        }
        return false;
    }

    private boolean updateStateInt(String key, String value) {
        if (null != value) {
            return !value.equals(this.state.put(key, value));
        }
        return this.state.remove(key) != null;
    }

    @Override
    public Map<String, String> getState() {
        return this.state;
    }

    @Override
    public boolean hasState(String key, String value) {
        return value != null ? value.equals(this.state.get(key)) : this.state.get(key) == null;
    }

    @Override
    public boolean hasState(final StateObj state) {
        return FluentIterable.from(state.getState().keySet()).allMatch((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return DataState.this.hasState(input, state.getState().get(input));
            }
        });
    }

    @Override
    public void addListener(StateChangeListener listener) {
        this.listeners.add(listener);
    }

    private void stateChanged() {
        for (StateChangeListener listener : this.listeners) {
            listener.stateChanged(this);
        }
    }

    public String toString() {
        return "DataState{state=" + this.state + "}";
    }
}

