/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.common.IServicesRegistration;
import com.dtolabs.rundeck.core.execution.impl.local.LocalNodeExecutor;
import com.dtolabs.rundeck.core.execution.impl.local.NewLocalNodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeSpecifiedService;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.execution.service.ScriptPluginNodeExecutor;
import com.dtolabs.rundeck.core.plugins.JavaClassProviderLoadable;
import com.dtolabs.rundeck.core.plugins.PluggableProviderService;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProviderLoadable;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableService;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableServiceUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeExecutorService
extends NodeSpecifiedService<NodeExecutor>
implements DescribableService,
PluggableProviderService<NodeExecutor>,
JavaClassProviderLoadable<NodeExecutor>,
ScriptPluginProviderLoadable<NodeExecutor> {
    private static final String SERVICE_NAME = "NodeExecutor";
    public static final String SERVICE_DEFAULT_PROVIDER_PROPERTY = "service.NodeExecutor.default.provider";
    private static final String SERVICE_DEFAULT_LOCAL_PROVIDER_PROPERTY = "service.NodeExecutor.default.local.provider";
    public static final String NODE_SERVICE_SPECIFIER_ATTRIBUTE = "node-executor";
    public static final String LOCAL_NODE_SERVICE_SPECIFIER_ATTRIBUTE = "local-node-executor";
    public static final String DEFAULT_LOCAL_PROVIDER = "local";
    public static final String DEFAULT_REMOTE_PROVIDER = "sshj-ssh";
    private static final Map<String, Class<? extends NodeExecutor>> PRESET_PROVIDERS;

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    public List<String> getBundledProviderNames() {
        return Collections.unmodifiableList(new ArrayList(this.registry.keySet()));
    }

    public NodeExecutorService(Framework framework) {
        super(framework, true);
        this.registry.putAll(PRESET_PROVIDERS);
    }

    public static boolean isRegistered(String name) {
        return PRESET_PROVIDERS.containsKey(name);
    }

    @Override
    public String getDefaultProviderNameForNodeAndProject(INodeEntry node, String project) {
        return NodeExecutorService.getProviderNameForNode(this.framework.isLocalNode(node), this.framework.getProjectManager().loadProjectConfig(project));
    }

    public static NodeExecutorService getInstanceForFramework(Framework framework, IServicesRegistration registration) {
        if (null == registration.getService(SERVICE_NAME)) {
            NodeExecutorService service = new NodeExecutorService(framework);
            registration.setService(SERVICE_NAME, service);
            return service;
        }
        return (NodeExecutorService)registration.getService(SERVICE_NAME);
    }

    @Override
    public String getServiceProviderNodeAttributeForNode(INodeEntry node) {
        return NodeExecutorService.getNodeAttributeForProvider(this.framework.isLocalNode(node));
    }

    public static String getProviderNameForNode(boolean localNode, IRundeckProjectConfig loadProjectConfig) {
        if (localNode) {
            String value = loadProjectConfig.getProperty(SERVICE_DEFAULT_LOCAL_PROVIDER_PROPERTY);
            return null != value ? value : DEFAULT_LOCAL_PROVIDER;
        }
        String value = loadProjectConfig.getProperty(SERVICE_DEFAULT_PROVIDER_PROPERTY);
        return null != value ? value : DEFAULT_REMOTE_PROVIDER;
    }

    public static String getNodeAttributeForProvider(boolean localNode) {
        if (localNode) {
            return LOCAL_NODE_SERVICE_SPECIFIER_ATTRIBUTE;
        }
        return NODE_SERVICE_SPECIFIER_ATTRIBUTE;
    }

    @Override
    public boolean isValidProviderClass(Class clazz) {
        return NodeExecutor.class.isAssignableFrom(clazz) && this.hasValidProviderSignature(clazz);
    }

    @Override
    public <X extends NodeExecutor> NodeExecutor createProviderInstance(Class<X> clazz, String name) throws PluginException, ProviderCreationException {
        return (NodeExecutor)this.createProviderInstanceFromType(clazz, name);
    }

    @Override
    public NodeExecutor createScriptProviderInstance(ScriptPluginProvider provider) throws PluginException {
        ScriptPluginNodeExecutor.validateScriptPlugin(provider);
        return new ScriptPluginNodeExecutor(provider, this.framework);
    }

    @Override
    public List<Description> listDescriptions() {
        return DescribableServiceUtil.listDescriptions(this, false);
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return DescribableServiceUtil.listDescribableProviders(this);
    }

    static {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put(DEFAULT_LOCAL_PROVIDER, LocalNodeExecutor.class);
        map.put("newlocal", NewLocalNodeExecutor.class);
        PRESET_PROVIDERS = Collections.unmodifiableMap(map);
    }
}

