/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.storage.service;

import com.dtolabs.rundeck.core.common.ProviderService;
import com.dtolabs.rundeck.core.execution.service.ProviderLoaderException;
import com.dtolabs.rundeck.core.plugins.ChainedProviderService;
import com.dtolabs.rundeck.core.plugins.CloseableProvider;
import com.dtolabs.rundeck.core.plugins.PluggableProviderService;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.ProviderRegistryService;
import com.dtolabs.rundeck.core.plugins.ServiceFactory;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableService;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableServiceUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.storage.service.PluggableStoragePluginProviderService;
import com.dtolabs.rundeck.plugins.storage.StoragePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StoragePluginProviderService
extends ChainedProviderService<StoragePlugin>
implements DescribableService,
PluggableProviderService<StoragePlugin> {
    public static final String SERVICE_NAME = "Storage";
    private final List<ProviderService<StoragePlugin>> serviceList;
    private PluggableStoragePluginProviderService pluggableStoragePluginProviderService;
    private Map<String, Class<? extends StoragePlugin>> builtinProviders = new HashMap<String, Class<? extends StoragePlugin>>();

    public StoragePluginProviderService() {
        this.serviceList = new ArrayList<ProviderService<StoragePlugin>>();
    }

    public StoragePluginProviderService(Map<String, Class<? extends StoragePlugin>> builtinProviders) {
        this.serviceList = new ArrayList<ProviderService<StoragePlugin>>();
        this.builtinProviders = builtinProviders;
        ProviderRegistryService builtinResourceStoragePluginProviderService = ServiceFactory.builtinService(SERVICE_NAME, builtinProviders);
        this.serviceList.add(builtinResourceStoragePluginProviderService);
    }

    @Override
    public boolean canLoadWithLoader(ProviderLoader loader) {
        return this.pluggableStoragePluginProviderService.canLoadWithLoader(loader);
    }

    @Override
    public StoragePlugin loadWithLoader(String providerName, ProviderLoader loader) throws ProviderLoaderException {
        return (StoragePlugin)this.pluggableStoragePluginProviderService.loadWithLoader(providerName, loader);
    }

    @Override
    public CloseableProvider<StoragePlugin> loadCloseableWithLoader(String providerName, ProviderLoader loader) throws ProviderLoaderException {
        return this.pluggableStoragePluginProviderService.loadCloseableWithLoader(providerName, loader);
    }

    public List<String> getBundledProviderNames() {
        return new ArrayList<String>(this.builtinProviders.keySet());
    }

    @Override
    protected List<ProviderService<StoragePlugin>> getServiceList() {
        return this.serviceList;
    }

    @Override
    public List<Description> listDescriptions() {
        return DescribableServiceUtil.listDescriptions(this);
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return DescribableServiceUtil.listDescribableProviders(this);
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    public PluggableStoragePluginProviderService getPluggableStoragePluginProviderService() {
        return this.pluggableStoragePluginProviderService;
    }

    public void setPluggableStoragePluginProviderService(PluggableStoragePluginProviderService pluggableStoragePluginProviderService) {
        this.pluggableStoragePluginProviderService = pluggableStoragePluginProviderService;
        this.serviceList.add(this.pluggableStoragePluginProviderService);
    }
}

