/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.net.api;

import com.dtolabs.rundeck.net.api.RundeckApi;
import com.dtolabs.rundeck.net.model.ProjectImportStatus;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import retrofit2.converter.jaxb.JaxbConverterFactory;

public class RundeckClient {
    public static final String APPLICATION_ZIP = "application/zip";
    public static final MediaType MEDIA_TYPE_ZIP = MediaType.parse((String)"application/zip");
    private final RundeckApi rundeckApi;
    private final Retrofit retrofit;

    public RundeckClient(String url, String apiToken) {
        OkHttpClient.Builder okhttp = new OkHttpClient.Builder();
        okhttp.addInterceptor(chain -> chain.proceed(chain.request().newBuilder().header("X-Rundeck-Auth-Token", apiToken).build()));
        String apiBaseUrl = RundeckClient.buildApiUrlForVersion(url, 39);
        this.retrofit = new Retrofit.Builder().baseUrl(apiBaseUrl).client(okhttp.build()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).addConverterFactory((Converter.Factory)JaxbConverterFactory.create()).build();
        this.rundeckApi = (RundeckApi)this.retrofit.create(RundeckApi.class);
    }

    public RundeckClient(RundeckApi rundeckApi, Retrofit retrofit) {
        this.rundeckApi = rundeckApi;
        this.retrofit = retrofit;
    }

    public Response<ProjectImportStatus> importProjectArchive(String projectName, String jobUuidOption, Boolean importExecutions, Boolean importConfig, Boolean importACL, Boolean importScm, Boolean importWebhooks, Boolean whkRegenAuthTokens, Boolean whkRegenUuid, Boolean importNodesSources, Map<String, String> params, RequestBody requestBody) throws IOException {
        return this.rundeckApi.importProjectArchive(projectName, jobUuidOption, importExecutions, importConfig, importACL, importScm, importWebhooks, whkRegenAuthTokens, whkRegenUuid, importNodesSources, params, requestBody).execute();
    }

    private static String buildApiUrlForVersion(String baseUrl, int apiVers) {
        if (!baseUrl.matches("^.*/api/\\d+/?$")) {
            return RundeckClient.normalizeUrlPath(baseUrl) + "api/" + apiVers + "/";
        }
        return RundeckClient.normalizeUrlPath(baseUrl);
    }

    private static String normalizeUrlPath(String baseUrl) {
        if (!baseUrl.matches(".*/$")) {
            return baseUrl + "/";
        }
        return baseUrl;
    }

    public Retrofit getRetrofit() {
        return this.retrofit;
    }
}

