/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.tools.ant.types.FilterSet;

public class Streams {
    public static long copyStream(InputStream in, OutputStream out) throws IOException {
        return Streams.copyStreamCount(in, out);
    }

    public static int copyStreamCount(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[10240];
        int tot = 0;
        int c = in.read(buffer);
        while (c >= 0) {
            if (c > 0) {
                out.write(buffer, 0, c);
                tot += c;
            }
            c = in.read(buffer);
        }
        return tot;
    }

    public static int copyWriterCount(Reader in, Writer out) throws IOException {
        char[] buffer = new char[10240];
        int tot = 0;
        int c = in.read(buffer);
        while (c >= 0) {
            if (c > 0) {
                out.write(buffer, 0, c);
                tot += c;
            }
            c = in.read(buffer);
        }
        return tot;
    }

    public static StreamCopyThread copyStreamThread(InputStream in, OutputStream out) {
        return new StreamCopyThread(in, out);
    }

    public static void copyStreamWithFilterSet(InputStream in, OutputStream out, FilterSet set) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        String lSep = System.getProperty("line.separator");
        String line = reader.readLine();
        while (null != line) {
            writer.write(set.replaceTokens(line));
            writer.write(lSep);
            line = reader.readLine();
        }
        writer.flush();
    }

    public static class StreamCopyThread
    extends Thread {
        final InputStream in;
        final OutputStream out;
        private IOException exception;

        public StreamCopyThread(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                Streams.copyStream(this.in, this.out);
                this.out.flush();
            }
            catch (IOException e) {
                this.exception = e;
            }
        }

        public IOException getException() {
            return this.exception;
        }
    }
}

