/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps.node.impl;

import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.NodeExecutionService;
import com.dtolabs.rundeck.core.execution.impl.common.DefaultFileCopierUtil;
import com.dtolabs.rundeck.core.execution.impl.common.FileCopierUtil;
import com.dtolabs.rundeck.core.execution.script.ScriptfileUtils;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.ScriptFileNodeStepUtils;
import com.dtolabs.rundeck.core.utils.ScriptExecUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScriptFileNodeStepUtils
implements ScriptFileNodeStepUtils {
    public static final Logger logger = LoggerFactory.getLogger((String)DefaultScriptFileNodeStepUtils.class.getName());
    public static final String SCRIPT_FILE_REMOVE_TMP = "script-step-remove-tmp-file";
    public static final String MESSAGE_ERROR_FILE_BUSY_PATTERN = "Cannot run program.+: error=26.*";
    public static final String NODE_ATTR_FILE_BUSY_ERR_RETRY = "file-busy-err-retry";
    public static final String NODE_ATTR_ENABLE_SYNC_COMMAND = "enable-sync";
    private static final int MAX_TIME_TO_WAIT_BEFORE_TRY_AGAIN = 3000;
    private FileCopierUtil fileCopierUtil = new DefaultFileCopierUtil();

    @Override
    public NodeStepResult executeScriptFile(StepExecutionContext context, INodeEntry node, String scriptString, String serverScriptFilePath, InputStream scriptAsStream, String fileExtension, String[] args, String scriptInterpreter, boolean quoted, NodeExecutionService executionService, boolean expandTokens) throws NodeStepException {
        return this.executeScriptFile(context, node, scriptString, serverScriptFilePath, scriptAsStream, fileExtension, args, scriptInterpreter, null, quoted, executionService, expandTokens, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeStepResult executeScriptFile(StepExecutionContext context, INodeEntry node, String scriptString, String serverScriptFilePath, InputStream scriptAsStream, String fileExtension, String[] args, String scriptInterpreter, InputStream input, boolean quoted, NodeExecutionService executionService, boolean expandTokens, FileCopierUtil.ContentModifier modifier) throws NodeStepException {
        String filename = null != scriptString ? "dispatch-script.tmp" : (null != serverScriptFilePath ? new File(serverScriptFilePath).getName() : "dispatch-script.tmp");
        String ident = null != context.getDataContext() && null != context.getDataContext().get("job") ? context.getDataContext().get("job").get("execid") : null;
        String filepath = this.fileCopierUtil.generateRemoteFilepathForNode(node, context.getIFramework().getFrameworkProjectMgr().getFrameworkProject(context.getFrameworkProject()), context.getIFramework(), filename, fileExtension, ident);
        try {
            File temp = this.writeScriptToTempFile(context, node, scriptString, serverScriptFilePath, scriptAsStream, expandTokens, modifier);
            try {
                filepath = executionService.fileCopyFile(context, temp, node, filepath);
            }
            finally {
                ScriptfileUtils.releaseTempFile(temp);
            }
        }
        catch (FileCopierException e) {
            throw new NodeStepException(e.getMessage(), (Throwable)e, e.getFailureReason(), node.getNodename());
        }
        catch (ExecutionException e) {
            throw new NodeStepException(e.getMessage(), (Throwable)e, e.getFailureReason(), node.getNodename());
        }
        return this.executeRemoteScript((ExecutionContext)context, context.getIFramework(), node, args, filepath, scriptInterpreter, quoted, input);
    }

    @Override
    public File writeScriptToTempFile(StepExecutionContext context, INodeEntry node, String scriptString, String serverScriptFilePath, InputStream scriptAsStream, boolean expandTokens) throws FileCopierException {
        return this.writeScriptToTempFile(context, node, scriptString, serverScriptFilePath, scriptAsStream, expandTokens, null);
    }

    @Override
    public File writeScriptToTempFile(StepExecutionContext context, INodeEntry node, String scriptString, String serverScriptFilePath, InputStream scriptAsStream, boolean expandTokens, FileCopierUtil.ContentModifier scriptModifierUtil) throws FileCopierException {
        File temp;
        if (null != scriptString) {
            temp = this.fileCopierUtil.writeScriptTempFile(context, null, null, scriptString, node, expandTokens, scriptModifierUtil);
        } else if (null != serverScriptFilePath) {
            File serverScriptFile;
            if (DataContextUtils.hasOptionsInString(serverScriptFilePath)) {
                HashMap<String, Map<String, String>> optionsContext = new HashMap<String, Map<String, String>>();
                optionsContext.put("option", context.getDataContext().get("option"));
                String expandedVarsInURL = DataContextUtils.replaceDataReferencesInString(serverScriptFilePath, optionsContext);
                serverScriptFile = new File(expandedVarsInURL);
            } else {
                serverScriptFile = new File(serverScriptFilePath);
            }
            if (expandTokens || scriptModifierUtil != null) {
                try (FileInputStream inputStream = new FileInputStream(serverScriptFile);){
                    serverScriptFile = this.fileCopierUtil.writeScriptTempFile(context, null, inputStream, null, node, expandTokens, scriptModifierUtil);
                }
                catch (IOException e) {
                    throw new FileCopierException("error writing script to tempfile: " + e.getMessage(), StepFailureReason.IOFailure, e);
                }
            }
            temp = serverScriptFile;
        } else {
            temp = this.fileCopierUtil.writeScriptTempFile(context, null, scriptAsStream, null, node, expandTokens, scriptModifierUtil);
        }
        return temp;
    }

    @Override
    public NodeStepResult executeRemoteScript(ExecutionContext context, IFramework framework, INodeEntry node, String[] args, String filepath) throws NodeStepException {
        return this.executeRemoteScript(context, framework, node, args, filepath, null, false);
    }

    @Override
    public NodeStepResult executeRemoteScript(ExecutionContext context, IFramework framework, INodeEntry node, String[] args, String filepath, String scriptInterpreter, boolean interpreterargsquoted) throws NodeStepException {
        return this.executeRemoteScript(context, framework, node, args, filepath, scriptInterpreter, interpreterargsquoted, null);
    }

    @Override
    public NodeStepResult executeRemoteScript(ExecutionContext context, IFramework framework, INodeEntry node, String[] args, String filepath, String scriptInterpreter, boolean interpreterargsquoted, InputStream inputStream) throws NodeStepException {
        boolean removeFile = true;
        if (null != node.getAttributes() && null != node.getAttributes().get(SCRIPT_FILE_REMOVE_TMP)) {
            removeFile = Boolean.parseBoolean(node.getAttributes().get(SCRIPT_FILE_REMOVE_TMP));
        }
        return this.executeRemoteScript(context, framework, node, args, filepath, scriptInterpreter, interpreterargsquoted, removeFile, inputStream);
    }

    @Override
    public NodeStepResult executeRemoteScript(ExecutionContext context, IFramework framework, INodeEntry node, String[] args, String filepath, String scriptInterpreter, boolean interpreterargsquoted, boolean removeFile) throws NodeStepException {
        return this.executeRemoteScript(context, framework, node, args, filepath, scriptInterpreter, interpreterargsquoted, removeFile, null);
    }

    @Override
    public NodeStepResult executeRemoteScript(ExecutionContext context, IFramework framework, INodeEntry node, String[] args, String filepath, String scriptInterpreter, boolean interpreterargsquoted, boolean removeFile, InputStream input) {
        NodeExecutorResult nodeExecutorResult2;
        NodeExecutorResult nodeExecutorResult;
        boolean retryExecuteCommand = false;
        if (!"windows".equalsIgnoreCase(node.getOsFamily())) {
            NodeExecutorResult nodeExecutorSyncResult;
            boolean featureQuotingBackwardCompatible = Boolean.valueOf(context.getIFramework().getPropertyRetriever().getProperty("rundeck.feature.quoting.backwardCompatible"));
            nodeExecutorResult = framework.getExecutionService().executeCommand(context, ExecArgList.fromStrings(featureQuotingBackwardCompatible, false, "chmod", "+x", filepath), node);
            if (!nodeExecutorResult.isSuccess()) {
                return nodeExecutorResult;
            }
            Map<String, String> nodeAttribute = node.getAttributes();
            if (BooleanUtils.toBoolean((String)nodeAttribute.get(NODE_ATTR_ENABLE_SYNC_COMMAND)) && !(nodeExecutorSyncResult = framework.getExecutionService().executeCommand(context, ExecArgList.fromStrings(featureQuotingBackwardCompatible, false, "sync"), node)).isSuccess()) {
                return nodeExecutorSyncResult;
            }
            retryExecuteCommand = BooleanUtils.toBoolean((String)nodeAttribute.get(NODE_ATTR_FILE_BUSY_ERR_RETRY));
        }
        ExecArgList scriptArgList = ScriptExecUtil.createScriptArgList(filepath, null, args, scriptInterpreter, interpreterargsquoted);
        nodeExecutorResult = this.executeCommand(framework, context, scriptArgList, node, input, retryExecuteCommand, 500);
        if (removeFile && !(nodeExecutorResult2 = framework.getExecutionService().executeCommand(context, this.removeArgsForOsFamily(filepath, node.getOsFamily()), node)).isSuccess() && null != context.getExecutionListener()) {
            context.getExecutionListener().log(1, "Failed to remove remote file: " + filepath);
        }
        return nodeExecutorResult;
    }

    private NodeExecutorResult executeCommand(IFramework framework, ExecutionContext context, ExecArgList scriptArgList, INodeEntry node, InputStream inputStream, boolean retryAttempt, int timeToWait) {
        NodeExecutorResult nodeExecutorResult = framework.getExecutionService().executeCommand(context, scriptArgList, inputStream, node);
        boolean isFileBusy = this.checkIfFileBusy(nodeExecutorResult);
        if (retryAttempt && isFileBusy) {
            context.getExecutionLogger().log(5, "File is busy. Retrying...");
            return this.attemptExecuteCommand(framework, context, scriptArgList, node, inputStream, timeToWait);
        }
        if (isFileBusy) {
            return NodeExecutorResultImpl.createFailure(nodeExecutorResult.getFailureReason(), nodeExecutorResult.getFailureMessage() + " Set node attribute 'file-busy-err-retry=true' to enable retrying", node);
        }
        return nodeExecutorResult;
    }

    private NodeExecutorResult attemptExecuteCommand(IFramework framework, ExecutionContext context, ExecArgList scriptArgList, INodeEntry node, InputStream inputStream, int timeToWait) {
        boolean retryAttempt = (timeToWait += 500) < 3000;
        context.getExecutionLogger().log(5, "Waiting " + timeToWait / 1000 + " seconds before try again");
        try {
            Thread.sleep(timeToWait);
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException: " + e);
        }
        return this.executeCommand(framework, context, scriptArgList, node, inputStream, retryAttempt, timeToWait);
    }

    private boolean checkIfFileBusy(NodeExecutorResult nodeExecutorResult) {
        String failureMessage = nodeExecutorResult.getFailureMessage();
        return null != failureMessage && failureMessage.matches(MESSAGE_ERROR_FILE_BUSY_PATTERN);
    }

    @Override
    public ExecArgList removeArgsForOsFamily(String filepath, String osFamily) {
        if ("windows".equalsIgnoreCase(osFamily)) {
            return ExecArgList.fromStrings(false, false, "del", filepath);
        }
        return ExecArgList.fromStrings(false, false, "rm", "-f", filepath);
    }

    public FileCopierUtil getFileCopierUtil() {
        return this.fileCopierUtil;
    }

    public void setFileCopierUtil(FileCopierUtil fileCopierUtil) {
        this.fileCopierUtil = fileCopierUtil;
    }
}

