/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.storage;

import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.storage.StorageManager;
import com.dtolabs.rundeck.core.storage.StorageManagerListener;
import com.dtolabs.rundeck.core.storage.StorageTree;
import com.dtolabs.rundeck.core.storage.StorageUtil;
import com.dtolabs.utils.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.rundeck.storage.api.PathUtil;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.data.DataUtil;

public class TreeStorageManager
implements StorageManager {
    private final StorageTree storage;
    private final List<StorageManagerListener> listeners = Collections.synchronizedList(new ArrayList());

    @Override
    public void addListener(StorageManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(StorageManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean existsFileResource(String path) {
        String storagePath = this.cleanPath(path);
        return this.getStorage().hasResource(storagePath);
    }

    private String cleanPath(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }

    @Override
    public boolean existsDirResource(String path) {
        String storagePath = this.cleanPath(path);
        return this.getStorage().hasDirectory(storagePath);
    }

    @Override
    public List<String> listDirPaths(String path) {
        return this.listDirPaths(path, null);
    }

    @Override
    public List<String> listDirPaths(String path, String pattern) {
        String storagePath = this.cleanPath(path);
        Collection resources = this.getStorage().hasDirectory(storagePath) ? this.getStorage().listDirectory(storagePath) : new ArrayList();
        Object outprefix = path.endsWith("/") ? path : path + "/";
        Pattern pat = pattern != null ? Pattern.compile(pattern) : null;
        return resources.stream().map(res -> res.getPath().getName() + (res.isDirectory() ? "/" : "")).filter(pathName -> pat == null || pat.matcher((CharSequence)pathName).matches()).map(arg_0 -> TreeStorageManager.lambda$listDirPaths$2((String)outprefix, arg_0)).collect(Collectors.toList());
    }

    @Override
    public Resource<ResourceMeta> getFileResource(String path) {
        String storagePath = this.cleanPath(path);
        if (!this.getStorage().hasResource(storagePath)) {
            return null;
        }
        return this.getStorage().getResource(storagePath);
    }

    @Override
    public long loadFileResource(String path, OutputStream output) throws IOException {
        String storagePath = this.cleanPath(path);
        Resource resource = this.getStorage().getResource(storagePath);
        return Streams.copyStream(((ResourceMeta)resource.getContents()).getInputStream(), output);
    }

    @Override
    public Resource<ResourceMeta> updateFileResource(String path, InputStream input, Map<String, String> meta) {
        String storagePath = this.cleanPath(path);
        Resource res = this.getStorage().updateResource(storagePath, (ResourceMeta)DataUtil.withStream((InputStream)input, meta, StorageUtil.factory()));
        this.listeners.forEach(a -> a.resourceModified(path));
        return res;
    }

    @Override
    public Resource<ResourceMeta> createFileResource(String path, InputStream input, Map<String, String> meta) {
        String storagePath = this.cleanPath(path);
        Resource res = this.getStorage().createResource(storagePath, (ResourceMeta)DataUtil.withStream((InputStream)input, meta, StorageUtil.factory()));
        this.listeners.forEach(a -> a.resourceCreated(path));
        return res;
    }

    @Override
    public Resource<ResourceMeta> writeFileResource(String path, InputStream input, Map<String, String> meta) {
        String storagePath = this.cleanPath(path);
        if (!this.getStorage().hasResource(storagePath)) {
            return this.createFileResource(path, input, meta);
        }
        return this.updateFileResource(path, input, meta);
    }

    @Override
    public boolean deleteFileResource(String path) {
        String storagePath = this.cleanPath(path);
        if (!this.getStorage().hasResource(storagePath)) {
            return true;
        }
        boolean result = this.getStorage().deleteResource(storagePath);
        if (result) {
            this.listeners.forEach(a -> a.resourceDeleted(path));
        }
        return result;
    }

    @Override
    public boolean deleteAllFileResources(String root) {
        return StorageUtil.deletePathRecursive(this.getStorage(), PathUtil.asPath((String)root));
    }

    public static TreeStorageManager createFromStorageTree(StorageTree storageTree) {
        return TreeStorageManager.builder().storage(storageTree).build();
    }

    TreeStorageManager(StorageTree storage) {
        this.storage = storage;
    }

    public static TreeStorageManagerBuilder builder() {
        return new TreeStorageManagerBuilder();
    }

    public StorageTree getStorage() {
        return this.storage;
    }

    private static /* synthetic */ String lambda$listDirPaths$2(String outprefix, String pathName) {
        return outprefix + pathName;
    }

    public static class TreeStorageManagerBuilder {
        private StorageTree storage;

        TreeStorageManagerBuilder() {
        }

        public TreeStorageManagerBuilder storage(StorageTree storage) {
            this.storage = storage;
            return this;
        }

        public TreeStorageManager build() {
            return new TreeStorageManager(this.storage);
        }

        public String toString() {
            return "TreeStorageManager.TreeStorageManagerBuilder(storage=" + this.storage + ")";
        }
    }
}

