/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.common.SelectorUtils;
import com.dtolabs.rundeck.core.utils.OptsUtil;
import com.dtolabs.rundeck.core.utils.StringArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;

public class NodeSet
implements NodesSelector {
    public static final String HOSTNAME = "hostname";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String TAGS = "tags";
    public static final String OS_NAME = "os-name";
    public static final String OS_FAMILY = "os-family";
    public static final String OS_ARCH = "os-arch";
    public static final String OS_VERSION = "os-version";
    private String singleNodeName;
    public static final String DEFAULT_FILTER_KEY = "name";
    private static final String[] FILTER_KEYS = new String[]{"hostname", "name", "type", "tags", "os-name", "os-family", "os-arch", "os-version"};
    public static final List<String> FILTER_KEYS_LIST = Collections.unmodifiableList(Arrays.asList(FILTER_KEYS));
    public static final Collection<String> FILTER_KEYSET = new HashSet<String>(FILTER_KEYS_LIST);
    private Include includes;
    private Exclude excludes;
    private int threadCount = 1;
    private boolean keepgoing = false;
    private File failedNodesfile;

    public NodeSet() {
    }

    public NodeSet(String singleNodeName) {
        this.singleNodeName = singleNodeName;
    }

    public NodeSet(INodeEntry singleNode) {
        this(singleNode.getNodename());
    }

    public String getSingleNodeName() {
        return this.singleNodeName;
    }

    public void setSingleNodeName(String singleNodeName) {
        this.singleNodeName = singleNodeName;
    }

    @Override
    public boolean acceptNode(INodeEntry entry) {
        return !this.shouldExclude(entry);
    }

    public NodesSelector nodeSelectorWithDefault(String nodename) {
        final NodesSelector nodesSelector = SelectorUtils.singleNode(nodename);
        return new NodesSelector(){

            @Override
            public boolean acceptNode(INodeEntry entry) {
                return !NodeSet.this.isBlank() ? NodeSet.this.acceptNode(entry) : nodesSelector.acceptNode(entry);
            }
        };
    }

    public NodesSelector nodeSelectorWithDefaultAll() {
        return new NodesSelector(){

            @Override
            public boolean acceptNode(INodeEntry entry) {
                return NodeSet.this.isBlank() || NodeSet.this.acceptNode(entry);
            }
        };
    }

    public boolean isBlank() {
        return !(null != this.getInclude() && !this.getInclude().isBlank() || null != this.getExclude() && !this.getExclude().isBlank() || null != this.getSingleNodeName());
    }

    public Include createInclude() {
        if (null != this.includes) {
            throw new IllegalStateException("only one include is allowed");
        }
        this.includes = new Include();
        return this.includes;
    }

    public Exclude createExclude() {
        if (null != this.excludes) {
            throw new IllegalStateException("only one exclude is allowed");
        }
        this.excludes = new Exclude();
        return this.excludes;
    }

    public Include getInclude() {
        return this.includes;
    }

    public Exclude getExclude() {
        return this.excludes;
    }

    public boolean shouldExclude(INodeEntry entry) {
        boolean excludesMatch;
        if (null != this.getSingleNodeName()) {
            return !this.getSingleNodeName().equals(entry.getNodename());
        }
        boolean includesMatch = this.includes != null && this.includes.matches(entry);
        boolean bl = excludesMatch = this.excludes != null && this.excludes.matches(entry);
        if (null == this.excludes || this.excludes.isBlank()) {
            return !includesMatch;
        }
        if (null == this.includes || this.includes.isBlank()) {
            return excludesMatch;
        }
        if (null != this.includes && this.includes.isDominant()) {
            return !includesMatch && excludesMatch;
        }
        return !includesMatch || excludesMatch;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean isKeepgoing() {
        return this.keepgoing;
    }

    public void setKeepgoing(boolean keepgoing) {
        this.keepgoing = keepgoing;
    }

    public void validate() {
        if (null != this.failedNodesfile && this.failedNodesfile.getName().startsWith("${") && this.failedNodesfile.getName().endsWith("}")) {
            this.failedNodesfile = null;
        }
    }

    protected static boolean matchesInput(String inputSelector, String propValue) {
        if (null == propValue || "".equals(propValue.trim())) {
            return false;
        }
        if (null == inputSelector || "".equals(inputSelector.trim())) {
            return false;
        }
        List<String> list = Arrays.asList(inputSelector.split(","));
        return NodeSet.matchRegexOrEquals(inputSelector, propValue) || list.contains(propValue);
    }

    protected static boolean matchesInput(Map<String, String> attrSelectors, Map<String, String> values, boolean matchAll) {
        if (null == attrSelectors || null == values) {
            return false;
        }
        for (Map.Entry<String, String> entry : attrSelectors.entrySet()) {
            boolean match = NodeSet.matchesInput(entry.getValue(), values.get(entry.getKey()));
            if (!match && matchAll) {
                return false;
            }
            if (!match || matchAll) continue;
            return true;
        }
        return matchAll;
    }

    static boolean matchesInputSet(String inputSelector, Collection propSet) {
        if (null == propSet || propSet.size() < 1) {
            return false;
        }
        if (null == inputSelector || "".equals(inputSelector.trim())) {
            return false;
        }
        if (inputSelector.contains("+") || inputSelector.contains(",")) {
            HashSet<String> orSet = new HashSet<String>();
            orSet.addAll(Arrays.asList(inputSelector.split(",")));
            for (Object e : orSet) {
                String clause = (String)e;
                HashSet<String> set = new HashSet<String>();
                set.addAll(Arrays.asList(clause.split("\\+")));
                boolean found = true;
                for (Object e2 : set) {
                    String tag = (String)e2;
                    if (propSet.contains(tag.trim())) continue;
                    boolean rematch = false;
                    for (Object aPropSet : propSet) {
                        String item = (String)aPropSet;
                        if (!NodeSet.matchRegexOrEquals(tag, item)) continue;
                        rematch = true;
                        break;
                    }
                    if (rematch) continue;
                    found = false;
                }
                if (!found) continue;
                return true;
            }
            return false;
        }
        boolean contain = propSet.contains(inputSelector);
        boolean rematch = false;
        for (Object aPropSet : propSet) {
            String item = (String)aPropSet;
            if (!NodeSet.matchRegexOrEquals(inputSelector, item)) continue;
            rematch = true;
            break;
        }
        return rematch || contain;
    }

    public static boolean matchRegexOrEquals(String inputSelector, String item) {
        String testregex = inputSelector;
        if (testregex.length() >= 2 && testregex.indexOf(47) == 0 && testregex.lastIndexOf(47) == testregex.length() - 1) {
            testregex = inputSelector.substring(1, inputSelector.length() - 1);
            return item.matches(testregex.trim());
        }
        boolean match = false;
        try {
            match = item.matches(inputSelector.trim());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return match || inputSelector.trim().equals(item);
    }

    public static NodeSet fromFilter(String filter) {
        Map<String, Map<String, String>> stringMapMap = NodeSet.parseFilter(filter);
        NodeSet nodeSet = new NodeSet();
        nodeSet.createInclude(stringMapMap.get("include"));
        nodeSet.createExclude(stringMapMap.get("exclude"));
        return nodeSet;
    }

    public static Map<String, Map<String, String>> parseFilter(String filter) {
        return NodeSet.parseFilter(filter, true, "name");
    }

    public static Map<String, Map<String, String>> parseFilter(String filter, boolean joinMulti, String defaultKey) {
        HashMap exclude = new HashMap();
        HashMap<String, Object> include = new HashMap<String, Object>();
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        result.put("include", include);
        result.put("exclude", exclude);
        String[] burst = OptsUtil.burst(filter);
        String key = null;
        for (int i = 0; i < burst.length; ++i) {
            String t = burst[i];
            if (t.endsWith(":") && key == null) {
                key = t.substring(0, t.lastIndexOf(58));
                continue;
            }
            if (t.contains(":") && key == null) {
                key = t.substring(0, t.indexOf(58));
                if ("".equals(t = t.substring(t.indexOf(58) + 1))) {
                    continue;
                }
            } else if (key == null && null != defaultKey) {
                key = defaultKey;
            }
            if (key != null) {
                HashMap<String, Object> set = include;
                if (key.startsWith("!")) {
                    key = key.substring(1);
                    set = exclude;
                }
                if (null != set.get(key) && joinMulti) {
                    set.put(key, (String)set.get(key) + "," + t);
                } else {
                    set.put(key, t);
                }
                key = null;
                continue;
            }
            key = t;
        }
        return result;
    }

    public static String generateFilter(NodeSet set) {
        ArrayList<String> buf = new ArrayList<String>();
        Map<String, String> incMap = set.includes.toMap();
        for (String inc : incMap.keySet()) {
            buf.add(inc + ":");
            buf.add(incMap.get(inc));
        }
        Map<String, String> excMap = set.excludes.toMap();
        for (String inc : excMap.keySet()) {
            buf.add("!" + inc + ":");
            buf.add(excMap.get(inc));
        }
        return OptsUtil.join(buf);
    }

    public Exclude createExclude(Map excludeMap) {
        Exclude exclude = this.createExclude();
        this.populateSetSelector(excludeMap, exclude);
        return exclude;
    }

    public Include createInclude(Map includeMap) {
        Include include = this.createInclude();
        this.populateSetSelector(includeMap, include);
        return include;
    }

    public SetSelector populateSetSelector(Map map, SetSelector setselector) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String key = (String)entry.getKey();
            String value = this.asString(entry.getValue(), ",");
            if (HOSTNAME.equals(key)) {
                setselector.setHostname(value);
                continue;
            }
            if (OS_FAMILY.equals(key)) {
                setselector.setOsfamily(value);
                continue;
            }
            if (OS_ARCH.equals(key)) {
                setselector.setOsarch(value);
                continue;
            }
            if (OS_NAME.equals(key)) {
                setselector.setOsname(value);
                continue;
            }
            if (OS_VERSION.equals(key)) {
                setselector.setOsversion(value);
                continue;
            }
            if ("name".equals(key)) {
                setselector.setName(value);
                continue;
            }
            if (TAGS.equals(key)) {
                setselector.setTags(value);
                continue;
            }
            attrs.put(key, value);
        }
        setselector.setAttributesMap(attrs);
        return setselector;
    }

    private String asString(Object value, String delim) {
        if (null == value) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof String[]) {
            String[] s = (String[])value;
            return StringArrayUtil.asString(s, delim);
        }
        if (value instanceof Collection) {
            return StringUtils.join((Collection)((Collection)value), (String)delim);
        }
        return value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeSet nodeSet = (NodeSet)o;
        if (this.keepgoing != nodeSet.keepgoing) {
            return false;
        }
        if (this.threadCount != nodeSet.threadCount) {
            return false;
        }
        if (this.excludes != null ? !this.excludes.equals(nodeSet.excludes) : nodeSet.excludes != null) {
            return false;
        }
        if (this.includes != null ? !this.includes.equals(nodeSet.includes) : nodeSet.includes != null) {
            return false;
        }
        return !(this.singleNodeName != null ? !this.singleNodeName.equals(nodeSet.singleNodeName) : nodeSet.singleNodeName != null);
    }

    public int hashCode() {
        int result = this.singleNodeName != null ? this.singleNodeName.hashCode() : 0;
        result = 31 * result + (this.includes != null ? this.includes.hashCode() : 0);
        result = 31 * result + (this.excludes != null ? this.excludes.hashCode() : 0);
        result = 31 * result + this.threadCount;
        result = 31 * result + (this.keepgoing ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NodeSet{");
        if (null != this.excludes && !this.excludes.isBlank()) {
            builder.append("excludes=").append(this.excludes).append(", ");
        }
        if (null != this.includes && !this.includes.isBlank()) {
            builder.append("includes=").append(this.includes);
        }
        if (null != this.singleNodeName) {
            builder.append("singleNode=").append(this.singleNodeName);
        }
        builder.append("}");
        return builder.toString();
    }

    public File getFailedNodesfile() {
        return this.failedNodesfile;
    }

    public void setFailedNodesfile(File failedNodesfile) {
        this.failedNodesfile = failedNodesfile;
    }

    public class Exclude
    extends SetSelector {
    }

    public class Include
    extends SetSelector {
    }

    public abstract class SetSelector {
        private boolean dominant = false;
        private String hostname = "";
        private String osfamily = "";
        private String osarch = "";
        private String osname = "";
        private String tags = "";
        private String osversion = "";
        private String name = "";
        private Map<String, String> attributesMap = new HashMap<String, String>();

        protected SetSelector() {
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            if (!this.isBlank(this.hostname)) {
                builder.append("hostname=").append(this.getHostname()).append(", ");
            }
            if (!this.isBlank(this.osfamily)) {
                builder.append("osfamily=").append(this.getOsfamily()).append(", ");
            }
            if (!this.isBlank(this.osarch)) {
                builder.append("osarch=").append(this.getOsarch()).append(", ");
            }
            if (!this.isBlank(this.osname)) {
                builder.append("osname=").append(this.getOsname()).append(", ");
            }
            if (!this.isBlank(this.osversion)) {
                builder.append("osversion=").append(this.getOsversion()).append(", ");
            }
            if (!this.isBlank(this.tags)) {
                builder.append("tags=").append(this.getTags()).append(", ");
            }
            if (!this.isBlank(this.name)) {
                builder.append("name=").append(this.getName()).append(", ");
            }
            builder.append("dominant=").append(this.isDominant()).append(", ");
            if (null != this.getAttributesMap() && this.getAttributesMap().size() > 0) {
                builder.append("attributesMap=").append(this.getAttributesMap());
            }
            builder.append("}");
            return builder.toString();
        }

        public Map<String, String> toMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            if (!this.isBlank(this.hostname)) {
                map.put(NodeSet.HOSTNAME, this.getHostname());
            }
            if (!this.isBlank(this.osfamily)) {
                map.put("osfamily", this.getOsfamily());
            }
            if (!this.isBlank(this.osarch)) {
                map.put("osarch", this.getOsarch());
            }
            if (!this.isBlank(this.osname)) {
                map.put("osname", this.getOsname());
            }
            if (!this.isBlank(this.osversion)) {
                map.put("osversion", this.getOsversion());
            }
            if (!this.isBlank(this.tags)) {
                map.put(NodeSet.TAGS, this.getTags());
            }
            if (!this.isBlank(this.name)) {
                map.put("name", this.getName());
            }
            if (null != this.getAttributesMap() && this.getAttributesMap().size() > 0) {
                map.putAll(this.getAttributesMap());
            }
            return map;
        }

        public boolean isBlank(String value) {
            return null == value || "".equals(value.trim());
        }

        public boolean isBlank() {
            return this.isBlank(this.hostname) && this.isBlank(this.osfamily) && this.isBlank(this.osarch) && this.isBlank(this.osname) && this.isBlank(this.tags) && this.isBlank(this.osversion) && this.isBlank(this.name) && this.isBlank(this.getAttributesMap());
        }

        public boolean isBlank(Map map) {
            return null == map || map.isEmpty();
        }

        public boolean matchOrBlank(Map<String, String> selector, Map<String, String> value) {
            return this.isBlank(selector) || NodeSet.matchesInput(selector, value, true);
        }

        public boolean matchOrBlank(String selector, String value) {
            return this.isBlank(selector) || NodeSet.matchesInput(selector, value);
        }

        public boolean matchOrBlank(String selector, Collection set) {
            return this.isBlank(selector) || NodeSet.matchesInputSet(selector, set);
        }

        public boolean matches(INodeEntry entry) {
            return !this.isBlank() && this.matchOrBlank(this.hostname, entry.getHostname()) && this.matchOrBlank(this.name, entry.getNodename()) && this.matchOrBlank(this.tags, entry.getTags()) && this.matchOrBlank(this.osfamily, entry.getOsFamily()) && this.matchOrBlank(this.osarch, entry.getOsArch()) && this.matchOrBlank(this.osname, entry.getOsName()) && this.matchOrBlank(this.osversion, entry.getOsVersion()) && this.matchOrBlank(this.getAttributesMap(), entry.getAttributes());
        }

        public String getOsfamily() {
            return this.osfamily;
        }

        public void setOsfamily(String osfamily) {
            this.osfamily = osfamily;
        }

        public String getOsarch() {
            return this.osarch;
        }

        public void setOsarch(String osarch) {
            this.osarch = osarch;
        }

        public String getOsname() {
            return this.osname;
        }

        public void setOsname(String osname) {
            this.osname = osname;
        }

        public String getTags() {
            return this.tags;
        }

        public void setTags(String tags) {
            this.tags = tags;
        }

        public String getOsversion() {
            return this.osversion;
        }

        public void setOsversion(String osversion) {
            this.osversion = osversion;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isDominant() {
            return this.dominant;
        }

        public void setDominant(boolean dominant) {
            this.dominant = dominant;
        }

        Map<String, String> getAttributesMap() {
            return this.attributesMap;
        }

        public void setAttributesMap(Map<String, String> attributesMap) {
            this.attributesMap = attributesMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SetSelector)) {
                return false;
            }
            SetSelector that = (SetSelector)o;
            if (this.dominant != that.dominant) {
                return false;
            }
            if (this.attributesMap != null ? !this.attributesMap.equals(that.attributesMap) : that.attributesMap != null) {
                return false;
            }
            if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.osarch != null ? !this.osarch.equals(that.osarch) : that.osarch != null) {
                return false;
            }
            if (this.osfamily != null ? !this.osfamily.equals(that.osfamily) : that.osfamily != null) {
                return false;
            }
            if (this.osname != null ? !this.osname.equals(that.osname) : that.osname != null) {
                return false;
            }
            if (this.osversion != null ? !this.osversion.equals(that.osversion) : that.osversion != null) {
                return false;
            }
            return !(this.tags != null ? !this.tags.equals(that.tags) : that.tags != null);
        }

        public int hashCode() {
            int result = this.dominant ? 1 : 0;
            result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
            result = 31 * result + (this.osfamily != null ? this.osfamily.hashCode() : 0);
            result = 31 * result + (this.osarch != null ? this.osarch.hashCode() : 0);
            result = 31 * result + (this.osname != null ? this.osname.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.osversion != null ? this.osversion.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.attributesMap != null ? this.attributesMap.hashCode() : 0);
            return result;
        }
    }

    public static enum FILTER_ENUM {
        F_HOSTNAME("hostname"){

            @Override
            public String value(SetSelector set) {
                return set.getHostname();
            }
        }
        ,
        F_NAME("name"){

            @Override
            public String value(SetSelector set) {
                return set.getName();
            }
        }
        ,
        F_TAGS("tags"){

            @Override
            public String value(SetSelector set) {
                return set.getTags();
            }
        }
        ,
        F_OS_NAME("os-name"){

            @Override
            public String value(SetSelector set) {
                return set.getOsname();
            }
        }
        ,
        F_OS_FAMILY("os-family"){

            @Override
            public String value(SetSelector set) {
                return set.getOsfamily();
            }
        }
        ,
        F_OS_ARCH("os-arch"){

            @Override
            public String value(SetSelector set) {
                return set.getOsarch();
            }
        }
        ,
        F_OS_VERSION("os-version"){

            @Override
            public String value(SetSelector set) {
                return set.getOsversion();
            }
        };

        private final String name;

        private FILTER_ENUM(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public abstract String value(SetSelector var1);
    }
}

