/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class Streams {
    public static long copyStream(InputStream in, OutputStream out) throws IOException {
        return Streams.copyStreamCount(in, out);
    }

    public static int copyStreamCount(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[10240];
        int tot = 0;
        int c = in.read(buffer);
        while (c >= 0) {
            if (c > 0) {
                out.write(buffer, 0, c);
                tot += c;
            }
            c = in.read(buffer);
        }
        return tot;
    }

    public static int copyWriterCount(Reader in, Writer out) throws IOException {
        char[] buffer = new char[10240];
        int tot = 0;
        int c = in.read(buffer);
        while (c >= 0) {
            if (c > 0) {
                out.write(buffer, 0, c);
                tot += c;
            }
            c = in.read(buffer);
        }
        return tot;
    }

    public static StreamCopyThread copyStreamThread(InputStream in, OutputStream out) {
        return Streams.copyStreamThread(in, out, null);
    }

    public static StreamCopyThread copyStreamThread(InputStream in, OutputStream out, Runnable finalizer) {
        return new StreamCopyThread(in, out, finalizer);
    }

    public static class StreamCopyThread
    extends Thread {
        final InputStream in;
        final OutputStream out;
        private IOException exception;
        private Runnable finalizer;

        public StreamCopyThread(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        public StreamCopyThread(InputStream in, OutputStream out, Runnable finalizer) {
            this.in = in;
            this.out = out;
            this.finalizer = finalizer;
        }

        @Override
        public void run() {
            try {
                Streams.copyStream(this.in, this.out);
                this.out.flush();
            }
            catch (IOException e) {
                this.exception = e;
            }
            finally {
                if (null != this.finalizer) {
                    this.finalizer.run();
                }
            }
        }

        public IOException getException() {
            return this.exception;
        }
    }
}

