/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.common.IServicesRegistration;
import com.dtolabs.rundeck.core.common.ProviderService;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.ProviderLoaderException;
import com.dtolabs.rundeck.core.execution.workflow.NodeFirstWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.ParallelWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.SequentialWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStrategy;
import com.dtolabs.rundeck.core.plugins.ChainedProviderService;
import com.dtolabs.rundeck.core.plugins.CloseableProvider;
import com.dtolabs.rundeck.core.plugins.PluggableProviderService;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.ProviderRegistryService;
import com.dtolabs.rundeck.core.plugins.ServiceFactory;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableService;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableServiceUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowStrategyService
extends ChainedProviderService<WorkflowStrategy>
implements DescribableService,
PluggableProviderService<WorkflowStrategy> {
    private static final String SERVICE_NAME = "WorkflowStrategy";
    private final IFramework framework;
    private final List<ProviderService<WorkflowStrategy>> serviceList;
    private final PluggableProviderService<WorkflowStrategy> pluginService;
    private final Map<String, String> builtinProviderSynonyms = new HashMap<String, String>();
    private final ProviderRegistryService<WorkflowStrategy> builtinService;

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    private WorkflowStrategyService(IFramework framework) {
        this.framework = framework;
        this.serviceList = new ArrayList<ProviderService<WorkflowStrategy>>();
        HashMap builtinProviders = new HashMap();
        builtinProviders.put(NodeFirstWorkflowStrategy.PROVIDER_NAME, NodeFirstWorkflowStrategy.class);
        builtinProviders.put(SequentialWorkflowStrategy.PROVIDER_NAME, SequentialWorkflowStrategy.class);
        builtinProviders.put(ParallelWorkflowStrategy.PROVIDER_NAME, ParallelWorkflowStrategy.class);
        this.builtinProviderSynonyms.put("step-first", SequentialWorkflowStrategy.PROVIDER_NAME);
        this.builtinService = ServiceFactory.builtinService(SERVICE_NAME, builtinProviders);
        this.pluginService = ServiceFactory.pluginService(SERVICE_NAME, WorkflowStrategy.class, framework.getPluginManager());
        this.serviceList.add(this.builtinService);
        this.serviceList.add(this.pluginService);
    }

    @Override
    public boolean canLoadWithLoader(ProviderLoader loader) {
        return this.pluginService.canLoadWithLoader(loader);
    }

    @Override
    public WorkflowStrategy loadWithLoader(String providerName, ProviderLoader loader) throws ProviderLoaderException {
        return (WorkflowStrategy)this.pluginService.loadWithLoader(providerName, loader);
    }

    @Override
    public CloseableProvider<WorkflowStrategy> loadCloseableWithLoader(String providerName, ProviderLoader loader) throws ProviderLoaderException {
        return this.pluginService.loadCloseableWithLoader(providerName, loader);
    }

    @Override
    protected List<ProviderService<WorkflowStrategy>> getServiceList() {
        return this.serviceList;
    }

    public static WorkflowStrategyService getInstanceForFramework(IFramework framework, IServicesRegistration registration) {
        if (null == registration.getService(SERVICE_NAME)) {
            WorkflowStrategyService service = new WorkflowStrategyService(framework);
            registration.setService(SERVICE_NAME, service);
            return service;
        }
        return (WorkflowStrategyService)registration.getService(SERVICE_NAME);
    }

    public WorkflowStrategy getStrategyForWorkflow(WorkflowExecutionItem workflow, Map<String, Object> config, String projectName) throws ExecutionServiceException {
        String provider = workflow.getWorkflow().getStrategy();
        String s = this.builtinProviderSynonyms.get(provider);
        if (null != s) {
            provider = s;
        }
        WorkflowStrategy workflowStrategy = (WorkflowStrategy)this.providerOfType(provider);
        if (null != config) {
            IRundeckProjectConfig iRundeckProjectConfig = this.framework.getFrameworkProjectMgr().loadProjectConfig(projectName);
            PropertyResolver resolver = PropertyResolverFactory.createResolver(config.size() > 0 ? PropertyResolverFactory.instanceRetriever(config) : null, PropertyResolverFactory.instanceRetriever(iRundeckProjectConfig.getProjectProperties()), this.framework.getPropertyRetriever());
            Description description = DescribableServiceUtil.descriptionForProvider(true, workflowStrategy);
            if (description != null) {
                PluginAdapterUtility.configureProperties(resolver, description, workflowStrategy, PropertyScope.Instance);
            }
        }
        return workflowStrategy;
    }

    public WorkflowStrategy getStrategyForWorkflow(WorkflowExecutionItem workflow, PropertyResolver resolver) throws ExecutionServiceException {
        Description description;
        String provider = workflow.getWorkflow().getStrategy();
        String s = this.builtinProviderSynonyms.get(provider);
        if (null != s) {
            provider = s;
        }
        WorkflowStrategy workflowStrategy = (WorkflowStrategy)this.providerOfType(provider);
        if (null != resolver && (description = DescribableServiceUtil.descriptionForProvider(true, workflowStrategy)) != null) {
            PluginAdapterUtility.configureProperties(resolver, description, workflowStrategy, PropertyScope.Instance);
        }
        return workflowStrategy;
    }

    @Override
    public List<Description> listDescriptions() {
        return DescribableServiceUtil.listDescriptions(this);
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return DescribableServiceUtil.listDescribableProviders(this);
    }

    @Deprecated
    public void registerClass(String name, Class<? extends WorkflowStrategy> clazz) {
        this.builtinService.registerClass(name, clazz);
    }

    @Deprecated
    public void registerInstance(String name, WorkflowStrategy object) {
        this.builtinService.registerInstance(name, object);
    }
}

