/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.local;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.impl.local.LocalNodeExecutor;
import com.dtolabs.rundeck.core.execution.script.ExecTaskParameterGenerator;
import com.dtolabs.rundeck.core.execution.script.ExecTaskParameterGeneratorImpl;
import com.dtolabs.rundeck.core.execution.script.ExecTaskParameters;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepFailureReason;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.utils.ScriptExecUtil;
import com.dtolabs.rundeck.plugins.descriptions.PluginDescription;
import com.dtolabs.rundeck.plugins.descriptions.PluginProperty;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

@Plugin(name="newlocal", service="NodeExecutor")
@PluginDescription(title="Local (New)", description="Beta - Executes commands locally on the Rundeck server")
public class NewLocalNodeExecutor
implements NodeExecutor,
DescriptionBuilder.Collaborator {
    public static final String SERVICE_PROVIDER_TYPE = "newlocal";
    public static final String PROP_MERGE_ENV = "mergeEnv";
    private ExecTaskParameterGenerator parameterGenerator = new ExecTaskParameterGeneratorImpl();
    private boolean disableLocalExecutor = LocalNodeExecutor.getDisableLocalExecutorEnv();
    @PluginProperty(title="Merge Environment", description="Merge the environment variables from the Rundeck server with the local environment", defaultValue="true", scope=PropertyScope.Framework)
    Boolean mergeEnv;

    @Override
    public void buildWith(DescriptionBuilder builder) {
        builder.frameworkMapping(PROP_MERGE_ENV, String.join((CharSequence)".", "framework", "NodeExecutor", SERVICE_PROVIDER_TYPE, PROP_MERGE_ENV));
    }

    @Override
    public NodeExecutorResult executeCommand(ExecutionContext context, String[] command, INodeEntry node) {
        return this.executeCommand(context, command, null, node);
    }

    @Override
    public NodeExecutorResult executeCommand(ExecutionContext context, String[] command, InputStream inputStream, INodeEntry node) {
        int result;
        if (this.disableLocalExecutor) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.ConfigurationFailure, "Local Executor is disabled", node);
        }
        ArrayList<String> commandList = new ArrayList<String>();
        try {
            ExecTaskParameters taskParameters = this.parameterGenerator.generate(node, true, null, command);
            commandList.add(taskParameters.getCommandexecutable());
            commandList.addAll(Arrays.asList(taskParameters.getCommandArgs()));
        }
        catch (ExecutionException e) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.ConfigurationFailure, e.getMessage(), node);
        }
        StringBuilder preview = new StringBuilder();
        for (String aCommand : commandList) {
            preview.append("'").append(aCommand).append("'");
        }
        context.getExecutionLogger().log(5, "NewLocalNodeExecutor, running command (" + commandList.size() + "): " + preview);
        Map<String, String> env = DataContextUtils.generateEnvVarsFromContext(context.getDataContext());
        try {
            result = ScriptExecUtil.runLocalCommand(commandList.toArray(new String[0]), env, null, System.out, System.err, this.mergeEnv == false, ScriptExecUtil::killProcessHandleDescend, inputStream);
        }
        catch (IOException e) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.IOFailure, e.getMessage(), node);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return NodeExecutorResultImpl.createFailure(StepFailureReason.Interrupted, e.getMessage(), node);
        }
        if (null != context.getOutputContext()) {
            context.getOutputContext().addOutput("exec", "exitCode", String.valueOf(result));
        }
        if (result != 0) {
            return NodeExecutorResultImpl.createFailure(NodeStepFailureReason.NonZeroResultCode, "Result code was " + result, node, result);
        }
        return NodeExecutorResultImpl.createSuccess(node);
    }
}

