/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.execution.impl.local.LocalNodeExecutor;
import com.dtolabs.rundeck.core.execution.impl.local.NewLocalNodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorServiceProfile;
import com.dtolabs.rundeck.core.execution.service.NodeSpecifiedService;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.execution.service.ScriptPluginNodeExecutor;
import com.dtolabs.rundeck.core.plugins.JavaClassProviderLoadable;
import com.dtolabs.rundeck.core.plugins.PluggableProviderService;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProviderLoadable;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableService;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableServiceUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import java.util.List;
import java.util.Map;

public class NodeExecutorService
extends NodeSpecifiedService<NodeExecutor>
implements DescribableService,
PluggableProviderService<NodeExecutor>,
JavaClassProviderLoadable<NodeExecutor>,
ScriptPluginProviderLoadable<NodeExecutor> {
    private static final String SERVICE_NAME = "NodeExecutor";
    public static final String SERVICE_DEFAULT_PROVIDER_PROPERTY = "service.NodeExecutor.default.provider";
    private static final String SERVICE_DEFAULT_LOCAL_PROVIDER_PROPERTY = "service.NodeExecutor.default.local.provider";
    public static final String NODE_SERVICE_SPECIFIER_ATTRIBUTE = "node-executor";
    public static final String LOCAL_NODE_SERVICE_SPECIFIER_ATTRIBUTE = "local-node-executor";
    static final NodeExecutorServiceProfile LEGACY_PROFILE = new LegacyProfile();
    private NodeExecutorServiceProfile serviceProfile;

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    public List<String> getBundledProviderNames() {
        return List.copyOf(this.getRegistryMap().keySet());
    }

    public NodeExecutorService(Framework framework, NodeExecutorServiceProfile serviceProfile) {
        super(framework, true);
        this.serviceProfile = serviceProfile;
    }

    public NodeExecutorService(Framework framework) {
        this(framework, LEGACY_PROFILE);
    }

    @Override
    protected Map<String, Class<? extends NodeExecutor>> getRegistryMap() {
        return this.serviceProfile.getLocalRegistry();
    }

    @Override
    public String getDefaultProviderNameForNodeAndProject(INodeEntry node, String project) {
        return this.getProviderNameForNode(this.framework.isLocalNode(node), this.framework.getProjectManager().loadProjectConfig(project));
    }

    @Override
    public String getServiceProviderNodeAttributeForNode(INodeEntry node) {
        return NodeExecutorService.getNodeAttributeForProvider(this.framework.isLocalNode(node));
    }

    public String getProviderNameForNode(boolean localNode, IRundeckProjectConfig loadProjectConfig) {
        if (localNode) {
            String value = loadProjectConfig.getProperty(SERVICE_DEFAULT_LOCAL_PROVIDER_PROPERTY);
            return null != value ? value : this.serviceProfile.getDefaultLocalProvider();
        }
        String value = loadProjectConfig.getProperty(SERVICE_DEFAULT_PROVIDER_PROPERTY);
        return null != value ? value : this.serviceProfile.getDefaultRemoteProvider();
    }

    public static String getNodeAttributeForProvider(boolean localNode) {
        if (localNode) {
            return LOCAL_NODE_SERVICE_SPECIFIER_ATTRIBUTE;
        }
        return NODE_SERVICE_SPECIFIER_ATTRIBUTE;
    }

    @Override
    public boolean isValidProviderClass(Class clazz) {
        return NodeExecutor.class.isAssignableFrom(clazz) && this.hasValidProviderSignature(clazz);
    }

    @Override
    public <X extends NodeExecutor> NodeExecutor createProviderInstance(Class<X> clazz, String name) throws PluginException, ProviderCreationException {
        return (NodeExecutor)this.createProviderInstanceFromType(clazz, name);
    }

    @Override
    public NodeExecutor createScriptProviderInstance(ScriptPluginProvider provider) throws PluginException {
        ScriptPluginNodeExecutor.validateScriptPlugin(provider);
        return new ScriptPluginNodeExecutor(provider, this.framework);
    }

    @Override
    public List<Description> listDescriptions() {
        return DescribableServiceUtil.listDescriptions(this, true);
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return DescribableServiceUtil.listDescribableProviders(this);
    }

    public NodeExecutorServiceProfile getServiceProfile() {
        return this.serviceProfile;
    }

    public void setServiceProfile(NodeExecutorServiceProfile serviceProfile) {
        this.serviceProfile = serviceProfile;
    }

    static class LegacyProfile
    implements NodeExecutorServiceProfile {
        public static final String DEFAULT_REMOTE_PROVIDER = "sshj-ssh";
        private static final Map<String, Class<? extends NodeExecutor>> PRESET_PROVIDERS = Map.of("local", LocalNodeExecutor.class, "newlocal", NewLocalNodeExecutor.class);
        private final String defaultLocalProvider = "local";
        private final String defaultRemoteProvider = "sshj-ssh";
        private final Map<String, Class<? extends NodeExecutor>> localRegistry = PRESET_PROVIDERS;

        LegacyProfile() {
        }

        @Override
        public String getDefaultLocalProvider() {
            return this.defaultLocalProvider;
        }

        @Override
        public String getDefaultRemoteProvider() {
            return this.defaultRemoteProvider;
        }

        @Override
        public Map<String, Class<? extends NodeExecutor>> getLocalRegistry() {
            return this.localRegistry;
        }
    }
}

