/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins.configuration;

import com.dtolabs.rundeck.core.common.PropertyRetriever;
import com.dtolabs.rundeck.core.config.FeatureInfoService;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.configuration.Configurable;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapter;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyValidator;
import com.dtolabs.rundeck.core.plugins.configuration.StringRenderingConstants;
import com.dtolabs.rundeck.plugins.config.Group;
import com.dtolabs.rundeck.plugins.config.PluginGroup;
import com.dtolabs.rundeck.plugins.descriptions.Password;
import com.dtolabs.rundeck.plugins.descriptions.PluginCustomConfig;
import com.dtolabs.rundeck.plugins.descriptions.PluginDescription;
import com.dtolabs.rundeck.plugins.descriptions.PluginMetadata;
import com.dtolabs.rundeck.plugins.descriptions.PluginProperty;
import com.dtolabs.rundeck.plugins.descriptions.RenderingOption;
import com.dtolabs.rundeck.plugins.descriptions.ReplaceDataVariablesWithBlanks;
import com.dtolabs.rundeck.plugins.descriptions.SelectLabels;
import com.dtolabs.rundeck.plugins.descriptions.SelectValues;
import com.dtolabs.rundeck.plugins.descriptions.TextArea;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PluginAdapterImpl
implements PluginAdapter {
    FeatureInfoService featureInfoService;
    private final List<PropertyScope> instanceScopes = Arrays.asList(PropertyScope.Instance, PropertyScope.InstanceOnly);

    @Override
    public boolean canBuildDescription(Object object) {
        String annotation1 = this.getPluginNameAnnotation(object.getClass());
        return null != annotation1;
    }

    @Override
    public Description buildDescription(Object object, DescriptionBuilder builder) {
        return this.buildDescription(object, builder, true);
    }

    @Override
    public Description buildDescription(Class<?> type, DescriptionBuilder builder) {
        return this.buildDescription(type, builder, true);
    }

    @Override
    public Description buildDescription(Object object, DescriptionBuilder builder, boolean includeAnnotatedFieldProperties) {
        this.buildDescription(object.getClass(), builder, includeAnnotatedFieldProperties);
        builder.collaborate(object);
        return builder.build();
    }

    @Override
    public Description buildDescription(Class<?> type, DescriptionBuilder builder, boolean includeAnnotatedFieldProperties) {
        PluginDescription descAnnotation;
        String pluginName = this.getPluginNameAnnotation(type);
        if (null != pluginName) {
            builder.name(pluginName).title(pluginName).description("");
        }
        if (null != (descAnnotation = type.getAnnotation(PluginDescription.class))) {
            if (!"".equals(descAnnotation.title())) {
                builder.title(descAnnotation.title());
            }
            if (!"".equals(descAnnotation.description())) {
                builder.description(descAnnotation.description());
            }
            if (descAnnotation.isHighlighted()) {
                builder.isHighlighted(true);
                builder.order(descAnnotation.order());
            }
        }
        builder.metadata(this.loadPluginMetadata(type));
        Group group = type.getAnnotation(Group.class);
        if (null != group && !PluginGroup.class.isAssignableFrom(type)) {
            Class<?> value = group.value();
            if (!PluginGroup.class.isAssignableFrom(value)) {
                throw new IllegalStateException("Cannot use group type: " + value);
            }
            builder.pluginGroup(value.asSubclass(PluginGroup.class));
        }
        if (includeAnnotatedFieldProperties) {
            this.buildFieldProperties(type, builder);
        }
        return builder.build();
    }

    @Override
    public String getPluginNameAnnotation(Class<?> aClass) {
        Plugin annotation1 = aClass.getAnnotation(Plugin.class);
        return annotation1 != null ? annotation1.name() : null;
    }

    @Override
    public Map<String, String> loadPluginMetadata(Class<?> clazz) {
        HashMap<String, String> meta = new HashMap<String, String>();
        PluginMetadata[] metadata = (PluginMetadata[])clazz.getAnnotationsByType(PluginMetadata.class);
        if (null != metadata && metadata.length > 0) {
            for (PluginMetadata metadatum : metadata) {
                meta.put(metadatum.key(), metadatum.value());
            }
        }
        return meta;
    }

    @Override
    public List<Property> buildFieldProperties(Object object) {
        return this.buildFieldProperties(object.getClass());
    }

    @Override
    public List<Property> buildFieldProperties(Class<?> aClass) {
        DescriptionBuilder builder = DescriptionBuilder.builder();
        this.buildFieldProperties(aClass, builder);
        return builder.buildProperties();
    }

    @Override
    public void buildFieldProperties(Object object, DescriptionBuilder builder) {
        this.buildFieldProperties(object.getClass(), builder);
    }

    @Override
    public void buildFieldProperties(Class<?> aClass, DescriptionBuilder builder) {
        for (Field field : this.collectClassFields(aClass)) {
            Property pbuild;
            PluginProperty annotation = field.getAnnotation(PluginProperty.class);
            if (null == annotation || null == (pbuild = this.propertyFromField(field, annotation))) continue;
            builder.property(pbuild);
        }
    }

    @Override
    public Field fieldForPropertyName(String name, Object object) {
        for (Field field : this.collectFields(object)) {
            PluginProperty annotation = field.getAnnotation(PluginProperty.class);
            if (null == annotation) continue;
            if (!"".equals(annotation.name()) && name.equals(annotation.name())) {
                return field;
            }
            if (!"".equals(annotation.name()) || !name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    @Override
    public Collection<Field> collectFields(Object object) {
        return this.collectClassFields(object.getClass());
    }

    @Override
    public Collection<Field> collectClassFields(Class<?> aClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> clazz = aClass;
        do {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return fields;
    }

    @Override
    public Property.Type propertyTypeFromFieldType(Class clazz) {
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Property.Type.Integer;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return Property.Type.Long;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Property.Type.Boolean;
        }
        if (clazz == String.class) {
            return Property.Type.String;
        }
        if (clazz == String[].class || Set.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz)) {
            return Property.Type.Options;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Property propertyFromField(Field field, PluginProperty annotation) {
        void var5_15;
        PropertyBuilder pbuild = PropertyBuilder.builder();
        Property.Type type = this.propertyTypeFromFieldType(field.getType());
        if (null == type) {
            return null;
        }
        pbuild.type(type);
        if (type == Property.Type.Options) {
            SelectValues selectValues = field.getAnnotation(SelectValues.class);
            if (null != selectValues) {
                String[] values = selectValues.values();
                pbuild.values(values);
                this.extractSelectLabels(pbuild, values, field.getAnnotation(SelectLabels.class));
            }
        } else if (type == Property.Type.String) {
            void var5_10;
            StringRenderingConstants.DisplayType displayType = StringRenderingConstants.DisplayType.SINGLE_LINE;
            SelectValues selectAnnotation = field.getAnnotation(SelectValues.class);
            if (null != selectAnnotation) {
                pbuild.type(selectAnnotation.multiOption() ? Property.Type.Options : (selectAnnotation.freeSelect() ? Property.Type.FreeSelect : Property.Type.Select));
                String[] values = selectAnnotation.values();
                pbuild.values(values);
                pbuild.dynamicValues(selectAnnotation.dynamicValues());
                this.extractSelectLabels(pbuild, values, field.getAnnotation(SelectLabels.class));
            }
            if (field.getAnnotation(TextArea.class) != null) {
                StringRenderingConstants.DisplayType displayType2 = StringRenderingConstants.DisplayType.MULTI_LINE;
            }
            if (field.getAnnotation(Password.class) != null) {
                StringRenderingConstants.DisplayType displayType3 = StringRenderingConstants.DisplayType.PASSWORD;
            }
            pbuild.renderingOption("displayType", var5_10);
            ReplaceDataVariablesWithBlanks blankReplaceAnnotation = field.getAnnotation(ReplaceDataVariablesWithBlanks.class);
            if (blankReplaceAnnotation != null) {
                pbuild.blankIfUnexpandable(blankReplaceAnnotation.value());
            }
        }
        for (RenderingOption renderingOption : (RenderingOption[])field.getAnnotationsByType(RenderingOption.class)) {
            pbuild.renderingOption(renderingOption.key(), renderingOption.value());
        }
        String string = annotation.name();
        if (null == string || "".equals(string)) {
            String string2 = field.getName();
        }
        pbuild.name((String)var5_15);
        if (this.notBlank(annotation.title())) {
            pbuild.title(annotation.title());
        } else {
            pbuild.title((String)var5_15);
        }
        pbuild.description(annotation.description());
        if (this.notBlank(annotation.defaultValue())) {
            pbuild.defaultValue(annotation.defaultValue());
        }
        pbuild.required(annotation.required());
        pbuild.scope(annotation.scope());
        if (this.notBlank(annotation.validatorClassName()) || !Object.class.equals(annotation.validatorClass())) {
            Class<?> validatorClass = annotation.validatorClass();
            String validatorClassName = annotation.validatorClassName();
            if (this.notBlank(validatorClassName)) {
                try {
                    validatorClass = Class.forName(validatorClassName);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (PropertyValidator.class.isAssignableFrom(validatorClass)) {
                    PropertyValidator validator = (PropertyValidator)validatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    pbuild.validator(validator);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return pbuild.build();
    }

    @Override
    public void extractSelectLabels(PropertyBuilder pbuild, String[] values, SelectLabels labelsAnnotation) {
        if (null != labelsAnnotation) {
            String[] labels = labelsAnnotation.values();
            HashMap<String, String> labelsMap = new HashMap<String, String>();
            for (int i = 0; i < values.length && i < labels.length; ++i) {
                labelsMap.put(values[i], labels[i]);
            }
            pbuild.labels(labelsMap);
        }
    }

    @Override
    public boolean notBlank(String string) {
        return null != string && !"".equals(string);
    }

    @Override
    public Map<String, Object> configureProperties(PropertyResolver resolver, Object object) {
        return this.configureProperties(resolver, this.buildDescription(object, DescriptionBuilder.builder()), object, PropertyScope.InstanceOnly);
    }

    @Override
    public Map<String, Object> configureProperties(PropertyResolver resolver, Description description, Object object, PropertyScope defaultScope) {
        Map<String, Object> inputConfig = this.mapDescribedProperties(resolver, description, defaultScope);
        if (object instanceof Configurable) {
            Configurable configObject = (Configurable)object;
            Properties configuration = new Properties();
            configuration.putAll(inputConfig);
            try {
                configObject.configure(configuration);
            }
            catch (ConfigurationException configurationException) {}
        } else {
            inputConfig = this.configureObjectFieldsWithProperties(object, description.getProperties(), inputConfig);
        }
        return inputConfig;
    }

    @Override
    public Map<String, Object> configureObjectFieldsWithProperties(Object object, Map<String, Object> inputConfig) {
        return this.configureObjectFieldsWithProperties(object, this.buildFieldProperties(object), inputConfig);
    }

    @Override
    public Map<String, Object> configureObjectFieldsWithProperties(Object object, List<Property> properties, Map<String, Object> inputConfig) {
        HashMap<String, Object> modified = new HashMap<String, Object>(inputConfig);
        for (Property property : properties) {
            if (null == modified.get(property.getName()) || !this.setValueForProperty(property, modified.get(property.getName()), object)) continue;
            modified.remove(property.getName());
        }
        return modified;
    }

    @Override
    public Map<String, Object> mapDescribedProperties(PropertyResolver resolver, Description description) {
        return this.mapDescribedProperties(resolver, description, null);
    }

    @Override
    public Map<String, Object> mapDescribedProperties(PropertyResolver resolver, Description description, PropertyScope defaultPropertyScope) {
        List<Property> properties = description.getProperties();
        return this.mapProperties(resolver, properties, defaultPropertyScope);
    }

    @Override
    public Map<String, Object> mapProperties(PropertyResolver resolver, List<Property> properties, PropertyScope defaultPropertyScope) {
        PropertyResolver inputResolver = resolver;
        if (null != this.featureInfoService) {
            inputResolver = this.featureFlagScopeResolver(resolver, properties);
        }
        PropertyResolver defaulted = PropertyResolverFactory.withDefaultValues(PropertyResolverFactory.withDefaultScope(null != defaultPropertyScope ? defaultPropertyScope : PropertyScope.InstanceOnly, inputResolver), new PropertyDefaultValues(properties));
        return PropertyResolverFactory.mapPropertyValues(properties, defaulted);
    }

    private PropertyResolver featureFlagScopeResolver(PropertyResolver resolver, List<Property> properties) {
        return (name, scope) -> {
            if (scope != PropertyScope.FeatureFlag) {
                return resolver.resolvePropertyValue(name, scope);
            }
            String flagName = properties.stream().filter(p -> p.getName().equals(name)).filter(p -> p.getRenderingOptions() != null && p.getRenderingOptions().get("featureFlagName") != null).findFirst().map(p -> p.getRenderingOptions().get("featureFlagName").toString()).orElse(name);
            return this.featureInfoService.featurePresent(flagName);
        };
    }

    @Override
    public void setConfig(Object object, Object config) {
        for (Field field : this.collectClassFields(object.getClass())) {
            PluginCustomConfig annotation = field.getAnnotation(PluginCustomConfig.class);
            if (null == annotation) continue;
            try {
                this.setFieldValue(field, config, object);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot set value of PluginCustomConfig field: " + field.getName(), e);
            }
        }
    }

    @Override
    public PluginCustomConfig getCustomConfigAnnotation(Object providerInstance) {
        Field field;
        PluginCustomConfig annotation = null;
        Iterator<Field> iterator = this.collectClassFields(providerInstance.getClass()).iterator();
        while (iterator.hasNext() && null == (annotation = (field = iterator.next()).getAnnotation(PluginCustomConfig.class))) {
        }
        return annotation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setValueForProperty(Property property, Object value, Object object) {
        String[] resolvedValue;
        Field field = this.fieldForPropertyName(property.getName(), object);
        if (null == field) {
            return false;
        }
        Property.Type type = property.getType();
        Property.Type ftype = this.propertyTypeFromFieldType(field.getType());
        if (ftype != property.getType() && (ftype != Property.Type.String || property.getType() != Property.Type.Select && property.getType() != Property.Type.FreeSelect && property.getType() != Property.Type.Options)) {
            throw new IllegalStateException(String.format("cannot map property {%s type: %s} to field {%s type: %s}", new Object[]{property.getName(), property.getType(), field.getName(), ftype}));
        }
        if (type == Property.Type.Integer) {
            Integer intvalue;
            if (value instanceof String) {
                intvalue = Integer.parseInt((String)value);
            } else {
                if (!(value instanceof Integer)) return false;
                intvalue = (Integer)value;
            }
            resolvedValue = intvalue;
        } else if (type == Property.Type.Long) {
            Long longvalue;
            if (value instanceof String) {
                longvalue = Long.parseLong((String)value);
            } else if (value instanceof Long) {
                longvalue = (Long)value;
            } else {
                if (!(value instanceof Integer)) return false;
                int val = (Integer)value;
                longvalue = val;
            }
            resolvedValue = longvalue;
        } else if (type == Property.Type.Boolean) {
            Boolean boolvalue;
            if (value instanceof String) {
                boolvalue = Boolean.parseBoolean((String)value);
            } else {
                if (!(value instanceof Boolean)) return false;
                boolvalue = (Boolean)value;
            }
            resolvedValue = boolvalue;
        } else if (type == Property.Type.Options) {
            List<String> splitList;
            if (value instanceof String) {
                String valstring = (String)value;
                splitList = Arrays.asList(valstring.split(", *"));
            } else if (value instanceof List) {
                splitList = (List<String>)value;
            } else if (value instanceof Set) {
                splitList = new ArrayList<String>((Set)value);
            } else {
                if (value.getClass() != String[].class) return false;
                splitList = Arrays.asList((String[])value);
            }
            HashSet<String> resolvedValueSet = null;
            if (field.getType().isAssignableFrom(Set.class)) {
                HashSet<String> strings = new HashSet<String>();
                strings.addAll(splitList);
                resolvedValueSet = strings;
                resolvedValue = strings;
            } else if (field.getType().isAssignableFrom(List.class)) {
                ArrayList<String> strings = new ArrayList<String>();
                strings.addAll(splitList);
                resolvedValueSet = new HashSet(strings);
                resolvedValue = strings;
            } else if (field.getType() == String[].class) {
                ArrayList<String> strings = new ArrayList<String>();
                strings.addAll(splitList);
                resolvedValueSet = new HashSet(strings);
                resolvedValue = strings.toArray(new String[strings.size()]);
            } else {
                if (field.getType() != String.class) return false;
                resolvedValueSet = new HashSet();
                resolvedValueSet.addAll(splitList);
                resolvedValue = value;
            }
            if (property.getSelectValues() != null && !property.getSelectValues().containsAll(resolvedValueSet)) {
                throw new RuntimeException(String.format("Some options values were not allowed for property %s: %s", property.getName(), resolvedValue));
            }
        } else if (type == Property.Type.String || type == Property.Type.FreeSelect) {
            if (!(value instanceof String)) return false;
            resolvedValue = value;
        } else {
            if (type != Property.Type.Select) return false;
            if (!(value instanceof String)) return false;
            resolvedValue = value;
            if (!field.getAnnotation(SelectValues.class).dynamicValues() && !property.getSelectValues().contains((String)resolvedValue)) {
                throw new RuntimeException("value not allowed for property " + property.getName() + ": " + resolvedValue);
            }
        }
        try {
            this.setFieldValue(field, resolvedValue, object);
            return true;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to configure plugin: " + e.getMessage(), e);
        }
    }

    private void setFieldValue(Field field, Object value, Object object) throws IllegalAccessException {
        if (!field.canAccess(object)) {
            field.setAccessible(true);
        }
        field.set(object, value);
    }

    public FeatureInfoService getFeatureInfoService() {
        return this.featureInfoService;
    }

    public void setFeatureInfoService(FeatureInfoService featureInfoService) {
        this.featureInfoService = featureInfoService;
    }

    private class PropertyDefaultValues
    implements PropertyRetriever {
        private Map<String, String> properties = new HashMap<String, String>();

        private PropertyDefaultValues(List<Property> properties1) {
            for (Property property : properties1) {
                if (null == property.getDefaultValue()) continue;
                this.properties.put(property.getName(), property.getDefaultValue());
            }
        }

        @Override
        public String getProperty(String name) {
            return this.properties.get(name);
        }
    }
}

