/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.StateObj;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;

public interface Condition
extends Predicate<StateObj> {
    public static Condition with(final Predicate<StateObj> pred) {
        return new Condition(){

            @Override
            public boolean test(StateObj input) {
                return pred.test(input);
            }

            public String toString() {
                return pred.toString();
            }
        };
    }

    default public Condition negate() {
        return Condition.with(t -> !this.test(t));
    }

    public static Condition not(Condition condition) {
        return Condition.with(condition.negate());
    }

    public static Condition and(Condition condition1, Condition condition2) {
        return Condition.with(condition1.and(condition2));
    }

    public static Condition and(Condition ... conditions) {
        return Condition.with(Condition.andAll(conditions));
    }

    public static Predicate<StateObj> andAll(Condition[] conditions) {
        return Condition.andAll(Arrays.asList(conditions));
    }

    public static Condition and(Iterable<Condition> conditions) {
        return Condition.with(Condition.andAll(conditions));
    }

    public static Predicate<StateObj> andAll(Iterable<Condition> conditions) {
        return state -> StreamSupport.stream(conditions.spliterator(), false).allMatch(pred -> pred.test(state));
    }

    public static Predicate<StateObj> orAll(Iterable<Condition> conditions) {
        return state -> StreamSupport.stream(conditions.spliterator(), false).anyMatch(pred -> pred.test(state));
    }

    public static Condition or(Condition condition1, Condition condition2) {
        return Condition.with(condition1.or(condition2));
    }

    public static Condition or(Condition ... conditions) {
        return Condition.with(Condition.orAll(Arrays.asList(conditions)));
    }

    public static Condition or(Iterable<Condition> conditions) {
        return Condition.with(Condition.orAll(conditions));
    }
}

