/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.settings;

import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.tools.nsc.settings.AnyScalaVersion$;
import scala.tools.nsc.settings.Development;
import scala.tools.nsc.settings.Final$;
import scala.tools.nsc.settings.Milestone;
import scala.tools.nsc.settings.NoScalaVersion$;
import scala.tools.nsc.settings.RC;
import scala.tools.nsc.settings.ScalaBuild;
import scala.tools.nsc.settings.ScalaVersion;
import scala.tools.nsc.settings.SpecificScalaVersion;
import scala.util.Properties$;
import scala.util.matching.Regex;

public final class ScalaVersion$ {
    public static final ScalaVersion$ MODULE$;
    private final String dot;
    private final String dash;
    private final String vchar;
    private final Regex vpat;
    private final Regex rcpat;
    private final Regex mspat;
    private final ScalaVersion current;
    private final SpecificScalaVersion twoDotEight;

    static {
        new ScalaVersion$();
    }

    private String dot() {
        return this.dot;
    }

    private String dash() {
        return this.dash;
    }

    private String vchar() {
        return this.vchar;
    }

    private Regex vpat() {
        return this.vpat;
    }

    private Regex rcpat() {
        return this.rcpat;
    }

    private Regex mspat() {
        return this.mspat;
    }

    public ScalaVersion apply(String versionString, Function1<String, BoxedUnit> errorHandler) {
        ScalaVersion scalaVersion;
        if ("none".equals(versionString)) {
            scalaVersion = NoScalaVersion$.MODULE$;
        } else if ("any".equals(versionString)) {
            scalaVersion = AnyScalaVersion$.MODULE$;
        } else {
            Option option = this.vpat().unapplySeq((CharSequence)versionString);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(4) == 0) {
                String majorS = (String)((LinearSeqOptimized)option.get()).apply(0);
                String minorS = (String)((LinearSeqOptimized)option.get()).apply(1);
                String revS = (String)((LinearSeqOptimized)option.get()).apply(2);
                String buildS = (String)((LinearSeqOptimized)option.get()).apply(3);
                scalaVersion = new SpecificScalaVersion(this.toInt$1(majorS), this.toInt$1(minorS), this.toInt$1(revS), this.toBuild$1(buildS));
            } else {
                this.error$1(versionString, errorHandler);
                scalaVersion = AnyScalaVersion$.MODULE$;
            }
        }
        return scalaVersion;
    }

    public ScalaVersion apply(String versionString) {
        return this.apply(versionString, (Function1<String, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(String msg) {
                throw new NumberFormatException(msg);
            }
        });
    }

    public ScalaVersion current() {
        return this.current;
    }

    public SpecificScalaVersion twoDotEight() {
        return this.twoDotEight;
    }

    private final void error$1(String versionString$1, Function1 errorHandler$1) {
        errorHandler$1.apply((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There was a problem parsing ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{versionString$1}))).append((Object)"Versions should be in the form major[.minor[.revision]] ").append((Object)"where each part is a positive number, as in 2.10.1. ").append((Object)"The minor and revision parts are optional.").toString());
    }

    private final int toInt$1(String s) {
        int n;
        boolean bl = s == null ? true : "".equals(s);
        if (bl) {
            n = 0;
        } else {
            Predef$ predef$ = Predef$.MODULE$;
            n = new StringOps(s).toInt();
        }
        return n;
    }

    private final ScalaBuild toBuild$1(String s) {
        ScalaBuild scalaBuild;
        boolean bl = s == null ? true : "FINAL".equals(s);
        if (bl) {
            scalaBuild = Final$.MODULE$;
        } else {
            Option option = this.rcpat().unapplySeq((CharSequence)s);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String i = (String)((LinearSeqOptimized)option.get()).apply(0);
                scalaBuild = new RC(this.toInt$1(i));
            } else {
                Option option2 = this.mspat().unapplySeq((CharSequence)s);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                    String i = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    scalaBuild = new Milestone(this.toInt$1(i));
                } else {
                    scalaBuild = new Development(s);
                }
            }
        }
        return scalaBuild;
    }

    private ScalaVersion$() {
        MODULE$ = this;
        this.dot = "\\.";
        this.dash = "-";
        this.vchar = "\\d";
        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(?s)(", "+)(?:", "(", "+)(?:", "(", "+)(?:", "(.*))?)?)?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.vchar(), this.dot(), this.vchar(), this.dot(), this.vchar(), this.dash()}));
        Predef$ predef$ = Predef$.MODULE$;
        this.vpat = new StringOps(string).r();
        Predef$ predef$2 = Predef$.MODULE$;
        this.rcpat = new StringOps("(?i)rc(\\d*)").r();
        Predef$ predef$3 = Predef$.MODULE$;
        this.mspat = new StringOps("(?i)m(\\d*)").r();
        this.current = this.apply(Properties$.MODULE$.versionNumberString());
        this.twoDotEight = new SpecificScalaVersion(2, 8, 0, Final$.MODULE$);
    }
}

