/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Iterator;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.runtime.BoxesUtility;
import scala.runtime.Nothing$;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.PlainFile;
import scala.tools.nsc.io.VirtualFile;

public final class ZipArchive
extends PlainFile
implements ScalaObject {
    private DirEntry root;
    private ZipFile archive;

    public ZipArchive(File file, ZipFile archive) {
        this.archive = archive;
        super(file);
        Predef$.MODULE$.assert(archive != null);
    }

    private DirEntry getDir(Map dirs, String path) {
        DirEntry dirEntry;
        Option option = dirs.get((Object)path);
        if (!(option instanceof Some)) {
            if (option != None$.MODULE$) {
                throw new MatchError((Object)option);
            }
            int index = path.lastIndexOf(47, path.length() - 2);
            String name = index >= 0 ? path.substring(index + 1) : path;
            String home = index >= 0 ? path.substring(0, index + 1) : "/";
            DirEntry parent = this.getDir(dirs, home);
            DirEntry dir = new DirEntry(this, name.substring(0, name.length() - 1), path);
            parent.entries().update((Object)name, (Object)dir);
            dirs.update((Object)path, (Object)dir);
            dirEntry = dir;
        } else {
            dirEntry = (DirEntry)((Some)option).x();
        }
        return dirEntry;
    }

    private void load() {
        this.root_$eq(new DirEntry(this, "<root>", "/"));
        HashMap dirs = new HashMap();
        dirs.update((Object)"/", (Object)this.root());
        Enumeration<? extends ZipEntry> entries = this.archive().entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String path = entry.getName();
            Predef$.MODULE$.assert(entry.isDirectory() == path.endsWith("/"), (Object)(this.toString() + " - " + path));
            if (!entry.isDirectory()) {
                int index = path.lastIndexOf(47);
                String name = index >= 0 ? path.substring(index + 1) : path;
                String home = index >= 0 ? path.substring(0, index + 1) : "/";
                DirEntry parent = this.getDir((Map)dirs, home);
                Predef$.MODULE$.assert(!parent.entries().contains((Object)path), (Object)(this.toString() + " - " + path));
                parent.entries().update((Object)name, (Object)new FileEntry(this, name, path, entry));
                continue;
            }
            DirEntry dir = this.getDir((Map)dirs, path);
            Predef$.MODULE$.assert(dir.entry() == null, (Object)(this.toString() + " - " + path));
            dir.entry_$eq(entry);
        }
        return;
    }

    public AbstractFile lookupName(String name, boolean directory) {
        if (this.root() == null) {
            this.load();
        }
        return this.root().lookupName(name, directory);
    }

    public Iterator elements() {
        if (this.root() == null) {
            this.load();
        }
        return this.root().elements();
    }

    public boolean isDirectory() {
        return true;
    }

    private void root_$eq(DirEntry x$1) {
        this.root = x$1;
    }

    private DirEntry root() {
        return this.root;
    }

    public ZipFile archive() {
        return this.archive;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public final class DirEntry
    extends Entry
    implements ScalaObject {
        private ZipEntry entry;
        private Map entries = new HashMap();

        public DirEntry(ZipArchive $outer, String name, String path) {
            super($outer, name, path);
        }

        public InputStream read() {
            this.read();
            return null;
        }

        public /* synthetic */ ZipArchive scala$tools$nsc$io$ZipArchive$DirEntry$$$outer() {
            return this.$outer;
        }

        public AbstractFile lookupName(String name, boolean directory) {
            AbstractFile abstractFile;
            Option option = this.entries().get((Object)(!directory ? name : name + "/"));
            if (!(option instanceof Some)) {
                if (option != None$.MODULE$) {
                    throw new MatchError((Object)option);
                }
                abstractFile = null;
            } else {
                abstractFile = (AbstractFile)((Some)option).x();
            }
            return abstractFile;
        }

        public Iterator elements() {
            return this.entries().values();
        }

        public long lastModified() {
            return this.entry() != null ? this.entry().getTime() : super.lastModified();
        }

        public Nothing$ read() {
            throw new Error("cannot read directories");
        }

        public boolean isDirectory() {
            return true;
        }

        public void entry_$eq(ZipEntry x$1) {
            this.entry = x$1;
        }

        public ZipEntry entry() {
            return this.entry;
        }

        public Map entries() {
            return this.entries;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public final class FileEntry
    extends Entry
    implements ScalaObject {
        private ZipEntry entry;

        public FileEntry(ZipArchive $outer, String name, String path, ZipEntry entry) {
            this.entry = entry;
            super($outer, name, path);
        }

        public Option size() {
            return this.size();
        }

        public /* synthetic */ ZipArchive scala$tools$nsc$io$ZipArchive$FileEntry$$$outer() {
            return this.$outer;
        }

        public Some size() {
            return new Some((Object)BoxesUtility.boxToInteger((int)((int)this.entry().getSize())));
        }

        public InputStream read() {
            return this.archive().getInputStream(this.entry());
        }

        public long lastModified() {
            return this.entry().getTime();
        }

        public ZipFile archive() {
            return this.scala$tools$nsc$io$ZipArchive$FileEntry$$$outer().archive();
        }

        public ZipEntry entry() {
            return this.entry;
        }
    }

    public abstract class Entry
    extends VirtualFile
    implements ScalaObject {
        public /* synthetic */ ZipArchive $outer;

        public Entry(ZipArchive $outer, String name, String path) {
            if ($outer != null) {
                this.$outer = $outer;
                super(name, path);
                return;
            }
            throw new NullPointerException();
        }

        public /* synthetic */ ZipArchive scala$tools$nsc$io$ZipArchive$Entry$$$outer() {
            return this.$outer;
        }

        public final ZipFile getArchive() {
            return this.scala$tools$nsc$io$ZipArchive$Entry$$$outer().archive();
        }

        public final String path() {
            return this.scala$tools$nsc$io$ZipArchive$Entry$$$outer().toString() + "(" + super.path() + ")";
        }
    }
}

