/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.PEModule;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.util.PESection;
import ch.epfl.lamp.compiler.msil.util.PEStream;
import ch.epfl.lamp.compiler.msil.util.Signature;
import ch.epfl.lamp.compiler.msil.util.Table;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;

public class PEFile {
    public static final int INT_SIZE = 4;
    protected final int PE_SIGNATURE_OFFSET;
    protected final int COFF_HEADER_OFFSET;
    protected final int PE_HEADER_OFFSET;
    protected final int numOfSections;
    protected final int CLI_RVA;
    protected final int CLI_Length;
    public final int rvaMetadata;
    public final int posMetadata;
    protected final int numOfStreams;
    protected final int optHeaderSize;
    protected final File underlyingFile;
    protected final RandomAccessFile file;
    protected final MappedByteBuffer buf;
    protected final PESection[] sections;
    public PEStream Meta;
    public PEStream Strings;
    public PEStream US;
    public PEStream Blob;
    public PEStream GUID;
    private final Table[] tables = new Table[64];
    public final boolean isDLL;
    protected final int heapSizes;
    public final boolean StringIsShort;
    public final boolean BlobIsShort;
    public final boolean GUIDIsShort;
    protected PEModule pemodule = null;
    public final int[] indexSize = new int[12];
    public Table.ModuleDef ModuleDef;
    public Table.TypeRef TypeRef;
    public Table.TypeDef TypeDef;
    public Table.FieldTrans FieldTrans;
    public Table.FieldDef FieldDef;
    public Table.MethodTrans MethodTrans;
    public Table.MethodDef MethodDef;
    public Table.ParamDef ParamDef;
    public Table.InterfaceImpl InterfaceImpl;
    public Table.MemberRef MemberRef;
    public Table.Constant Constant;
    public Table.CustomAttribute CustomAttribute;
    public Table.FieldMarshal FieldMarshal;
    public Table.DeclSecurity DeclSecurity;
    public Table.ClassLayout ClassLayout;
    public Table.FieldLayout FieldLayout;
    public Table.StandAloneSig StandAloneSig;
    public Table.EventMap EventMap;
    public Table.EventDef EventDef;
    public Table.PropertyMap PropertyMap;
    public Table.PropertyDef PropertyDef;
    public Table.MethodSemantics MethodSemantics;
    public Table.MethodImpl MethodImpl;
    public Table.ModuleRef ModuleRef;
    public Table.TypeSpec TypeSpec;
    public Table.ImplMap ImplMap;
    public Table.FieldRVA FieldRVA;
    public Table.AssemblyDef AssemblyDef;
    public Table.AssemblyRef AssemblyRef;
    public Table.FileDef FileDef;
    public Table.ExportedType ExportedType;
    public Table.ManifestResource ManifestResource;
    public Table.NestedClass NestedClass;

    private static void fileFormatCheck(boolean bl, String string) {
        if (bl) {
            throw new RuntimeException(string);
        }
    }

    public PEFile(String string) throws FileNotFoundException {
        int n;
        this.underlyingFile = new File(string);
        this.file = new RandomAccessFile(this.underlyingFile, "r");
        FileChannel fileChannel = this.file.getChannel();
        MappedByteBuffer mappedByteBuffer = null;
        try {
            mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buf = mappedByteBuffer;
        this.seek(0);
        PEFile.fileFormatCheck(this.readByte() != 77, "Invalid PE file format: " + string);
        PEFile.fileFormatCheck(this.readByte() != 90, "Invalid PE file format: " + string);
        this.seek(60);
        this.PE_SIGNATURE_OFFSET = this.readInt();
        this.seek(this.PE_SIGNATURE_OFFSET);
        PEFile.fileFormatCheck(this.readByte() != 80, "Invalid PE file format: " + string);
        PEFile.fileFormatCheck(this.readByte() != 69, "Invalid PE file format: " + string);
        this.COFF_HEADER_OFFSET = this.PE_SIGNATURE_OFFSET + 4;
        this.PE_HEADER_OFFSET = this.COFF_HEADER_OFFSET + 20;
        this.seek(this.COFF_HEADER_OFFSET);
        this.skip(2);
        this.numOfSections = this.readShort();
        Date date = new Date((long)this.readInt() * 1000L);
        this.skip(8);
        this.optHeaderSize = this.readShort();
        int n2 = this.readShort();
        this.isDLL = (n2 & 0x2000) != 0;
        this.seek(this.PE_HEADER_OFFSET + 208);
        this.CLI_RVA = this.readInt();
        this.CLI_Length = this.readInt();
        this.sections = new PESection[this.numOfSections];
        this.seek(this.PE_HEADER_OFFSET + this.optHeaderSize);
        for (n = 0; n < this.numOfSections; ++n) {
            this.seek(this.PE_HEADER_OFFSET + this.optHeaderSize + n * 40);
            this.sections[n] = new PESection(this);
        }
        this.seek(this.fromRVA(this.CLI_RVA));
        this.skip(8);
        this.rvaMetadata = this.readInt();
        this.posMetadata = this.fromRVA(this.rvaMetadata);
        this.seek(this.posMetadata);
        n = this.readInt();
        PEFile.fileFormatCheck(n != 1112167234, "Invalid metadata signature!");
        this.skip(8);
        int n3 = this.readInt();
        this.skip(n3);
        this.align(4, this.posMetadata);
        this.skip(2);
        this.numOfStreams = this.readShort();
        for (int i = 0; i < this.numOfStreams; ++i) {
            PEStream pEStream = new PEStream(this);
            if (pEStream.name.equals("#~") || pEStream.name.equals("#-")) {
                this.Meta = pEStream;
            }
            if (pEStream.name.equals("#Strings")) {
                this.Strings = pEStream;
            }
            if (pEStream.name.equals("#US")) {
                this.US = pEStream;
            }
            if (pEStream.name.equals("#Blob")) {
                this.Blob = pEStream;
            }
            if (!pEStream.name.equals("#GUID")) continue;
            this.GUID = pEStream;
        }
        this.seek(this.Meta.offset);
        this.skip(6);
        this.heapSizes = this.readByte();
        this.StringIsShort = (this.heapSizes & 1) == 0;
        this.GUIDIsShort = (this.heapSizes & 2) == 0;
        this.BlobIsShort = (this.heapSizes & 4) == 0;
        this.skip(1);
        long l = this.readLong();
        long l2 = l & 0xFFFFFC00C04800A8L;
        this.skip(8);
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i] = Table.newTable(this, i, (l >> i & 1L) != 0L ? this.readInt() : 0);
        }
        this.initIndexSize();
        this.initTableRefs();
        long l3 = this.pos();
        for (int i = 0; i < this.tables.length; ++i) {
            l3 = this.tables[i].init(l3);
        }
    }

    private void initIndexSize() {
        block0: for (int i = 0; i < 12; ++i) {
            this.indexSize[i] = 2;
            int[] nArray = Table.TableSet[i];
            int n = 65536 >> Table.NoBits[i];
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] < 0) continue;
                Table table = this.tables[nArray[j]];
                if (table.rows < n) continue;
                this.indexSize[i] = 4;
                continue block0;
            }
        }
    }

    protected void initModule(PEModule pEModule) {
        if (this.pemodule != null) {
            throw new RuntimeException("File " + this + " has already been assigned module " + this.pemodule + "; new module is " + pEModule);
        }
        this.pemodule = pEModule;
    }

    public Table.ModuleDef ModuleDef(int n) {
        this.ModuleDef.readRow(n);
        return this.ModuleDef;
    }

    public Table.TypeDef TypeDef(int n) {
        this.TypeDef.readRow(n);
        return this.TypeDef;
    }

    public Table.FieldTrans FieldTrans(int n) {
        this.FieldTrans.readRow(n);
        return this.FieldTrans;
    }

    public Table.FieldDef FieldDef(int n) {
        this.FieldDef.readRow(n);
        return this.FieldDef;
    }

    public Table.MethodTrans MethodTrans(int n) {
        this.MethodTrans.readRow(n);
        return this.MethodTrans;
    }

    public Table.MethodDef MethodDef(int n) {
        this.MethodDef.readRow(n);
        return this.MethodDef;
    }

    public Table.ParamDef ParamDef(int n) {
        this.ParamDef.readRow(n);
        return this.ParamDef;
    }

    private void initTableRefs() {
        this.ModuleDef = (Table.ModuleDef)this.getTable(0);
        this.TypeRef = (Table.TypeRef)this.getTable(1);
        this.TypeDef = (Table.TypeDef)this.getTable(2);
        this.FieldTrans = (Table.FieldTrans)this.getTable(3);
        this.FieldDef = (Table.FieldDef)this.getTable(4);
        this.MethodTrans = (Table.MethodTrans)this.getTable(5);
        this.MethodDef = (Table.MethodDef)this.getTable(6);
        this.ParamDef = (Table.ParamDef)this.getTable(8);
        this.InterfaceImpl = (Table.InterfaceImpl)this.getTable(9);
        this.MemberRef = (Table.MemberRef)this.getTable(10);
        this.Constant = (Table.Constant)this.getTable(11);
        this.CustomAttribute = (Table.CustomAttribute)this.getTable(12);
        this.FieldMarshal = (Table.FieldMarshal)this.getTable(13);
        this.DeclSecurity = (Table.DeclSecurity)this.getTable(14);
        this.ClassLayout = (Table.ClassLayout)this.getTable(15);
        this.FieldLayout = (Table.FieldLayout)this.getTable(16);
        this.StandAloneSig = (Table.StandAloneSig)this.getTable(17);
        this.EventMap = (Table.EventMap)this.getTable(18);
        this.EventDef = (Table.EventDef)this.getTable(20);
        this.PropertyMap = (Table.PropertyMap)this.getTable(21);
        this.PropertyDef = (Table.PropertyDef)this.getTable(23);
        this.MethodSemantics = (Table.MethodSemantics)this.getTable(24);
        this.MethodImpl = (Table.MethodImpl)this.getTable(25);
        this.ModuleRef = (Table.ModuleRef)this.getTable(26);
        this.TypeSpec = (Table.TypeSpec)this.getTable(27);
        this.ImplMap = (Table.ImplMap)this.getTable(28);
        this.FieldRVA = (Table.FieldRVA)this.getTable(29);
        this.AssemblyDef = (Table.AssemblyDef)this.getTable(32);
        this.AssemblyRef = (Table.AssemblyRef)this.getTable(35);
        this.FileDef = (Table.FileDef)this.getTable(38);
        this.ExportedType = (Table.ExportedType)this.getTable(39);
        this.NestedClass = (Table.NestedClass)this.getTable(41);
        this.ManifestResource = (Table.ManifestResource)this.getTable(40);
    }

    public static String long2hex(long l) {
        StringBuffer stringBuffer = new StringBuffer("0000000000000000");
        stringBuffer.append(Long.toHexString(l));
        int n = stringBuffer.length();
        return stringBuffer.substring(n - 16, n);
    }

    public static String int2hex(int n) {
        StringBuffer stringBuffer = new StringBuffer("00000000");
        stringBuffer.append(Integer.toHexString(n));
        int n2 = stringBuffer.length();
        return stringBuffer.substring(n2 - 8, n2);
    }

    public static String short2hex(int n) {
        StringBuffer stringBuffer = new StringBuffer("0000");
        stringBuffer.append(Integer.toHexString(n));
        int n2 = stringBuffer.length();
        return stringBuffer.substring(n2 - 4, n2);
    }

    public static String byte2hex(int n) {
        StringBuffer stringBuffer = new StringBuffer("00");
        stringBuffer.append(Integer.toHexString(n));
        int n2 = stringBuffer.length();
        return stringBuffer.substring(n2 - 2, n2);
    }

    public static String bytes2hex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(PEFile.byte2hex(byArray[i]));
            if (i >= byArray.length - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public File getUnderlyingFile() {
        return this.underlyingFile;
    }

    public String getAbsolutePath() {
        return this.underlyingFile.getAbsolutePath();
    }

    public String getName() {
        return this.underlyingFile.getName();
    }

    public String getParent() {
        return this.underlyingFile.getParent();
    }

    public File getParentFile() {
        return this.underlyingFile.getParentFile();
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    public int pos() {
        return this.buf.position();
    }

    public void seek(int n) {
        this.buf.position(n);
    }

    public void align(int n) {
        this.align(n, 0);
    }

    public void align(int n, int n2) {
        int n3 = this.pos() - n2;
        this.seek(n2 + (n3 % n == 0 ? n3 : (n3 / n + 1) * n));
    }

    public int fromRVA(int n) {
        for (int i = 0; i < this.numOfSections; ++i) {
            if (this.sections[i].virtAddr > n || n > this.sections[i].virtAddr + this.sections[i].virtSize) continue;
            return n - this.sections[i].virtAddr + this.sections[i].realAddr;
        }
        throw new RuntimeException("RVA 0x" + Integer.toHexString(n) + " is not within this file's sections!");
    }

    public void gotoRVA(int n) {
        this.seek(this.fromRVA(n));
    }

    public void skip(int n) {
        this.buf.position(this.buf.position() + n);
    }

    public MappedByteBuffer mapBuffer(long l, int n) {
        try {
            MappedByteBuffer mappedByteBuffer = this.file.getChannel().map(FileChannel.MapMode.READ_ONLY, l, n);
            mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            return mappedByteBuffer;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public ByteBuffer getBuffer(long l, int n) {
        this.buf.mark();
        this.buf.position((int)l);
        ByteBuffer byteBuffer = this.buf.slice();
        this.buf.reset();
        byteBuffer.limit(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    public void read(byte[] byArray) {
        this.buf.get(byArray);
    }

    public int readByte() {
        return this.buf.get();
    }

    public int readShort() {
        return this.buf.getShort();
    }

    public int readInt() {
        return this.buf.getInt();
    }

    public long readLong() {
        return this.buf.getLong();
    }

    public int getStringIndexSize() {
        return this.StringIsShort ? 2 : 4;
    }

    public int getGUIDIndexSize() {
        return this.GUIDIsShort ? 2 : 4;
    }

    public int getBlobIndexSize() {
        return this.BlobIsShort ? 2 : 4;
    }

    public int getTableIndexSize(int n) {
        return this.tables[n].isShort ? 2 : 4;
    }

    public int getTableSetIndexSize(int n) {
        return this.indexSize[n];
    }

    public int readStringIndex() {
        return this.StringIsShort ? this.readShort() : this.readInt();
    }

    public int readGUIDIndex() {
        return this.GUIDIsShort ? this.readShort() : this.readInt();
    }

    public int readBlobIndex() {
        return this.BlobIsShort ? this.readShort() : this.readInt();
    }

    public int readTableIndex(int n) {
        return this.tables[n].isShort ? this.readShort() : this.readInt();
    }

    public int readTableSetIndex(int n) {
        return this.indexSize[n] == 2 ? this.readShort() : this.readInt();
    }

    public String getString(int n) {
        String string = this.Strings.getString(n);
        return string;
    }

    public String getUString(int n) {
        return this.US.getString(n);
    }

    public byte[] getBlob(int n) {
        return this.Blob.getBlob(n);
    }

    public Sig getSignature(int n) {
        return this.Blob.getSignature(n);
    }

    public byte[] getGUID(int n) {
        return this.GUID.getGUID(n);
    }

    public final Table getTable(int n) {
        return this.tables[n];
    }

    void trace(String string) {
        System.out.println("[trace] " + string);
    }

    public Sig newSignature(ByteBuffer byteBuffer) {
        return new Sig(byteBuffer);
    }

    public class Sig
    implements Signature {
        protected final ByteBuffer buf;
        protected final int pos;
        protected final int length;

        public Sig(ByteBuffer byteBuffer) {
            this.buf = byteBuffer;
            this.length = this.decodeInt();
            this.pos = byteBuffer.position();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("(");
            this.reset();
            for (int i = 0; i < this.length; ++i) {
                stringBuffer.append(PEFile.byte2hex(this.readByte()));
                if (i >= this.length - 1) continue;
                stringBuffer.append(" ");
            }
            return stringBuffer.append(")").toString();
        }

        public Sig reset() {
            this.buf.position(this.pos);
            return this;
        }

        public int pos() {
            return this.buf.position() - this.pos;
        }

        public int getByte() {
            return this.buf.get(this.buf.position()) + 256 & 0xFF;
        }

        public int readByte() {
            return this.buf.get() + 256 & 0xFF;
        }

        public void skipByte(int n) {
            if (n == this.getByte()) {
                this.buf.get();
            }
        }

        public int decodeInt() {
            int n = this.readByte();
            if ((n & 0x80) != 0 && ((n = (n & 0x7F) << 8 | this.readByte()) & 0x4000) != 0) {
                n = (n & 0x3FFF) << 16 | this.readByte() << 8 | this.readByte();
            }
            return n;
        }

        public Type decodeType() {
            try {
                return this.decodeType0();
            }
            catch (RuntimeException runtimeException) {
                System.out.println("" + this.pos() + "@" + this);
                throw runtimeException;
            }
        }

        public Type decodeType0() {
            Type type = null;
            int n = this.readByte();
            switch (n) {
                case 2: {
                    type = Type.GetType("System.Boolean");
                    break;
                }
                case 3: {
                    type = Type.GetType("System.Char");
                    break;
                }
                case 4: {
                    type = Type.GetType("System.SByte");
                    break;
                }
                case 5: {
                    type = Type.GetType("System.Byte");
                    break;
                }
                case 6: {
                    type = Type.GetType("System.Int16");
                    break;
                }
                case 7: {
                    type = Type.GetType("System.UInt16");
                    break;
                }
                case 8: {
                    type = Type.GetType("System.Int32");
                    break;
                }
                case 9: {
                    type = Type.GetType("System.UInt32");
                    break;
                }
                case 10: {
                    type = Type.GetType("System.Int64");
                    break;
                }
                case 11: {
                    type = Type.GetType("System.UInt64");
                    break;
                }
                case 12: {
                    type = Type.GetType("System.Single");
                    break;
                }
                case 13: {
                    type = Type.GetType("System.Double");
                    break;
                }
                case 28: {
                    type = Type.GetType("System.Object");
                    break;
                }
                case 14: {
                    type = Type.GetType("System.String");
                    break;
                }
                case 24: {
                    type = Type.GetType("System.IntPtr");
                    break;
                }
                case 25: {
                    type = Type.GetType("System.UIntPtr");
                    break;
                }
                case 15: {
                    if (this.getByte() == 1) {
                        this.readByte();
                        type = Type.mkPtr(Type.GetType("System.Void"));
                        break;
                    }
                    type = Type.mkPtr(this.decodeType());
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    type = PEFile.this.pemodule.getTypeDefOrRef(this.decodeInt());
                    if (type != null) break;
                    throw new RuntimeException();
                }
                case 29: {
                    this.skipCustomMods();
                    type = Type.mkArray(this.decodeType(), 1);
                    break;
                }
                case 20: {
                    int n2;
                    Type type2 = this.decodeType();
                    int n3 = this.decodeInt();
                    int n4 = this.decodeInt();
                    for (n2 = 0; n2 < n4; ++n2) {
                        this.decodeInt();
                    }
                    n2 = this.decodeInt();
                    for (int i = 0; i < n2; ++i) {
                        this.decodeInt();
                    }
                    type = Type.mkArray(type2, n3);
                    break;
                }
                default: {
                    throw new RuntimeException(PEFile.byte2hex(n) + "@" + this.pos() + " in " + this);
                }
            }
            if (type == null) {
                throw new RuntimeException();
            }
            return type;
        }

        public Type decodeFieldType() {
            this.skipByte(6);
            this.skipCustomMods();
            return this.decodeType();
        }

        public Type decodeRetType() {
            this.skipCustomMods();
            switch (this.getByte()) {
                case 1: {
                    this.readByte();
                    return Type.GetType("System.Void");
                }
                case 22: {
                    return Type.GetType("System.TypedReference");
                }
                case 16: {
                    this.skipByte(16);
                    return this.decodeType();
                }
            }
            return this.decodeType();
        }

        public Type decodeParamType() {
            this.skipCustomMods();
            switch (this.getByte()) {
                case 16: {
                    this.skipByte(16);
                    return this.decodeType();
                }
                case 22: {
                    return Type.GetType("System.TypedReference");
                }
            }
            return this.decodeType();
        }

        public void skipCustomMods() {
            while (this.getByte() == 32 || this.getByte() == 31) {
                Type type = this.decodeType();
                System.err.println("CMOD: " + type);
                if (this.getByte() != 31) continue;
                throw new RuntimeException("Reqired CMOD: " + type);
            }
        }
    }
}

